/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.io.VersionedWritable;
import org.apache.hadoop.io.WritableComparable;

public class HRegionInfo
extends VersionedWritable
implements WritableComparable<HRegionInfo> {
    private static final byte VERSION = 0;
    public static final int DELIMITER = 44;
    public static final HRegionInfo ROOT_REGIONINFO = new HRegionInfo(0L, HTableDescriptor.ROOT_TABLEDESC);
    public static final HRegionInfo FIRST_META_REGIONINFO = new HRegionInfo(1L, HTableDescriptor.META_TABLEDESC);
    private byte[] endKey = HConstants.EMPTY_BYTE_ARRAY;
    private boolean offLine = false;
    private long regionId = -1L;
    private transient byte[] regionName = HConstants.EMPTY_BYTE_ARRAY;
    private String regionNameStr = "";
    private boolean split = false;
    private byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
    protected HTableDescriptor tableDesc = null;
    private int hashCode = -1;
    public static final int NO_HASH = -1;
    private volatile int encodedName = -1;

    public static int encodeRegionName(byte[] regionName) {
        return Math.abs(JenkinsHash.getInstance().hash(regionName, regionName.length, 0));
    }

    private void setHashCode() {
        int result = Arrays.hashCode(this.regionName);
        result = (int)((long)result ^ this.regionId);
        result ^= Arrays.hashCode(this.startKey);
        result ^= Arrays.hashCode(this.endKey);
        result ^= Boolean.valueOf(this.offLine).hashCode();
        this.hashCode = result ^= this.tableDesc.hashCode();
    }

    private HRegionInfo(long regionId, HTableDescriptor tableDesc) {
        this.regionId = regionId;
        this.tableDesc = tableDesc;
        this.regionName = HRegionInfo.createRegionName(tableDesc.getName(), null, regionId);
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.setHashCode();
    }

    public HRegionInfo() {
        this.tableDesc = new HTableDescriptor();
    }

    public HRegionInfo(HTableDescriptor tableDesc, byte[] startKey, byte[] endKey) throws IllegalArgumentException {
        this(tableDesc, startKey, endKey, false);
    }

    public HRegionInfo(HTableDescriptor tableDesc, byte[] startKey, byte[] endKey, boolean split) throws IllegalArgumentException {
        this(tableDesc, startKey, endKey, split, System.currentTimeMillis());
    }

    public HRegionInfo(HTableDescriptor tableDesc, byte[] startKey, byte[] endKey, boolean split, long regionid) throws IllegalArgumentException {
        if (tableDesc == null) {
            throw new IllegalArgumentException("tableDesc cannot be null");
        }
        this.offLine = false;
        this.regionId = regionid;
        this.regionName = HRegionInfo.createRegionName(tableDesc.getName(), startKey, this.regionId);
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.split = split;
        this.endKey = endKey == null ? HConstants.EMPTY_END_ROW : (byte[])endKey.clone();
        this.startKey = startKey == null ? HConstants.EMPTY_START_ROW : (byte[])startKey.clone();
        this.tableDesc = tableDesc;
        this.setHashCode();
    }

    public HRegionInfo(HRegionInfo other) {
        this.endKey = other.getEndKey();
        this.offLine = other.isOffline();
        this.regionId = other.getRegionId();
        this.regionName = other.getRegionName();
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.split = other.isSplit();
        this.startKey = other.getStartKey();
        this.tableDesc = other.getTableDesc();
        this.hashCode = other.hashCode();
        this.encodedName = other.getEncodedName();
    }

    private static byte[] createRegionName(byte[] tableName, byte[] startKey, long regionid) {
        return HRegionInfo.createRegionName(tableName, startKey, Long.toString(regionid));
    }

    public static byte[] createRegionName(byte[] tableName, byte[] startKey, String id) {
        return HRegionInfo.createRegionName(tableName, startKey, Bytes.toBytes(id));
    }

    public static byte[] createRegionName(byte[] tableName, byte[] startKey, byte[] id) {
        byte[] b = new byte[tableName.length + 2 + id.length + (startKey == null ? 0 : startKey.length)];
        int offset = tableName.length;
        System.arraycopy(tableName, 0, b, 0, offset);
        b[offset++] = 44;
        if (startKey != null && startKey.length > 0) {
            System.arraycopy(startKey, 0, b, offset, startKey.length);
            offset += startKey.length;
        }
        b[offset++] = 44;
        System.arraycopy(id, 0, b, offset, id.length);
        return b;
    }

    public static byte[][] parseRegionName(byte[] regionName) throws IOException {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format");
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        offset = -1;
        for (int i = regionName.length - 1; i > 0; --i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format");
        }
        byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        if (offset != tableName.length + 1) {
            startKey = new byte[offset - tableName.length - 1];
            System.arraycopy(regionName, tableName.length + 1, startKey, 0, offset - tableName.length - 1);
        }
        byte[] id = new byte[regionName.length - offset - 1];
        System.arraycopy(regionName, offset + 1, id, 0, regionName.length - offset - 1);
        byte[][] elements = new byte[][]{tableName, startKey, id};
        return elements;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    public long getRegionId() {
        return this.regionId;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public String getRegionNameAsString() {
        return this.regionNameStr;
    }

    public synchronized int getEncodedName() {
        if (this.encodedName == -1) {
            this.encodedName = HRegionInfo.encodeRegionName(this.regionName);
        }
        return this.encodedName;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public HTableDescriptor getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(HTableDescriptor newDesc) {
        this.tableDesc = newDesc;
    }

    public boolean isRootRegion() {
        return this.tableDesc.isRootRegion();
    }

    public boolean isMetaTable() {
        return this.tableDesc.isMetaTable();
    }

    public boolean isMetaRegion() {
        return this.tableDesc.isMetaRegion();
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public boolean isOffline() {
        return this.offLine;
    }

    public void setOffline(boolean offLine) {
        this.offLine = offLine;
    }

    public String toString() {
        return "REGION => {NAME => '" + this.regionNameStr + "', STARTKEY => '" + Bytes.toStringBinary(this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary(this.endKey) + "', ENCODED => " + this.getEncodedName() + "," + (this.isOffline() ? " OFFLINE => true," : "") + (this.isSplit() ? " SPLIT => true," : "") + " TABLE => {" + this.tableDesc.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionInfo)) {
            return false;
        }
        return this.compareTo((HRegionInfo)((Object)o)) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public byte getVersion() {
        return 0;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray(out, this.endKey);
        out.writeBoolean(this.offLine);
        out.writeLong(this.regionId);
        Bytes.writeByteArray(out, this.regionName);
        out.writeBoolean(this.split);
        Bytes.writeByteArray(out, this.startKey);
        this.tableDesc.write(out);
        out.writeInt(this.hashCode);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.endKey = Bytes.readByteArray(in);
        this.offLine = in.readBoolean();
        this.regionId = in.readLong();
        this.regionName = Bytes.readByteArray(in);
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.split = in.readBoolean();
        this.startKey = Bytes.readByteArray(in);
        this.tableDesc.readFields(in);
        this.hashCode = in.readInt();
    }

    public int compareTo(HRegionInfo o) {
        if (o == null) {
            return 1;
        }
        int result = this.tableDesc.compareTo(o.tableDesc);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(this.startKey, o.startKey);
        if (result != 0) {
            return result;
        }
        return Bytes.compareTo(this.endKey, o.endKey);
    }

    public KeyValue.KVComparator getComparator() {
        return this.isRootRegion() ? KeyValue.ROOT_COMPARATOR : (this.isMetaRegion() ? KeyValue.META_COMPARATOR : KeyValue.COMPARATOR);
    }
}

