/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ColumnNameParseException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class HStoreKey
implements WritableComparable<HStoreKey>,
HeapSize {
    public static final char COLUMN_FAMILY_DELIMITER = ':';
    public static final int ESTIMATED_HEAP_TAX = 48;
    private byte[] row = HConstants.EMPTY_BYTE_ARRAY;
    private byte[] column = HConstants.EMPTY_BYTE_ARRAY;
    private long timestamp = Long.MAX_VALUE;
    private static final StoreKeyComparator PLAIN_COMPARATOR = new StoreKeyComparator();
    private static final StoreKeyComparator META_COMPARATOR = new MetaStoreKeyComparator();
    private static final StoreKeyComparator ROOT_COMPARATOR = new RootStoreKeyComparator();

    public HStoreKey() {
    }

    public HStoreKey(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public HStoreKey(String row) {
        this(Bytes.toBytes(row), Long.MAX_VALUE);
    }

    public HStoreKey(byte[] row, long timestamp) {
        this(row, HConstants.EMPTY_BYTE_ARRAY, timestamp);
    }

    public HStoreKey(String row, String column) {
        this(row, column, Long.MAX_VALUE);
    }

    public HStoreKey(byte[] row, byte[] column) {
        this(row, column, Long.MAX_VALUE);
    }

    public HStoreKey(String row, String column, long timestamp) {
        this(Bytes.toBytes(row), Bytes.toBytes(column), timestamp);
    }

    public HStoreKey(byte[] row, byte[] column, long timestamp) {
        this.row = row;
        this.column = column;
        this.timestamp = timestamp;
    }

    public HStoreKey(HStoreKey other) {
        this(other.getRow(), other.getColumn(), other.getTimestamp());
    }

    public HStoreKey(ByteBuffer bb) {
        this(HStoreKey.getRow(bb), HStoreKey.getColumn(bb), HStoreKey.getTimestamp(bb));
    }

    public void setRow(byte[] newrow) {
        this.row = newrow;
    }

    public void setColumn(byte[] c) {
        this.column = c;
    }

    public void setVersion(long timestamp) {
        this.timestamp = timestamp;
    }

    public void set(HStoreKey k) {
        this.row = k.getRow();
        this.column = k.getColumn();
        this.timestamp = k.getTimestamp();
    }

    public byte[] getRow() {
        return this.row;
    }

    public byte[] getColumn() {
        return this.column;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean matchesRowCol(HStoreKey other) {
        return HStoreKey.equalsTwoRowKeys(this.getRow(), other.getRow()) && Bytes.equals(this.getColumn(), other.getColumn());
    }

    public boolean matchesWithoutColumn(HStoreKey other) {
        return HStoreKey.equalsTwoRowKeys(this.getRow(), other.getRow()) && this.getTimestamp() >= other.getTimestamp();
    }

    public boolean matchesRowFamily(HStoreKey that) {
        int delimiterIndex = HStoreKey.getFamilyDelimiterIndex(this.getColumn());
        return HStoreKey.equalsTwoRowKeys(this.getRow(), that.getRow()) && Bytes.compareTo(this.getColumn(), 0, delimiterIndex, that.getColumn(), 0, delimiterIndex) == 0;
    }

    public String toString() {
        return Bytes.toString(this.row) + "/" + Bytes.toString(this.column) + "/" + this.timestamp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HStoreKey other = (HStoreKey)obj;
        if (this.row.length != other.row.length || this.column.length != other.column.length || this.timestamp != other.timestamp) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int c = Bytes.hashCode(this.getRow());
        c ^= Bytes.hashCode(this.getColumn());
        c = (int)((long)c ^ this.getTimestamp());
        return c;
    }

    @Deprecated
    public int compareTo(HStoreKey o) {
        return HStoreKey.compareTo(this, o);
    }

    @Deprecated
    static int compareTo(HStoreKey left, HStoreKey right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int result = Bytes.compareTo(left.getRow(), right.getRow());
        if (result != 0) {
            return result;
        }
        int n = left.getColumn() == null && right.getColumn() == null ? 0 : (left.getColumn() == null && right.getColumn() != null ? -1 : (result = left.getColumn() != null && right.getColumn() == null ? 1 : Bytes.compareTo(left.getColumn(), right.getColumn())));
        if (result != 0) {
            return result;
        }
        if (left.getTimestamp() < right.getTimestamp()) {
            result = 1;
        } else if (left.getTimestamp() > right.getTimestamp()) {
            result = -1;
        }
        return result;
    }

    public static byte[] getFamily(byte[] column) throws ColumnNameParseException {
        int index = HStoreKey.getFamilyDelimiterIndex(column);
        if (index <= 0) {
            throw new ColumnNameParseException("Missing ':' delimiter between column family and qualifier in the passed column name <" + Bytes.toString(column) + ">");
        }
        byte[] result = new byte[index];
        System.arraycopy(column, 0, result, 0, index);
        return result;
    }

    public static Integer getFamilyMapKey(byte[] column) {
        int index = HStoreKey.getFamilyDelimiterIndex(column);
        return Bytes.mapKey(column, index > 0 ? index : column.length);
    }

    public static boolean matchingFamily(byte[] family, byte[] column) {
        int index = HStoreKey.getFamilyDelimiterIndex(column);
        if (index != family.length) {
            return false;
        }
        return Bytes.compareTo(family, 0, index, column, 0, index) == 0;
    }

    public static byte[] addDelimiter(byte[] family) {
        byte[] familyPlusDelimiter = new byte[family.length + 1];
        System.arraycopy(family, 0, familyPlusDelimiter, 0, family.length);
        familyPlusDelimiter[family.length] = 58;
        return familyPlusDelimiter;
    }

    public static byte[] getQualifier(byte[] column) {
        int index = HStoreKey.getFamilyDelimiterIndex(column);
        int len = column.length - (index + 1);
        byte[] result = new byte[len];
        System.arraycopy(column, index + 1, result, 0, len);
        return result;
    }

    public static byte[][] parseColumn(byte[] c) throws ColumnNameParseException {
        byte[][] result = new byte[2][];
        int index = HStoreKey.getFamilyDelimiterIndex(c);
        if (index == -1) {
            throw new ColumnNameParseException("Impossible column name: " + Bytes.toString(c));
        }
        result[0] = new byte[index];
        System.arraycopy(c, 0, result[0], 0, index);
        int len = c.length - (index + 1);
        result[1] = new byte[len];
        System.arraycopy(c, index + 1, result[1], 0, len);
        return result;
    }

    public static int getFamilyDelimiterIndex(byte[] b) {
        return HStoreKey.getDelimiter(b, 0, b.length, 58);
    }

    static int getRequiredDelimiterInReverse(byte[] b, int offset, int length, int delimiter) {
        int index = HStoreKey.getDelimiterInReverse(b, offset, length, delimiter);
        if (index < 0) {
            throw new IllegalArgumentException("No " + delimiter + " in <" + Bytes.toString(b) + ">" + ", length=" + length + ", offset=" + offset);
        }
        return index;
    }

    static int getDelimiter(byte[] b, int offset, int length, int delimiter) {
        if (b == null) {
            throw new NullPointerException();
        }
        int result = -1;
        for (int i = offset; i < length + offset; ++i) {
            if (b[i] != delimiter) continue;
            result = i;
            break;
        }
        return result;
    }

    private static int getDelimiterInReverse(byte[] b, int offset, int length, int delimiter) {
        if (b == null) {
            throw new NullPointerException();
        }
        int result = -1;
        for (int i = offset + length - 1; i >= offset; --i) {
            if (b[i] != delimiter) continue;
            result = i;
            break;
        }
        return result;
    }

    public static boolean equalsTwoRowKeys(byte[] rowA, byte[] rowB) {
        return rowA == null && rowB == null ? true : (rowA == null || rowB == null || rowA.length != rowB.length ? false : Bytes.compareTo(rowA, rowB) == 0);
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.row);
        Bytes.writeByteArray(out, this.column);
        out.writeLong(this.timestamp);
    }

    public void readFields(DataInput in) throws IOException {
        this.row = Bytes.readByteArray(in);
        this.column = Bytes.readByteArray(in);
        this.timestamp = in.readLong();
    }

    public static int getSerializedSize(HStoreKey hsk) {
        return HStoreKey.getSerializedSize(hsk.getRow()) + HStoreKey.getSerializedSize(hsk.getColumn()) + 8;
    }

    private static int getSerializedSize(byte[] b) {
        return b == null ? 1 : b.length + WritableUtils.getVIntSize((long)b.length);
    }

    @Override
    public long heapSize() {
        return this.getRow().length + 16 + this.getColumn().length + 16 + 48;
    }

    public byte[] getBytes() throws IOException {
        return HStoreKey.getBytes(this);
    }

    public static byte[] getBytes(HStoreKey hsk) throws IOException {
        return HStoreKey.getBytes(hsk.getRow(), hsk.getColumn(), hsk.getTimestamp());
    }

    public static byte[] getBytes(byte[] row) throws IOException {
        return HStoreKey.getBytes(row, null, Long.MAX_VALUE);
    }

    public static byte[] getBytes(byte[] row, byte[] column, long ts) throws IOException {
        byte[] b = new byte[HStoreKey.getSerializedSize(row) + HStoreKey.getSerializedSize(column) + 8];
        int offset = Bytes.writeByteArray(b, 0, row, 0, row.length);
        byte[] c = column == null ? HConstants.EMPTY_BYTE_ARRAY : column;
        offset = Bytes.writeByteArray(b, offset, c, 0, c.length);
        byte[] timestamp = Bytes.toBytes(ts);
        System.arraycopy(timestamp, 0, b, offset, timestamp.length);
        return b;
    }

    public static byte[] getRow(ByteBuffer bb) {
        int firstByte;
        int vint = firstByte = bb.get(0);
        int vintWidth = WritableUtils.decodeVIntSize((byte)firstByte);
        if (vintWidth != 1) {
            vint = HStoreKey.getBigVint(vintWidth, (byte)firstByte, bb.array(), bb.arrayOffset());
        }
        byte[] b = new byte[vint];
        System.arraycopy(bb.array(), bb.arrayOffset() + vintWidth, b, 0, vint);
        return b;
    }

    public static byte[] getColumn(ByteBuffer bb) {
        int firstByte;
        int offset = HStoreKey.skipVintdByteArray(bb, 0);
        int vint = firstByte = bb.get(offset);
        int vintWidth = WritableUtils.decodeVIntSize((byte)firstByte);
        if (vintWidth != 1) {
            vint = HStoreKey.getBigVint(vintWidth, (byte)firstByte, bb.array(), bb.arrayOffset() + offset);
        }
        byte[] b = new byte[vint];
        System.arraycopy(bb.array(), bb.arrayOffset() + offset + vintWidth, b, 0, vint);
        return b;
    }

    public static long getTimestamp(ByteBuffer bb) {
        return bb.getLong(bb.limit() - 8);
    }

    private static int skipVintdByteArray(ByteBuffer bb, int offset) {
        int firstByte;
        int vint = firstByte = bb.get(offset);
        int vintWidth = WritableUtils.decodeVIntSize((byte)firstByte);
        if (vintWidth != 1) {
            vint = HStoreKey.getBigVint(vintWidth, (byte)firstByte, bb.array(), bb.arrayOffset() + offset);
        }
        return vint + vintWidth + offset;
    }

    static int getBigVint(int vintWidth, byte firstByte, byte[] buffer, int offset) {
        long i = 0L;
        for (int idx = 0; idx < vintWidth - 1; ++idx) {
            byte b = buffer[offset + 1 + idx];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        long l = i = WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
        if (i > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Calculated vint too large");
        }
        return (int)i;
    }

    public static HStoreKey create(ByteBuffer bb) throws IOException {
        return HStoreKey.create(bb.array(), bb.arrayOffset(), bb.limit());
    }

    public static HStoreKey create(byte[] b) throws IOException {
        return HStoreKey.create(b, 0, b.length);
    }

    public static HStoreKey create(byte[] b, int offset, int length) throws IOException {
        int firstByte;
        int vint = firstByte = b[offset];
        int vintWidth = WritableUtils.decodeVIntSize((byte)firstByte);
        if (vintWidth != 1) {
            vint = HStoreKey.getBigVint(vintWidth, (byte)firstByte, b, offset);
        }
        byte[] row = new byte[vint];
        System.arraycopy(b, offset + vintWidth, row, 0, row.length);
        int extraOffset = vint + vintWidth;
        vint = firstByte = b[offset + extraOffset];
        vintWidth = WritableUtils.decodeVIntSize((byte)firstByte);
        if (vintWidth != 1) {
            vint = HStoreKey.getBigVint(vintWidth, (byte)firstByte, b, offset + extraOffset);
        }
        byte[] column = new byte[vint];
        System.arraycopy(b, offset + extraOffset + vintWidth, column, 0, column.length);
        return new HStoreKey(row, column, Bytes.toLong(b, offset + (extraOffset += vint + vintWidth)));
    }

    protected static int compareRootRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
        int lmetaOffsetPlusDelimiter = loffset + 7;
        int leftFarDelimiter = HStoreKey.getDelimiterInReverse(left, lmetaOffsetPlusDelimiter, llength - lmetaOffsetPlusDelimiter, 44);
        int rmetaOffsetPlusDelimiter = roffset + 7;
        int rightFarDelimiter = HStoreKey.getDelimiterInReverse(right, rmetaOffsetPlusDelimiter, rlength - rmetaOffsetPlusDelimiter, 44);
        if (leftFarDelimiter < 0 && rightFarDelimiter >= 0) {
            return -1;
        }
        if (rightFarDelimiter < 0 && leftFarDelimiter >= 0) {
            return 1;
        }
        if (leftFarDelimiter < 0 && rightFarDelimiter < 0) {
            return 0;
        }
        int result = HStoreKey.compareMetaRows(left, lmetaOffsetPlusDelimiter, leftFarDelimiter - lmetaOffsetPlusDelimiter, right, rmetaOffsetPlusDelimiter, rightFarDelimiter - rmetaOffsetPlusDelimiter);
        if (result != 0) {
            return result;
        }
        result = HStoreKey.compareRowid(left, ++leftFarDelimiter, llength - leftFarDelimiter, right, ++rightFarDelimiter, rlength - rightFarDelimiter);
        return result;
    }

    protected static int compareMetaRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
        int rightFarDelimiter;
        int leftFarDelimiter;
        int leftDelimiter = HStoreKey.getDelimiter(left, loffset, llength, 44);
        int rightDelimiter = HStoreKey.getDelimiter(right, roffset, rlength, 44);
        if (leftDelimiter < 0 && rightDelimiter >= 0) {
            return -1;
        }
        if (rightDelimiter < 0 && leftDelimiter >= 0) {
            return 1;
        }
        if (leftDelimiter < 0 && rightDelimiter < 0) {
            return 0;
        }
        int result = Bytes.compareTo(left, loffset, leftDelimiter - loffset, right, roffset, rightDelimiter - roffset);
        if (result != 0) {
            return result;
        }
        if ((result = Bytes.compareTo(left, ++leftDelimiter, (leftFarDelimiter = HStoreKey.getRequiredDelimiterInReverse(left, leftDelimiter, llength - (leftDelimiter - loffset), 44)) - leftDelimiter, right, ++rightDelimiter, (rightFarDelimiter = HStoreKey.getRequiredDelimiterInReverse(right, rightDelimiter, rlength - (rightDelimiter - roffset), 44)) - rightDelimiter)) != 0) {
            return result;
        }
        result = HStoreKey.compareRowid(left, ++leftFarDelimiter, llength - (leftFarDelimiter - loffset), right, ++rightFarDelimiter, rlength - (rightFarDelimiter - roffset));
        return result;
    }

    private static int compareRowid(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
        return Bytes.compareTo(left, loffset, llength, right, roffset, rlength);
    }

    public static WritableComparator getWritableComparator(HRegionInfo hri) {
        return hri.isRootRegion() ? new HStoreKeyRootComparator() : (hri.isMetaRegion() ? new HStoreKeyMetaComparator() : new HStoreKeyComparator());
    }

    public static StoreKeyComparator getRawComparator(HRegionInfo hri) {
        return hri.isRootRegion() ? ROOT_COMPARATOR : (hri.isMetaRegion() ? META_COMPARATOR : PLAIN_COMPARATOR);
    }

    public static StoreKeyComparator getComparator(byte[] tablename) {
        return Bytes.equals(HTableDescriptor.ROOT_TABLEDESC.getName(), tablename) ? ROOT_COMPARATOR : (Bytes.equals(HTableDescriptor.META_TABLEDESC.getName(), tablename) ? META_COMPARATOR : PLAIN_COMPARATOR);
    }

    public static class StoreKeyComparator
    implements RawComparator<byte[]> {
        public int compare(byte[] b1, byte[] b2) {
            return this.compare(b1, 0, b1.length, b2, 0, b2.length);
        }

        public int compare(byte[] b1, int o1, int l1, byte[] b2, int o2, int l2) {
            int result;
            int firstByte2;
            int firstByte1;
            int vint1 = firstByte1 = b1[o1];
            int vintWidth1 = WritableUtils.decodeVIntSize((byte)firstByte1);
            if (vintWidth1 != 1) {
                vint1 = HStoreKey.getBigVint(vintWidth1, (byte)firstByte1, b1, o1);
            }
            int vint2 = firstByte2 = b2[o2];
            int vintWidth2 = WritableUtils.decodeVIntSize((byte)firstByte2);
            if (vintWidth2 != 1) {
                vint2 = HStoreKey.getBigVint(vintWidth2, (byte)firstByte2, b2, o2);
            }
            if ((result = this.compareRows(b1, o1 + vintWidth1, vint1, b2, o2 + vintWidth2, vint2)) != 0) {
                return result;
            }
            int diff1 = vintWidth1 + vint1;
            l1 -= diff1;
            int diff2 = vintWidth2 + vint2;
            o2 += diff2;
            l2 -= diff2;
            vint1 = firstByte1 = b1[o1 += diff1];
            vintWidth1 = WritableUtils.decodeVIntSize((byte)firstByte1);
            if (vintWidth1 != 1) {
                vint1 = HStoreKey.getBigVint(vintWidth1, (byte)firstByte1, b1, o1);
            }
            vint2 = firstByte2 = b2[o2];
            vintWidth2 = WritableUtils.decodeVIntSize((byte)firstByte2);
            if (vintWidth2 != 1) {
                vint2 = HStoreKey.getBigVint(vintWidth2, (byte)firstByte2, b2, o2);
            }
            if ((result = Bytes.compareTo(b1, o1 + vintWidth1, vint1, b2, o2 + vintWidth2, vint2)) != 0) {
                return result;
            }
            diff1 = vintWidth1 + vint1;
            o1 += diff1;
            l1 -= diff1;
            diff2 = vintWidth2 + vint2;
            o2 += diff2;
            l2 -= diff2;
            for (int i = 0; i < l1; ++i) {
                int leftb = b1[o1 + i] & 0xFF;
                int rightb = b2[o2 + i] & 0xFF;
                if (leftb < rightb) {
                    return 1;
                }
                if (leftb <= rightb) continue;
                return -1;
            }
            return 0;
        }

        public int compareRows(byte[] left, byte[] right) {
            return this.compareRows(left, 0, left.length, right, 0, right.length);
        }

        public int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return Bytes.compareTo(left, loffset, llength, right, roffset, rlength);
        }
    }

    public static class MetaStoreKeyComparator
    extends StoreKeyComparator {
        @Override
        public int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return HStoreKey.compareMetaRows(left, loffset, llength, right, roffset, rlength);
        }
    }

    public static class RootStoreKeyComparator
    extends MetaStoreKeyComparator {
        private static final long serialVersionUID = 1L;

        @Override
        public int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return HStoreKey.compareRootRows(left, loffset, llength, right, roffset, rlength);
        }
    }

    public static class HStoreKeyComparator
    extends WritableComparator {
        public HStoreKeyComparator() {
            super(HStoreKey.class);
        }

        public int compare(WritableComparable l, WritableComparable r) {
            byte[] rrow;
            HStoreKey left = (HStoreKey)l;
            HStoreKey right = (HStoreKey)r;
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            byte[] lrow = left.getRow();
            int result = this.compareRows(lrow, 0, lrow.length, rrow = right.getRow(), 0, rrow.length);
            if (result != 0) {
                return result;
            }
            int n = left.getColumn() == null && right.getColumn() == null ? 0 : (left.getColumn() == null ? -1 : (result = right.getColumn() == null ? 1 : Bytes.compareTo(left.getColumn(), right.getColumn())));
            if (result != 0) {
                return result;
            }
            if (left.getTimestamp() < right.getTimestamp()) {
                result = 1;
            } else if (left.getTimestamp() > right.getTimestamp()) {
                result = -1;
            }
            return result;
        }

        protected int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return Bytes.compareTo(left, loffset, llength, right, roffset, rlength);
        }
    }

    public static class HStoreKeyMetaComparator
    extends HStoreKeyComparator {
        @Override
        protected int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return HStoreKey.compareMetaRows(left, loffset, llength, right, roffset, rlength);
        }
    }

    public static class HStoreKeyRootComparator
    extends HStoreKeyMetaComparator {
        @Override
        protected int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            return HStoreKey.compareRootRows(left, loffset, llength, right, roffset, rlength);
        }
    }
}

