/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import agilejson.TOJSON;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.IRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.ISerializable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;

public class HTableDescriptor
implements WritableComparable<HTableDescriptor>,
ISerializable {
    public static final byte TABLE_DESCRIPTOR_VERSION = 5;
    private byte[] name = HConstants.EMPTY_BYTE_ARRAY;
    private String nameAsString = "";
    protected Map<ImmutableBytesWritable, ImmutableBytesWritable> values = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
    public static final String FAMILIES = "FAMILIES";
    public static final ImmutableBytesWritable FAMILIES_KEY = new ImmutableBytesWritable(Bytes.toBytes("FAMILIES"));
    public static final String MAX_FILESIZE = "MAX_FILESIZE";
    public static final ImmutableBytesWritable MAX_FILESIZE_KEY = new ImmutableBytesWritable(Bytes.toBytes("MAX_FILESIZE"));
    public static final String READONLY = "READONLY";
    public static final ImmutableBytesWritable READONLY_KEY = new ImmutableBytesWritable(Bytes.toBytes("READONLY"));
    public static final String MEMSTORE_FLUSHSIZE = "MEMSTORE_FLUSHSIZE";
    public static final ImmutableBytesWritable MEMSTORE_FLUSHSIZE_KEY = new ImmutableBytesWritable(Bytes.toBytes("MEMSTORE_FLUSHSIZE"));
    public static final String IS_ROOT = "IS_ROOT";
    public static final ImmutableBytesWritable IS_ROOT_KEY = new ImmutableBytesWritable(Bytes.toBytes("IS_ROOT"));
    public static final String IS_META = "IS_META";
    public static final ImmutableBytesWritable IS_META_KEY = new ImmutableBytesWritable(Bytes.toBytes("IS_META"));
    private static final ImmutableBytesWritable FALSE = new ImmutableBytesWritable(Bytes.toBytes(Boolean.FALSE.toString()));
    private static final ImmutableBytesWritable TRUE = new ImmutableBytesWritable(Bytes.toBytes(Boolean.TRUE.toString()));
    public static final boolean DEFAULT_READONLY = false;
    public static final long DEFAULT_MEMSTORE_FLUSH_SIZE = 0x4000000L;
    public static final long DEFAULT_MAX_FILESIZE = 0x10000000L;
    private volatile Boolean meta = null;
    private volatile Boolean root = null;
    public final Map<byte[], HColumnDescriptor> families = new TreeMap<byte[], HColumnDescriptor>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    public static final HTableDescriptor ROOT_TABLEDESC = new HTableDescriptor(HConstants.ROOT_TABLE_NAME, new HColumnDescriptor[]{new HColumnDescriptor(HConstants.CATALOG_FAMILY, 10, Compression.Algorithm.NONE.getName(), false, true, 8192, Integer.MAX_VALUE, false)});
    public static final HTableDescriptor META_TABLEDESC = new HTableDescriptor(HConstants.META_TABLE_NAME, new HColumnDescriptor[]{new HColumnDescriptor(HConstants.CATALOG_FAMILY, 10, Compression.Algorithm.NONE.getName(), false, true, 8192, Integer.MAX_VALUE, false), new HColumnDescriptor(HConstants.CATALOG_HISTORIAN_FAMILY, Integer.MAX_VALUE, Compression.Algorithm.NONE.getName(), false, false, 8192, 604800, false)});

    protected HTableDescriptor(byte[] name, HColumnDescriptor[] families) {
        this.name = (byte[])name.clone();
        this.nameAsString = Bytes.toString(this.name);
        this.setMetaFlags(name);
        for (HColumnDescriptor descriptor : families) {
            this.families.put(descriptor.getName(), descriptor);
        }
        this.setMemStoreFlushSize(16384L);
    }

    protected HTableDescriptor(byte[] name, HColumnDescriptor[] families, Map<ImmutableBytesWritable, ImmutableBytesWritable> values) {
        this.name = (byte[])name.clone();
        this.nameAsString = Bytes.toString(this.name);
        this.setMetaFlags(name);
        for (HColumnDescriptor descriptor : families) {
            this.families.put(descriptor.getName(), descriptor);
        }
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : values.entrySet()) {
            this.values.put(entry.getKey(), entry.getValue());
        }
    }

    public HTableDescriptor() {
    }

    public HTableDescriptor(String name) {
        this(Bytes.toBytes(name));
    }

    public HTableDescriptor(byte[] name) {
        this.setMetaFlags(this.name);
        this.name = this.isMetaRegion() ? name : HTableDescriptor.isLegalTableName(name);
        this.nameAsString = Bytes.toString(this.name);
    }

    public HTableDescriptor(HTableDescriptor desc) {
        this.name = (byte[])desc.name.clone();
        this.nameAsString = Bytes.toString(this.name);
        this.setMetaFlags(this.name);
        for (HColumnDescriptor hColumnDescriptor : desc.families.values()) {
            this.families.put(hColumnDescriptor.getName(), new HColumnDescriptor(hColumnDescriptor));
        }
        for (Map.Entry entry : desc.values.entrySet()) {
            this.values.put((ImmutableBytesWritable)entry.getKey(), (ImmutableBytesWritable)entry.getValue());
        }
    }

    private void setMetaFlags(byte[] name) {
        this.setRootRegion(Bytes.equals(name, HConstants.ROOT_TABLE_NAME));
        this.setMetaRegion(this.isRootRegion() || Bytes.equals(name, HConstants.META_TABLE_NAME));
    }

    public boolean isRootRegion() {
        if (this.root == null) {
            this.root = this.isSomething(IS_ROOT_KEY, false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.root;
    }

    protected void setRootRegion(boolean isRoot) {
        this.values.put(IS_ROOT_KEY, isRoot ? TRUE : FALSE);
    }

    public boolean isMetaRegion() {
        if (this.meta == null) {
            this.meta = this.calculateIsMetaRegion();
        }
        return this.meta;
    }

    private synchronized Boolean calculateIsMetaRegion() {
        byte[] value = this.getValue(IS_META_KEY);
        return value != null ? Boolean.valueOf(Bytes.toString(value)) : Boolean.FALSE;
    }

    private boolean isSomething(ImmutableBytesWritable key, boolean valueIfNull) {
        byte[] value = this.getValue(key);
        if (value != null) {
            return Boolean.valueOf(Bytes.toString(value));
        }
        return valueIfNull;
    }

    protected void setMetaRegion(boolean isMeta) {
        this.values.put(IS_META_KEY, isMeta ? TRUE : FALSE);
    }

    public boolean isMetaTable() {
        return this.isMetaRegion() && !this.isRootRegion();
    }

    public static byte[] isLegalTableName(byte[] b) {
        if (b == null || b.length <= 0) {
            throw new IllegalArgumentException("Name is null or empty");
        }
        if (b[0] == 46 || b[0] == 45) {
            throw new IllegalArgumentException("Illegal first character <" + b[0] + ">. " + "User-space table names can only start with 'word " + "characters': i.e. [a-zA-Z_0-9]: " + Bytes.toString(b));
        }
        for (int i = 0; i < b.length; ++i) {
            if (Character.isLetterOrDigit(b[i]) || b[i] == 95 || b[i] == 45 || b[i] == 46) continue;
            throw new IllegalArgumentException("Illegal character <" + b[i] + ">. " + "User-space table names can only contain 'word characters':" + "i.e. [a-zA-Z_0-9-.]: " + Bytes.toString(b));
        }
        return b;
    }

    public byte[] getValue(byte[] key) {
        return this.getValue(new ImmutableBytesWritable(key));
    }

    private byte[] getValue(ImmutableBytesWritable key) {
        ImmutableBytesWritable ibw = this.values.get(key);
        if (ibw == null) {
            return null;
        }
        return ibw.get();
    }

    public String getValue(String key) {
        byte[] value = this.getValue(Bytes.toBytes(key));
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public Map<ImmutableBytesWritable, ImmutableBytesWritable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public void setValue(byte[] key, byte[] value) {
        this.setValue(new ImmutableBytesWritable(key), value);
    }

    private void setValue(ImmutableBytesWritable key, byte[] value) {
        this.values.put(key, new ImmutableBytesWritable(value));
    }

    private void setValue(ImmutableBytesWritable key, ImmutableBytesWritable value) {
        this.values.put(key, value);
    }

    public void setValue(String key, String value) {
        this.setValue(Bytes.toBytes(key), Bytes.toBytes(value));
    }

    public void remove(byte[] key) {
        this.values.remove(new ImmutableBytesWritable(key));
    }

    public boolean isReadOnly() {
        return this.isSomething(READONLY_KEY, false);
    }

    public void setReadOnly(boolean readOnly) {
        this.setValue(READONLY_KEY, readOnly ? TRUE : FALSE);
    }

    @TOJSON
    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return this.nameAsString;
    }

    public long getMaxFileSize() {
        byte[] value = this.getValue(MAX_FILESIZE_KEY);
        if (value != null) {
            return Long.valueOf(Bytes.toString(value));
        }
        return 0x10000000L;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.setValue(MAX_FILESIZE_KEY, Bytes.toBytes(Long.toString(maxFileSize)));
    }

    public long getMemStoreFlushSize() {
        byte[] value = this.getValue(MEMSTORE_FLUSHSIZE_KEY);
        if (value != null) {
            return Long.valueOf(Bytes.toString(value));
        }
        return 0x4000000L;
    }

    public void setMemStoreFlushSize(long memstoreFlushSize) {
        this.setValue(MEMSTORE_FLUSHSIZE_KEY, Bytes.toBytes(Long.toString(memstoreFlushSize)));
    }

    public void addFamily(HColumnDescriptor family) {
        if (family.getName() == null || family.getName().length <= 0) {
            throw new NullPointerException("Family name cannot be null or empty");
        }
        this.families.put(family.getName(), family);
    }

    public boolean hasFamily(byte[] c) {
        return this.families.containsKey(c);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString(this.name));
        s.append("'");
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            String upperCase;
            String key = Bytes.toString(e.getKey().get());
            String value = Bytes.toString(e.getValue().get());
            if (key == null || ((upperCase = key.toUpperCase()).equals(IS_ROOT) || upperCase.equals(IS_META)) && value.toLowerCase().equals(Boolean.FALSE.toString())) continue;
            s.append(", ");
            s.append(Bytes.toString(e.getKey().get()));
            s.append(" => '");
            s.append(Bytes.toString(e.getValue().get()));
            s.append("'");
        }
        s.append(", ");
        s.append(FAMILIES);
        s.append(" => ");
        s.append(this.families.values());
        s.append('}');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HTableDescriptor)) {
            return false;
        }
        return this.compareTo((HTableDescriptor)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.name);
        result ^= Byte.valueOf((byte)5).hashCode();
        if (this.families != null && this.families.size() > 0) {
            for (HColumnDescriptor e : this.families.values()) {
                result ^= e.hashCode();
            }
        }
        return result ^= ((Object)this.values).hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        int version = in.readInt();
        if (version < 3) {
            throw new IOException("versions < 3 are not supported (and never existed!?)");
        }
        this.name = Bytes.readByteArray(in);
        this.nameAsString = Bytes.toString(this.name);
        this.setRootRegion(in.readBoolean());
        this.setMetaRegion(in.readBoolean());
        this.values.clear();
        int numVals = in.readInt();
        for (int i = 0; i < numVals; ++i) {
            ImmutableBytesWritable key = new ImmutableBytesWritable();
            ImmutableBytesWritable value = new ImmutableBytesWritable();
            key.readFields(in);
            value.readFields(in);
            this.values.put(key, value);
        }
        this.families.clear();
        int numFamilies = in.readInt();
        for (int i = 0; i < numFamilies; ++i) {
            HColumnDescriptor c = new HColumnDescriptor();
            c.readFields(in);
            this.families.put(c.getName(), c);
        }
        if (version < 4) {
            return;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(5);
        Bytes.writeByteArray(out, this.name);
        out.writeBoolean(this.isRootRegion());
        out.writeBoolean(this.isMetaRegion());
        out.writeInt(this.values.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            e.getKey().write(out);
            e.getValue().write(out);
        }
        out.writeInt(this.families.size());
        for (HColumnDescriptor family : this.families.values()) {
            family.write(out);
        }
    }

    public int compareTo(HTableDescriptor other) {
        int result = Bytes.compareTo(this.name, other.name);
        if (result == 0) {
            result = this.families.size() - other.families.size();
        }
        if (result == 0 && this.families.size() != other.families.size()) {
            result = Integer.valueOf(this.families.size()).compareTo(other.families.size());
        }
        if (result == 0) {
            Iterator<HColumnDescriptor> it = this.families.values().iterator();
            Iterator<HColumnDescriptor> it2 = other.families.values().iterator();
            while (it.hasNext() && (result = it.next().compareTo(it2.next())) == 0) {
            }
        }
        if (result == 0) {
            result = ((Object)this.values).hashCode() - ((Object)other.values).hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    public Collection<HColumnDescriptor> getFamilies() {
        return Collections.unmodifiableCollection(this.families.values());
    }

    public Set<byte[]> getFamiliesKeys() {
        return Collections.unmodifiableSet(this.families.keySet());
    }

    @TOJSON(fieldName="columns")
    public HColumnDescriptor[] getColumnFamilies() {
        return this.getFamilies().toArray(new HColumnDescriptor[0]);
    }

    public HColumnDescriptor getFamily(byte[] column) {
        return this.families.get(column);
    }

    public HColumnDescriptor removeFamily(byte[] column) {
        return this.families.remove(column);
    }

    public static Path getTableDir(Path rootdir, byte[] tableName) {
        return new Path(rootdir, Bytes.toString(tableName));
    }

    @Override
    public void restSerialize(IRestSerializer serializer) throws HBaseRestException {
        serializer.serializeTableDescriptor(this);
    }
}

