/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.BindException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;

public class MiniHBaseCluster
implements HConstants {
    static final Log LOG = LogFactory.getLog((String)MiniHBaseCluster.class.getName());
    private HBaseConfiguration conf;
    public LocalHBaseCluster hbaseCluster;

    public MiniHBaseCluster(HBaseConfiguration conf, int numRegionServers) throws IOException {
        this.conf = conf;
        this.init(numRegionServers);
    }

    private void init(int nRegionNodes) throws IOException {
        try {
            while (true) {
                try {
                    this.hbaseCluster = new LocalHBaseCluster(this.conf, nRegionNodes);
                    this.hbaseCluster.startup();
                }
                catch (BindException e) {
                    int port = this.conf.getInt("hbase.master.port", 60000);
                    LOG.info((Object)("Failed binding Master to port: " + port), (Throwable)e);
                    this.conf.setInt("hbase.master.port", ++port);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
    }

    public String startRegionServer() throws IOException {
        LocalHBaseCluster.RegionServerThread t = this.hbaseCluster.addRegionServer();
        t.start();
        t.waitForServerOnline();
        return t.getName();
    }

    public HServerAddress getHMasterAddress() {
        return this.hbaseCluster.getMaster().getMasterAddress();
    }

    public HMaster getMaster() {
        return this.hbaseCluster.getMaster();
    }

    public void abortRegionServer(int serverNumber) {
        HRegionServer server = this.getRegionServer(serverNumber);
        try {
            LOG.info((Object)("Aborting " + server.getHServerInfo().toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        server.abort();
    }

    public LocalHBaseCluster.RegionServerThread stopRegionServer(int serverNumber) {
        return this.stopRegionServer(serverNumber, true);
    }

    public LocalHBaseCluster.RegionServerThread stopRegionServer(int serverNumber, boolean shutdownFS) {
        LocalHBaseCluster.RegionServerThread server = this.hbaseCluster.getRegionServers().get(serverNumber);
        LOG.info((Object)("Stopping " + server.toString()));
        if (!shutdownFS) {
            server.getRegionServer().setHDFSShutdownThreadOnExit(null);
        }
        server.getRegionServer().stop();
        return server;
    }

    public String waitOnRegionServer(int serverNumber) {
        return this.hbaseCluster.waitOnRegionServer(serverNumber);
    }

    public void join() {
        this.hbaseCluster.join();
    }

    public void shutdown() {
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
        }
        HConnectionManager.deleteAllConnections(false);
    }

    public void flushcache() throws IOException {
        for (LocalHBaseCluster.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (HRegion r : t.getRegionServer().getOnlineRegions()) {
                r.flushcache();
            }
        }
    }

    public List<LocalHBaseCluster.RegionServerThread> getRegionThreads() {
        return this.hbaseCluster.getRegionServers();
    }

    public HRegionServer getRegionServer(int serverNumber) {
        return this.hbaseCluster.getRegionServer(serverNumber);
    }
}

