/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;

public class MultiRegionTable
extends HBaseClusterTestCase {
    private static final byte[][] KEYS = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes("bbb"), Bytes.toBytes("ccc"), Bytes.toBytes("ddd"), Bytes.toBytes("eee"), Bytes.toBytes("fff"), Bytes.toBytes("ggg"), Bytes.toBytes("hhh"), Bytes.toBytes("iii"), Bytes.toBytes("jjj"), Bytes.toBytes("kkk"), Bytes.toBytes("lll"), Bytes.toBytes("mmm"), Bytes.toBytes("nnn"), Bytes.toBytes("ooo"), Bytes.toBytes("ppp"), Bytes.toBytes("qqq"), Bytes.toBytes("rrr"), Bytes.toBytes("sss"), Bytes.toBytes("ttt"), Bytes.toBytes("uuu"), Bytes.toBytes("vvv"), Bytes.toBytes("www"), Bytes.toBytes("xxx"), Bytes.toBytes("yyy")};
    protected final byte[] columnFamily;
    protected HTableDescriptor desc;

    public MultiRegionTable(String columnName) {
        this.columnFamily = Bytes.toBytes(columnName);
        System.setProperty("hadoop.log.dir", this.conf.get("hadoop.log.dir"));
        this.conf.set("mapred.output.dir", this.conf.get("hadoop.tmp.dir"));
    }

    @Override
    protected void preHBaseClusterSetup() throws Exception {
        try {
            int i;
            HRegion[] regions = new HRegion[KEYS.length];
            for (i = 0; i < regions.length; ++i) {
                int j = (i + 1) % regions.length;
                regions[i] = this.createARegion(KEYS[i], KEYS[j]);
            }
            this.createRootAndMetaRegions();
            for (i = 0; i < regions.length; ++i) {
                HRegion.addRegionToMETA(this.meta, regions[i]);
            }
            this.closeRootAndMeta();
        }
        catch (Exception e) {
            MultiRegionTable.shutdownDfs(this.dfsCluster);
            throw e;
        }
    }

    private HRegion createARegion(byte[] startKey, byte[] endKey) throws IOException {
        HRegion region = this.createNewHRegion(this.desc, startKey, endKey);
        MultiRegionTable.addContent(region, this.columnFamily);
        this.closeRegionAndDeleteLog(region);
        return region;
    }

    private void closeRegionAndDeleteLog(HRegion region) throws IOException {
        region.close();
        region.getLog().closeAndDelete();
    }
}

