/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HStoreKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class TestClassMigration
extends TestCase {
    public void testMigrateHStoreKey() throws Exception {
        long now = System.currentTimeMillis();
        byte[] nameBytes = Bytes.toBytes(this.getName());
        Text nameText = new Text(nameBytes);
        HStoreKey01Branch hsk = new HStoreKey01Branch(nameText, nameText, now);
        byte[] b = Writables.getBytes((Writable)hsk);
        HStoreKey deserializedHsk = (HStoreKey)Writables.getWritable(b, (Writable)new HStoreKey());
        TestClassMigration.assertEquals((long)deserializedHsk.getTimestamp(), (long)hsk.getTimestamp());
        TestClassMigration.assertTrue((boolean)Bytes.equals(nameBytes, deserializedHsk.getColumn()));
        TestClassMigration.assertTrue((boolean)Bytes.equals(nameBytes, deserializedHsk.getRow()));
    }

    private static class HStoreKey01Branch
    implements WritableComparable {
        public static final char COLUMN_FAMILY_DELIMITER = ':';
        private Text row;
        private Text column;
        private long timestamp;

        public HStoreKey01Branch() {
            this(new Text());
        }

        public HStoreKey01Branch(Text row) {
            this(row, Long.MAX_VALUE);
        }

        public HStoreKey01Branch(Text row, long timestamp) {
            this(row, new Text(), timestamp);
        }

        public HStoreKey01Branch(Text row, Text column) {
            this(row, column, Long.MAX_VALUE);
        }

        public HStoreKey01Branch(Text row, Text column, long timestamp) {
            this.row = new Text(row);
            this.column = new Text(column);
            this.timestamp = timestamp;
        }

        public long getSize() {
            return this.row.getLength() + this.column.getLength() + 8;
        }

        public HStoreKey01Branch(HStoreKey01Branch other) {
            this(other.row, other.column, other.timestamp);
        }

        public void setRow(Text newrow) {
            this.row.set(newrow);
        }

        public void setColumn(Text newcol) {
            this.column.set(newcol);
        }

        public void setVersion(long timestamp) {
            this.timestamp = timestamp;
        }

        public void set(HStoreKey01Branch k) {
            this.row = k.getRow();
            this.column = k.getColumn();
            this.timestamp = k.getTimestamp();
        }

        public Text getRow() {
            return this.row;
        }

        public Text getColumn() {
            return this.column;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return this.row.toString() + "/" + this.column.toString() + "/" + this.timestamp;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            int result = this.row.hashCode();
            result ^= this.column.hashCode();
            result = (int)((long)result ^ this.timestamp);
            return result;
        }

        public int compareTo(Object o) {
            HStoreKey01Branch other = (HStoreKey01Branch)o;
            int result = this.row.compareTo((BinaryComparable)other.row);
            if (result != 0) {
                return result;
            }
            result = this.column.compareTo((BinaryComparable)other.column);
            if (result != 0) {
                return result;
            }
            if (this.timestamp < other.timestamp) {
                result = 1;
            } else if (this.timestamp > other.timestamp) {
                result = -1;
            }
            return result;
        }

        public void write(DataOutput out) throws IOException {
            this.row.write(out);
            this.column.write(out);
            out.writeLong(this.timestamp);
        }

        public void readFields(DataInput in) throws IOException {
            this.row.readFields(in);
            this.column.readFields(in);
            this.timestamp = in.readLong();
        }

        public static byte[] getBytes(HStoreKey hsk) throws UnsupportedEncodingException {
            StringBuilder s = new StringBuilder(Bytes.toString(hsk.getRow()));
            s.append(Bytes.toString(hsk.getColumn()));
            return s.toString().getBytes("UTF-8");
        }
    }
}

