/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import junit.framework.TestCase;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HStoreKey;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;

public class TestCompare
extends TestCase {
    public void testHStoreKey() {
        long timestamp = System.currentTimeMillis();
        byte[] a = Bytes.toBytes("a");
        HStoreKey past = new HStoreKey(a, a, timestamp - 10L);
        HStoreKey now = new HStoreKey(a, a, timestamp);
        HStoreKey future = new HStoreKey(a, a, timestamp + 10L);
        TestCompare.assertTrue((past.compareTo(now) > 0 ? 1 : 0) != 0);
        TestCompare.assertTrue((now.compareTo(now) == 0 ? 1 : 0) != 0);
        TestCompare.assertTrue((future.compareTo(now) < 0 ? 1 : 0) != 0);
        HStoreKey nocolumn = new HStoreKey(a, timestamp);
        HStoreKey withcolumn = new HStoreKey(a, a, timestamp);
        TestCompare.assertTrue((nocolumn.compareTo(withcolumn) < 0 ? 1 : 0) != 0);
        nocolumn = new HStoreKey(a, Long.MAX_VALUE);
        withcolumn = new HStoreKey(a, a, timestamp);
        TestCompare.assertTrue((nocolumn.compareTo(withcolumn) < 0 ? 1 : 0) != 0);
        HStoreKey normal = new HStoreKey("a", "b");
        TestCompare.assertTrue((normal.compareTo(null) > 0 ? 1 : 0) != 0);
        TestCompare.assertTrue((HStoreKey.compareTo(null, null) == 0 ? 1 : 0) != 0);
        TestCompare.assertTrue((HStoreKey.compareTo(null, normal) < 0 ? 1 : 0) != 0);
    }

    public void testHStoreKeyBorderCases() {
    }

    public void testHRegionInfo() {
        HRegionInfo a = new HRegionInfo(new HTableDescriptor("a"), null, null);
        HRegionInfo b = new HRegionInfo(new HTableDescriptor("b"), null, null);
        TestCompare.assertTrue((a.compareTo(b) != 0 ? 1 : 0) != 0);
        HTableDescriptor t = new HTableDescriptor("t");
        byte[] midway = Bytes.toBytes("midway");
        a = new HRegionInfo(t, null, midway);
        b = new HRegionInfo(t, midway, null);
        TestCompare.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        TestCompare.assertTrue((b.compareTo(a) > 0 ? 1 : 0) != 0);
        TestCompare.assertEquals((Object)((Object)a), (Object)((Object)a));
        TestCompare.assertTrue((a.compareTo(a) == 0 ? 1 : 0) != 0);
        a = new HRegionInfo(t, Bytes.toBytes("a"), Bytes.toBytes("d"));
        b = new HRegionInfo(t, Bytes.toBytes("e"), Bytes.toBytes("g"));
        TestCompare.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        a = new HRegionInfo(t, Bytes.toBytes("aaaa"), Bytes.toBytes("dddd"));
        b = new HRegionInfo(t, Bytes.toBytes("e"), Bytes.toBytes("g"));
        TestCompare.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        a = new HRegionInfo(t, Bytes.toBytes("aaaa"), Bytes.toBytes("dddd"));
        b = new HRegionInfo(t, Bytes.toBytes("aaaa"), Bytes.toBytes("eeee"));
        TestCompare.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
    }
}

