/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.io.BatchOperation;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;

public class TestSerialization
extends HBaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCompareFilter() throws Exception {
        RowFilter f = new RowFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("testRowOne-2")));
        byte[] bytes = Writables.getBytes(f);
        Filter ff = (Filter)Writables.getWritable(bytes, new RowFilter());
        TestSerialization.assertNotNull((Object)ff);
    }

    public void testKeyValue() throws Exception {
        byte[] bytes;
        KeyValue newone;
        byte[] column;
        byte[] row = Bytes.toBytes(this.getName());
        KeyValue original = new KeyValue(row, column = Bytes.toBytes(this.getName() + ":" + this.getName()));
        TestSerialization.assertTrue((KeyValue.COMPARATOR.compare(original, newone = (KeyValue)Writables.getWritable(bytes = Writables.getBytes(original), new KeyValue())) == 0 ? 1 : 0) != 0);
    }

    public void testHbaseMapWritable() throws Exception {
        HbaseMapWritable hmw = new HbaseMapWritable();
        hmw.put("key".getBytes(), "value".getBytes());
        byte[] bytes = Writables.getBytes(hmw);
        hmw = (HbaseMapWritable)Writables.getWritable(bytes, new HbaseMapWritable());
        TestSerialization.assertTrue((hmw.size() == 1 ? 1 : 0) != 0);
        TestSerialization.assertTrue((boolean)Bytes.equals("value".getBytes(), (byte[])hmw.get("key".getBytes())));
    }

    public void testHMsg() throws Exception {
        HMsg m = new HMsg(HMsg.Type.MSG_REGIONSERVER_QUIESCE);
        byte[] mb = Writables.getBytes(m);
        HMsg deserializedHMsg = (HMsg)Writables.getWritable(mb, new HMsg());
        TestSerialization.assertTrue((boolean)m.equals(deserializedHMsg));
        m = new HMsg(HMsg.Type.MSG_REGIONSERVER_QUIESCE, new HRegionInfo(new HTableDescriptor(this.getName()), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY), "Some message".getBytes());
        mb = Writables.getBytes(m);
        deserializedHMsg = (HMsg)Writables.getWritable(mb, new HMsg());
        TestSerialization.assertTrue((boolean)m.equals(deserializedHMsg));
    }

    public void testTableDescriptor() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName());
        byte[] mb = Writables.getBytes((Writable)htd);
        HTableDescriptor deserializedHtd = (HTableDescriptor)Writables.getWritable(mb, (Writable)new HTableDescriptor());
        TestSerialization.assertEquals((String)htd.getNameAsString(), (String)deserializedHtd.getNameAsString());
    }

    public void testRowResult() throws Exception {
        HbaseMapWritable<byte[], Cell> m = new HbaseMapWritable<byte[], Cell>();
        byte[] b = Bytes.toBytes(this.getName());
        m.put(b, new Cell(b, System.currentTimeMillis()));
        RowResult rr = new RowResult(b, m);
        byte[] mb = Writables.getBytes(rr);
        RowResult deserializedRr = (RowResult)Writables.getWritable(mb, new RowResult());
        TestSerialization.assertTrue((boolean)Bytes.equals(rr.getRow(), deserializedRr.getRow()));
        byte[] one = rr.get(b).getValue();
        byte[] two = deserializedRr.get(b).getValue();
        TestSerialization.assertTrue((boolean)Bytes.equals(one, two));
        Writables.copyWritable(rr, (Writable)deserializedRr);
        one = rr.get(b).getValue();
        two = deserializedRr.get(b).getValue();
        TestSerialization.assertTrue((boolean)Bytes.equals(one, two));
    }

    public void testRegionInfo() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(this.getName());
        String[] families = new String[]{"info:", "anchor:"};
        for (int i = 0; i < families.length; ++i) {
            htd.addFamily(new HColumnDescriptor(families[i]));
        }
        HRegionInfo hri = new HRegionInfo(htd, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        byte[] hrib = Writables.getBytes((Writable)hri);
        HRegionInfo deserializedHri = (HRegionInfo)Writables.getWritable(hrib, (Writable)new HRegionInfo());
        TestSerialization.assertEquals((int)hri.getEncodedName(), (int)deserializedHri.getEncodedName());
        TestSerialization.assertEquals((int)hri.getTableDesc().getFamilies().size(), (int)deserializedHri.getTableDesc().getFamilies().size());
    }

    public void testServerInfo() throws Exception {
        HServerInfo hsi = new HServerInfo(new HServerAddress("0.0.0.0:123"), -1L, 1245, "default name");
        byte[] b = Writables.getBytes((Writable)hsi);
        HServerInfo deserializedHsi = (HServerInfo)Writables.getWritable(b, (Writable)new HServerInfo());
        TestSerialization.assertTrue((boolean)hsi.equals(deserializedHsi));
    }

    public void testBatchUpdate() throws Exception {
        BatchUpdate bu = new BatchUpdate(this.getName());
        bu.put(this.getName(), this.getName().getBytes());
        byte[] b = Writables.getBytes((Writable)bu);
        BatchUpdate bubu = (BatchUpdate)Writables.getWritable(b, (Writable)new BatchUpdate());
        TestSerialization.assertTrue((boolean)Bytes.equals(bu.getRow(), bubu.getRow()));
        int firstCount = 0;
        for (BatchOperation bo : bubu) {
            ++firstCount;
        }
        BatchUpdate bububu = (BatchUpdate)Writables.getWritable(b, (Writable)bubu);
        TestSerialization.assertTrue((boolean)Bytes.equals(bu.getRow(), bububu.getRow()));
        int secondCount = 0;
        for (BatchOperation bo : bububu) {
            ++secondCount;
        }
        TestSerialization.assertEquals((int)firstCount, (int)secondCount);
    }

    public void testPut() throws Exception {
        byte[] row = "row".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        byte[] qf2 = "qf2".getBytes();
        byte[] qf3 = "qf3".getBytes();
        byte[] qf4 = "qf4".getBytes();
        byte[] qf5 = "qf5".getBytes();
        byte[] qf6 = "qf6".getBytes();
        byte[] qf7 = "qf7".getBytes();
        byte[] qf8 = "qf8".getBytes();
        long ts = System.currentTimeMillis();
        byte[] val = "val".getBytes();
        Put put = new Put(row);
        put.add(fam, qf1, ts, val);
        put.add(fam, qf2, ts, val);
        put.add(fam, qf3, ts, val);
        put.add(fam, qf4, ts, val);
        put.add(fam, qf5, ts, val);
        put.add(fam, qf6, ts, val);
        put.add(fam, qf7, ts, val);
        put.add(fam, qf8, ts, val);
        byte[] sb = Writables.getBytes(put);
        Put desPut = (Put)Writables.getWritable(sb, new Put());
        TestSerialization.assertTrue((boolean)Bytes.equals(put.getRow(), desPut.getRow()));
        List<KeyValue> list = null;
        List<KeyValue> desList = null;
        for (Map.Entry<byte[], List<KeyValue>> entry : put.getFamilyMap().entrySet()) {
            TestSerialization.assertTrue((boolean)desPut.getFamilyMap().containsKey(entry.getKey()));
            list = entry.getValue();
            desList = desPut.getFamilyMap().get(entry.getKey());
            for (int i = 0; i < list.size(); ++i) {
                TestSerialization.assertTrue((boolean)list.get(i).equals(desList.get(i)));
            }
        }
    }

    public void testPut2() throws Exception {
        byte[] row = "testAbort,,1243116656250".getBytes();
        byte[] fam = "historian".getBytes();
        byte[] qf1 = "creation".getBytes();
        long ts = Long.MAX_VALUE;
        byte[] val = "dont-care".getBytes();
        Put put = new Put(row);
        put.add(fam, qf1, ts, val);
        byte[] sb = Writables.getBytes(put);
        Put desPut = (Put)Writables.getWritable(sb, new Put());
        TestSerialization.assertTrue((boolean)Bytes.equals(put.getRow(), desPut.getRow()));
        List<KeyValue> list = null;
        List<KeyValue> desList = null;
        for (Map.Entry<byte[], List<KeyValue>> entry : put.getFamilyMap().entrySet()) {
            TestSerialization.assertTrue((boolean)desPut.getFamilyMap().containsKey(entry.getKey()));
            list = entry.getValue();
            desList = desPut.getFamilyMap().get(entry.getKey());
            for (int i = 0; i < list.size(); ++i) {
                TestSerialization.assertTrue((boolean)list.get(i).equals(desList.get(i)));
            }
        }
    }

    public void testDelete() throws Exception {
        byte[] row = "row".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        Delete delete = new Delete(row);
        delete.deleteColumn(fam, qf1, ts);
        byte[] sb = Writables.getBytes(delete);
        Delete desDelete = (Delete)Writables.getWritable(sb, new Delete());
        TestSerialization.assertTrue((boolean)Bytes.equals(delete.getRow(), desDelete.getRow()));
        List<KeyValue> list = null;
        List<KeyValue> desList = null;
        for (Map.Entry<byte[], List<KeyValue>> entry : delete.getFamilyMap().entrySet()) {
            TestSerialization.assertTrue((boolean)desDelete.getFamilyMap().containsKey(entry.getKey()));
            list = entry.getValue();
            desList = desDelete.getFamilyMap().get(entry.getKey());
            for (int i = 0; i < list.size(); ++i) {
                TestSerialization.assertTrue((boolean)list.get(i).equals(desList.get(i)));
            }
        }
    }

    public void testGet() throws Exception {
        byte[] row = "row".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        int maxVersions = 2;
        long lockid = 5L;
        RowLock rowLock = new RowLock(lockid);
        Get get2 = new Get(row, rowLock);
        get2.addColumn(fam, qf1);
        get2.setTimeRange(ts, ts + 1L);
        get2.setMaxVersions(maxVersions);
        byte[] sb = Writables.getBytes(get2);
        Get desGet = (Get)Writables.getWritable(sb, new Get());
        TestSerialization.assertTrue((boolean)Bytes.equals(get2.getRow(), desGet.getRow()));
        Set set = null;
        Set desSet = null;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : get2.getFamilyMap().entrySet()) {
            TestSerialization.assertTrue((boolean)desGet.getFamilyMap().containsKey(entry.getKey()));
            set = entry.getValue();
            desSet = desGet.getFamilyMap().get(entry.getKey());
            for (byte[] qualifier : set) {
                TestSerialization.assertTrue((boolean)desSet.contains(qualifier));
            }
        }
        TestSerialization.assertEquals((long)get2.getLockId(), (long)desGet.getLockId());
        TestSerialization.assertEquals((int)get2.getMaxVersions(), (int)desGet.getMaxVersions());
        TimeRange tr = get2.getTimeRange();
        TimeRange desTr = desGet.getTimeRange();
        TestSerialization.assertEquals((long)tr.getMax(), (long)desTr.getMax());
        TestSerialization.assertEquals((long)tr.getMin(), (long)desTr.getMin());
    }

    public void testScan() throws Exception {
        byte[] startRow = "startRow".getBytes();
        byte[] stopRow = "stopRow".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        int maxVersions = 2;
        Scan scan = new Scan(startRow, stopRow);
        scan.addColumn(fam, qf1);
        scan.setTimeRange(ts, ts + 1L);
        scan.setMaxVersions(maxVersions);
        byte[] sb = Writables.getBytes(scan);
        Scan desScan = (Scan)Writables.getWritable(sb, new Scan());
        TestSerialization.assertTrue((boolean)Bytes.equals(scan.getStartRow(), desScan.getStartRow()));
        TestSerialization.assertTrue((boolean)Bytes.equals(scan.getStopRow(), desScan.getStopRow()));
        TestSerialization.assertEquals((boolean)scan.getCacheBlocks(), (boolean)desScan.getCacheBlocks());
        Set set = null;
        Set desSet = null;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : scan.getFamilyMap().entrySet()) {
            TestSerialization.assertTrue((boolean)desScan.getFamilyMap().containsKey(entry.getKey()));
            set = entry.getValue();
            desSet = desScan.getFamilyMap().get(entry.getKey());
            for (byte[] column : set) {
                TestSerialization.assertTrue((boolean)desSet.contains(column));
            }
            scan = new Scan(startRow);
            byte[] prefix = Bytes.toBytes(this.getName());
            scan.setFilter(new PrefixFilter(prefix));
            sb = Writables.getBytes(scan);
            desScan = (Scan)Writables.getWritable(sb, new Scan());
            Filter f = desScan.getFilter();
            TestSerialization.assertTrue((boolean)(f instanceof PrefixFilter));
        }
        TestSerialization.assertEquals((int)scan.getMaxVersions(), (int)desScan.getMaxVersions());
        TimeRange tr = scan.getTimeRange();
        TimeRange desTr = desScan.getTimeRange();
        TestSerialization.assertEquals((long)tr.getMax(), (long)desTr.getMax());
        TestSerialization.assertEquals((long)tr.getMin(), (long)desTr.getMin());
    }

    public void testResultEmpty() throws Exception {
        ArrayList<KeyValue> keys = new ArrayList<KeyValue>();
        Result r = new Result(keys);
        TestSerialization.assertTrue((boolean)r.isEmpty());
        byte[] rb = Writables.getBytes(r);
        Result deserializedR = (Result)Writables.getWritable(rb, new Result());
        TestSerialization.assertTrue((boolean)deserializedR.isEmpty());
    }

    public void testResult() throws Exception {
        byte[] rowA = Bytes.toBytes("rowA");
        byte[] famA = Bytes.toBytes("famA");
        byte[] qfA = Bytes.toBytes("qfA");
        byte[] valueA = Bytes.toBytes("valueA");
        byte[] rowB = Bytes.toBytes("rowB");
        byte[] famB = Bytes.toBytes("famB");
        byte[] qfB = Bytes.toBytes("qfB");
        byte[] valueB = Bytes.toBytes("valueB");
        KeyValue kvA = new KeyValue(rowA, famA, qfA, valueA);
        KeyValue kvB = new KeyValue(rowB, famB, qfB, valueB);
        Result result = new Result(new KeyValue[]{kvA, kvB});
        byte[] rb = Writables.getBytes(result);
        Result deResult = (Result)Writables.getWritable(rb, new Result());
        TestSerialization.assertTrue((String)"results are not equivalent, first key mismatch", (boolean)result.sorted()[0].equals(deResult.sorted()[0]));
        TestSerialization.assertTrue((String)"results are not equivalent, second key mismatch", (boolean)result.sorted()[1].equals(deResult.sorted()[1]));
        Result r = new Result();
        byte[] b = Writables.getBytes(r);
        Result deserialized = (Result)Writables.getWritable(b, new Result());
        TestSerialization.assertEquals((int)r.size(), (int)deserialized.size());
    }

    public void testResultDynamicBuild() throws Exception {
        byte[] rowA = Bytes.toBytes("rowA");
        byte[] famA = Bytes.toBytes("famA");
        byte[] qfA = Bytes.toBytes("qfA");
        byte[] valueA = Bytes.toBytes("valueA");
        byte[] rowB = Bytes.toBytes("rowB");
        byte[] famB = Bytes.toBytes("famB");
        byte[] qfB = Bytes.toBytes("qfB");
        byte[] valueB = Bytes.toBytes("valueB");
        KeyValue kvA = new KeyValue(rowA, famA, qfA, valueA);
        KeyValue kvB = new KeyValue(rowB, famB, qfB, valueB);
        Result result = new Result(new KeyValue[]{kvA, kvB});
        byte[] rb = Writables.getBytes(result);
        Result deResult = (Result)Writables.getWritable(rb, new Result());
        byte[] row = deResult.getRow();
        TestSerialization.assertTrue((boolean)Bytes.equals(row, rowA));
        deResult = (Result)Writables.getWritable(rb, new Result());
        TestSerialization.assertTrue((String)"results are not equivalent, first key mismatch", (boolean)result.sorted()[0].equals(deResult.sorted()[0]));
        TestSerialization.assertTrue((String)"results are not equivalent, second key mismatch", (boolean)result.sorted()[1].equals(deResult.sorted()[1]));
        deResult = (Result)Writables.getWritable(rb, new Result());
        TestSerialization.assertTrue((String)"results are not equivalent, first key mismatch", (boolean)result.raw()[0].equals(deResult.raw()[0]));
        TestSerialization.assertTrue((String)"results are not equivalent, second key mismatch", (boolean)result.raw()[1].equals(deResult.raw()[1]));
    }

    public void testResultArray() throws Exception {
        byte[] rowA = Bytes.toBytes("rowA");
        byte[] famA = Bytes.toBytes("famA");
        byte[] qfA = Bytes.toBytes("qfA");
        byte[] valueA = Bytes.toBytes("valueA");
        byte[] rowB = Bytes.toBytes("rowB");
        byte[] famB = Bytes.toBytes("famB");
        byte[] qfB = Bytes.toBytes("qfB");
        byte[] valueB = Bytes.toBytes("valueB");
        KeyValue kvA = new KeyValue(rowA, famA, qfA, valueA);
        KeyValue kvB = new KeyValue(rowB, famB, qfB, valueB);
        Result result1 = new Result(new KeyValue[]{kvA, kvB});
        Result result2 = new Result(new KeyValue[]{kvB});
        Result result3 = new Result(new KeyValue[]{kvB});
        Result[] results = new Result[]{result1, result2, result3};
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        Result.writeArray(out, results);
        byte[] rb = byteStream.toByteArray();
        DataInputBuffer in = new DataInputBuffer();
        in.reset(rb, 0, rb.length);
        Result[] deResults = Result.readArray((DataInput)in);
        TestSerialization.assertTrue((results.length == deResults.length ? 1 : 0) != 0);
        for (int i = 0; i < results.length; ++i) {
            KeyValue[] keysB;
            KeyValue[] keysA = results[i].sorted();
            TestSerialization.assertTrue((keysA.length == (keysB = deResults[i].sorted()).length ? 1 : 0) != 0);
            for (int j = 0; j < keysA.length; ++j) {
                TestSerialization.assertTrue((String)("Expected equivalent keys but found:\nKeyA : " + keysA[j].toString() + "\n" + "KeyB : " + keysB[j].toString() + "\n" + keysA.length + " total keys, " + i + "th so far"), (boolean)keysA[j].equals(keysB[j]));
            }
        }
    }

    public void testResultArrayEmpty() throws Exception {
        ArrayList<KeyValue> keys = new ArrayList<KeyValue>();
        Result r = new Result(keys);
        Result[] results = new Result[]{r};
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        Result.writeArray(out, results);
        results = null;
        byteStream = new ByteArrayOutputStream();
        out = new DataOutputStream(byteStream);
        Result.writeArray(out, results);
        byte[] rb = byteStream.toByteArray();
        DataInputBuffer in = new DataInputBuffer();
        in.reset(rb, 0, rb.length);
        Result[] deResults = Result.readArray((DataInput)in);
        TestSerialization.assertTrue((deResults.length == 0 ? 1 : 0) != 0);
        results = new Result[]{};
        byteStream = new ByteArrayOutputStream();
        out = new DataOutputStream(byteStream);
        Result.writeArray(out, results);
        rb = byteStream.toByteArray();
        in = new DataInputBuffer();
        in.reset(rb, 0, rb.length);
        deResults = Result.readArray((DataInput)in);
        TestSerialization.assertTrue((deResults.length == 0 ? 1 : 0) != 0);
    }

    public void testTimeRange(String[] args) throws Exception {
        TimeRange tr = new TimeRange(0L, 5L);
        byte[] mb = Writables.getBytes(tr);
        TimeRange deserializedTr = (TimeRange)Writables.getWritable(mb, new TimeRange());
        TestSerialization.assertEquals((long)tr.getMax(), (long)deserializedTr.getMax());
        TestSerialization.assertEquals((long)tr.getMin(), (long)deserializedTr.getMin());
    }

    public void testKeyValue2() throws Exception {
        byte[] row = this.getName().getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf = "qf".getBytes();
        long ts = System.currentTimeMillis();
        byte[] val = "val".getBytes();
        KeyValue kv = new KeyValue(row, fam, qf, ts, val);
        byte[] mb = Writables.getBytes(kv);
        KeyValue deserializedKv = (KeyValue)Writables.getWritable(mb, new KeyValue());
        TestSerialization.assertTrue((boolean)Bytes.equals(kv.getBuffer(), deserializedKv.getBuffer()));
        TestSerialization.assertEquals((int)kv.getOffset(), (int)deserializedKv.getOffset());
        TestSerialization.assertEquals((int)kv.getLength(), (int)deserializedKv.getLength());
    }
}

