/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWrapper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class TestZooKeeper
extends HBaseClusterTestCase {
    @Override
    protected void setUp() throws Exception {
        this.setOpenMetaTable(false);
        super.setUp();
    }

    public void testWritesRootRegionLocation() throws IOException {
        ZooKeeperWrapper zooKeeper = new ZooKeeperWrapper(this.conf, EmptyWatcher.instance);
        boolean outOfSafeMode = zooKeeper.checkOutOfSafeMode();
        TestZooKeeper.assertFalse((boolean)outOfSafeMode);
        HServerAddress zooKeeperRootAddress = zooKeeper.readRootRegionLocation();
        TestZooKeeper.assertNull((Object)zooKeeperRootAddress);
        HMaster master = this.cluster.getMaster();
        HServerAddress masterRootAddress = master.getRootRegionLocation();
        TestZooKeeper.assertNull((Object)masterRootAddress);
        new HTable(this.conf, HConstants.META_TABLE_NAME);
        outOfSafeMode = zooKeeper.checkOutOfSafeMode();
        TestZooKeeper.assertTrue((boolean)outOfSafeMode);
        zooKeeperRootAddress = zooKeeper.readRootRegionLocation();
        TestZooKeeper.assertNotNull((Object)zooKeeperRootAddress);
        masterRootAddress = master.getRootRegionLocation();
        TestZooKeeper.assertEquals((Object)masterRootAddress, (Object)zooKeeperRootAddress);
    }

    public void testParentExists() throws IOException {
        String oldValue = this.conf.get("zookeeper.znode.safemode");
        this.conf.set("zookeeper.znode.safemode", "/a/b/c/d/e");
        ZooKeeperWrapper zooKeeper = new ZooKeeperWrapper(this.conf, EmptyWatcher.instance);
        TestZooKeeper.assertTrue((boolean)zooKeeper.writeOutOfSafeMode());
        this.conf.set("zookeeper.znode.safemode", oldValue);
    }

    public void testClientSessionExpired() throws IOException, InterruptedException {
        new HTable(this.conf, HConstants.META_TABLE_NAME);
        ZooKeeperWrapper zkw = new ZooKeeperWrapper(this.conf, EmptyWatcher.instance);
        String quorumServers = zkw.getQuorumServers();
        int sessionTimeout = this.conf.getInt("zookeeper.session.timeout", 2000);
        HConnection connection = HConnectionManager.getConnection(this.conf);
        ZooKeeperWrapper connectionZK = connection.getZooKeeperWrapper();
        long sessionID = connectionZK.getSessionID();
        byte[] password = connectionZK.getSessionPassword();
        ZooKeeper zk = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance, sessionID, password);
        zk.close();
        Thread.sleep(sessionTimeout * 2);
        System.err.println("ZooKeeper should have timed out");
        connection.relocateRegion(HConstants.ROOT_TABLE_NAME, HConstants.EMPTY_BYTE_ARRAY);
    }

    public void testRegionServerSessionExpired() throws Exception {
        this.conf.setBoolean("hbase.regionserver.restart.on.zk.expire", true);
        new HTable(this.conf, HConstants.META_TABLE_NAME);
        HRegionServer rs = this.cluster.getRegionServer(0);
        this.sessionExpirationHelper(rs.getZooKeeperWrapper());
    }

    public void testMasterSessionExpired() throws Exception {
        new HTable(this.conf, HConstants.META_TABLE_NAME);
        HMaster master = this.cluster.getMaster();
        this.sessionExpirationHelper(master.getZooKeeperWrapper());
    }

    public void sessionExpirationHelper(ZooKeeperWrapper nodeZK) throws Exception {
        ZooKeeperWrapper zkw = new ZooKeeperWrapper(this.conf, EmptyWatcher.instance);
        String quorumServers = zkw.getQuorumServers();
        int sessionTimeout = 5000;
        byte[] password = nodeZK.getSessionPassword();
        long sessionID = nodeZK.getSessionID();
        ZooKeeper zk = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance, sessionID, password);
        zk.close();
        Thread.sleep((long)sessionTimeout * 3L);
        new HTable(this.conf, HConstants.META_TABLE_NAME);
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        HTableDescriptor desc = new HTableDescriptor("test");
        HColumnDescriptor family = new HColumnDescriptor("fam");
        desc.addFamily(family);
        admin.createTable(desc);
        HTable table = new HTable("test");
        Put put = new Put(Bytes.toBytes("testrow"));
        put.add(Bytes.toBytes("fam"), Bytes.toBytes("col"), Bytes.toBytes("testdata"));
        table.put(put);
    }

    public void testMultipleZK() {
        try {
            HTable localMeta = new HTable(this.conf, HConstants.META_TABLE_NAME);
            HBaseConfiguration otherConf = new HBaseConfiguration(this.conf);
            otherConf.set("hbase.zookeeper.quorum", "127.0.0.1");
            HTable ipMeta = new HTable(this.conf, HConstants.META_TABLE_NAME);
            localMeta.exists(new Get(HConstants.LAST_ROW));
            ipMeta.exists(new Get(HConstants.LAST_ROW));
            TestZooKeeper.assertFalse((HConnectionManager.getClientZooKeeperWatcher(this.conf).getZooKeeperWrapper() == HConnectionManager.getClientZooKeeperWatcher(otherConf).getZooKeeperWrapper() ? 1 : 0) != 0);
            TestZooKeeper.assertFalse((boolean)HConnectionManager.getConnection(this.conf).getZooKeeperWrapper().getQuorumServers().equals(HConnectionManager.getConnection(otherConf).getZooKeeperWrapper().getQuorumServers()));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestZooKeeper.fail();
        }
    }

    private static class EmptyWatcher
    implements Watcher {
        public static EmptyWatcher instance = new EmptyWatcher();

        private EmptyWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

