/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class TestScannerTimes
extends HBaseClusterTestCase {
    private static final String TABLE_NAME = "hbase737";
    private static final byte[] FAM1 = Bytes.toBytes("fam1");
    private static final byte[] FAM2 = Bytes.toBytes("fam2");
    private static final byte[] ROW = Bytes.toBytes("row");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHBase737() throws IOException {
        int i;
        Result r;
        HTableDescriptor desc = new HTableDescriptor(TABLE_NAME);
        desc.addFamily(new HColumnDescriptor(FAM1));
        desc.addFamily(new HColumnDescriptor(FAM2));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(desc);
        HTable table = new HTable(this.conf, TABLE_NAME);
        Put put = new Put(ROW);
        put.add(FAM1, Bytes.toBytes("letters"), Bytes.toBytes("abcdefg"));
        table.put(put);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        put = new Put(ROW);
        put.add(FAM1, Bytes.toBytes("numbers"), Bytes.toBytes("123456"));
        table.put(put);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        put = new Put(ROW);
        put.add(FAM2, Bytes.toBytes("letters"), Bytes.toBytes("hijklmnop"));
        table.put(put);
        long[] times = new long[3];
        Scan scan = new Scan();
        scan.addFamily(FAM1);
        scan.addFamily(FAM2);
        ResultScanner s = table.getScanner(scan);
        try {
            int index = 0;
            r = null;
            while ((r = s.next()) != null) {
                for (KeyValue key : r.sorted()) {
                    times[index++] = key.getTimestamp();
                }
            }
        }
        finally {
            s.close();
        }
        for (i = 0; i < times.length - 1; ++i) {
            for (int j = i + 1; j < times.length; ++j) {
                TestScannerTimes.assertTrue((times[j] > times[i] ? 1 : 0) != 0);
            }
        }
        this.cluster.flushcache();
        for (i = 0; i < times.length; ++i) {
            times[i] = 0L;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i4) {
            // empty catch block
        }
        scan = new Scan();
        scan.addFamily(FAM1);
        scan.addFamily(FAM2);
        s = table.getScanner(scan);
        try {
            int index = 0;
            r = null;
            while ((r = s.next()) != null) {
                for (KeyValue key : r.sorted()) {
                    times[index++] = key.getTimestamp();
                }
            }
        }
        finally {
            s.close();
        }
        for (int i5 = 0; i5 < times.length - 1; ++i5) {
            for (int j = i5 + 1; j < times.length; ++j) {
                TestScannerTimes.assertTrue((times[j] > times[i5] ? 1 : 0) != 0);
            }
        }
    }
}

