/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.ObjectWritable;

public class ColumnValueFilter
implements RowFilterInterface {
    private byte[] columnName;
    private CompareOp compareOp;
    private byte[] value;
    private WritableByteArrayComparable comparator;
    private boolean filterIfColumnMissing;

    ColumnValueFilter() {
    }

    public ColumnValueFilter(byte[] columnName, CompareOp compareOp, byte[] value) {
        this(columnName, compareOp, value, true);
    }

    public ColumnValueFilter(byte[] columnName, CompareOp compareOp, byte[] value, boolean filterIfColumnMissing) {
        this.columnName = columnName;
        this.compareOp = compareOp;
        this.value = value;
        this.filterIfColumnMissing = filterIfColumnMissing;
    }

    public ColumnValueFilter(byte[] columnName, CompareOp compareOp, WritableByteArrayComparable comparator) {
        this(columnName, compareOp, comparator, true);
    }

    public ColumnValueFilter(byte[] columnName, CompareOp compareOp, WritableByteArrayComparable comparator, boolean filterIfColumnMissing) {
        this.columnName = columnName;
        this.compareOp = compareOp;
        this.comparator = comparator;
        this.filterIfColumnMissing = filterIfColumnMissing;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey) {
        return this.filterRowKey(rowKey, 0, rowKey.length);
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        return false;
    }

    @Override
    public boolean filterColumn(byte[] rowKey, byte[] colKey, byte[] data) {
        if (!this.filterIfColumnMissing) {
            return false;
        }
        if (!Arrays.equals(colKey, this.columnName)) {
            return false;
        }
        return this.filterColumnValue(data, 0, data.length);
    }

    @Override
    public boolean filterColumn(byte[] rowKey, int roffset, int rlength, byte[] cn, int coffset, int clength, byte[] columnValue, int voffset, int vlength) {
        if (!this.filterIfColumnMissing) {
            return false;
        }
        if (Bytes.compareTo(cn, coffset, clength, this.columnName, 0, this.columnName.length) != 0) {
            return false;
        }
        return this.filterColumnValue(columnValue, voffset, vlength);
    }

    private boolean filterColumnValue(byte[] data, int offset, int length) {
        int compareResult = this.comparator != null ? this.comparator.compareTo(Arrays.copyOfRange(data, offset, offset + length)) : Bytes.compareTo(this.value, 0, this.value.length, data, offset, length);
        switch (this.compareOp) {
            case LESS: {
                return compareResult <= 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult < 0;
            }
            case EQUAL: {
                return compareResult != 0;
            }
            case NOT_EQUAL: {
                return compareResult == 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult > 0;
            }
            case GREATER: {
                return compareResult >= 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + this.compareOp.name());
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public boolean filterRow(SortedMap<byte[], Cell> columns) {
        if (columns == null) {
            return false;
        }
        if (this.filterIfColumnMissing) {
            return !columns.containsKey(this.columnName);
        }
        Cell colCell = (Cell)columns.get(this.columnName);
        if (colCell == null) {
            return false;
        }
        byte[] v = colCell.getValue();
        return this.filterColumnValue(v, 0, v.length);
    }

    @Override
    public boolean filterRow(List<KeyValue> results) {
        if (results == null) {
            return false;
        }
        KeyValue found = null;
        if (this.filterIfColumnMissing) {
            boolean doesntHaveIt = true;
            for (KeyValue kv : results) {
                if (!kv.matchingColumn(this.columnName)) continue;
                doesntHaveIt = false;
                found = kv;
                break;
            }
            if (doesntHaveIt) {
                return doesntHaveIt;
            }
        }
        if (found == null) {
            for (KeyValue kv : results) {
                if (!kv.matchingColumn(this.columnName)) continue;
                found = kv;
                break;
            }
        }
        if (found == null) {
            return false;
        }
        return this.filterColumnValue(found.getBuffer(), found.getValueOffset(), found.getValueLength());
    }

    @Override
    public boolean processAlways() {
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] key) {
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] key, int offset, int length) {
    }

    @Override
    public void validate(byte[][] columns) {
    }

    public void readFields(DataInput in) throws IOException {
        int valueLen = in.readInt();
        if (valueLen > 0) {
            this.value = new byte[valueLen];
            in.readFully(this.value);
        }
        this.columnName = Bytes.readByteArray(in);
        this.compareOp = CompareOp.valueOf(in.readUTF());
        this.comparator = (WritableByteArrayComparable)ObjectWritable.readObject((DataInput)in, (Configuration)new HBaseConfiguration());
        this.filterIfColumnMissing = in.readBoolean();
    }

    public void write(DataOutput out) throws IOException {
        if (this.value == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.value.length);
            out.write(this.value);
        }
        Bytes.writeByteArray(out, this.columnName);
        out.writeUTF(this.compareOp.name());
        ObjectWritable.writeObject((DataOutput)out, (Object)this.comparator, WritableByteArrayComparable.class, (Configuration)new HBaseConfiguration());
        out.writeBoolean(this.filterIfColumnMissing);
    }

    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER;

    }
}

