/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;

public abstract class CompareFilter
implements Filter {
    protected CompareOp compareOp;
    protected WritableByteArrayComparable comparator;

    public CompareFilter() {
    }

    public CompareFilter(CompareOp compareOp, WritableByteArrayComparable comparator) {
        this.compareOp = compareOp;
        this.comparator = comparator;
    }

    @Override
    public void reset() {
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRowKey(byte[] data, int offset, int length) {
        return false;
    }

    @Override
    public boolean filterRow() {
        return false;
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    protected boolean doCompare(CompareOp compareOp, WritableByteArrayComparable comparator, byte[] data, int offset, int length) {
        int compareResult = comparator.compareTo(Arrays.copyOfRange(data, offset, offset + length));
        switch (compareOp) {
            case LESS: {
                return compareResult <= 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult < 0;
            }
            case EQUAL: {
                return compareResult != 0;
            }
            case NOT_EQUAL: {
                return compareResult == 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult > 0;
            }
            case GREATER: {
                return compareResult >= 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + compareOp.name());
    }

    public void readFields(DataInput in) throws IOException {
        this.compareOp = CompareOp.valueOf(in.readUTF());
        this.comparator = (WritableByteArrayComparable)HbaseObjectWritable.readObject(in, null);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.compareOp.name());
        HbaseObjectWritable.writeObject(out, this.comparator, WritableByteArrayComparable.class, null);
    }

    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER;

    }
}

