/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.io.ObjectWritable;

public class RowFilterSet
implements RowFilterInterface {
    private Operator operator = Operator.MUST_PASS_ALL;
    private Set<RowFilterInterface> filters = new HashSet<RowFilterInterface>();

    public RowFilterSet() {
    }

    public RowFilterSet(Set<RowFilterInterface> rowFilters) {
        this.filters = rowFilters;
    }

    public RowFilterSet(Operator operator, Set<RowFilterInterface> rowFilters) {
        this.filters = rowFilters;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Set<RowFilterInterface> getFilters() {
        return this.filters;
    }

    public void addFilter(RowFilterInterface filter) {
        this.filters.add(filter);
    }

    @Override
    public void validate(byte[][] columns) {
        for (RowFilterInterface filter : this.filters) {
            filter.validate(columns);
        }
    }

    @Override
    public void reset() {
        for (RowFilterInterface filter : this.filters) {
            filter.reset();
        }
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] rowKey) {
        this.rowProcessed(filtered, rowKey, 0, rowKey.length);
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] key, int offset, int length) {
        for (RowFilterInterface filter : this.filters) {
            filter.rowProcessed(filtered, key, offset, length);
        }
    }

    @Override
    public boolean processAlways() {
        for (RowFilterInterface filter : this.filters) {
            if (!filter.processAlways()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterAllRemaining() {
        boolean result = this.operator == Operator.MUST_PASS_ONE;
        for (RowFilterInterface filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining()) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining()) continue;
            return false;
        }
        return result;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey) {
        return this.filterRowKey(rowKey, 0, rowKey.length);
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        boolean resultFound = false;
        boolean result = this.operator == Operator.MUST_PASS_ONE;
        for (RowFilterInterface filter : this.filters) {
            if (!resultFound) {
                if (this.operator == Operator.MUST_PASS_ALL) {
                    if (!filter.filterAllRemaining() && !filter.filterRowKey(rowKey, offset, length)) continue;
                    result = true;
                    resultFound = true;
                    continue;
                }
                if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRowKey(rowKey, offset, length)) continue;
                result = false;
                resultFound = true;
                continue;
            }
            if (!filter.processAlways()) continue;
            filter.filterRowKey(rowKey, offset, length);
        }
        return result;
    }

    @Override
    public boolean filterColumn(byte[] rowKey, byte[] colKey, byte[] data) {
        return this.filterColumn(rowKey, 0, rowKey.length, colKey, 0, colKey.length, data, 0, data.length);
    }

    @Override
    public boolean filterColumn(byte[] rowKey, int roffset, int rlength, byte[] columnName, int coffset, int clength, byte[] columnValue, int voffset, int vlength) {
        boolean resultFound = false;
        boolean result = this.operator == Operator.MUST_PASS_ONE;
        for (RowFilterInterface filter : this.filters) {
            if (!resultFound) {
                if (this.operator == Operator.MUST_PASS_ALL) {
                    if (!filter.filterAllRemaining() && !filter.filterColumn(rowKey, roffset, rlength, columnName, coffset, clength, columnValue, voffset, vlength)) continue;
                    result = true;
                    resultFound = true;
                    continue;
                }
                if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterColumn(rowKey, roffset, rlength, columnName, coffset, clength, columnValue, voffset, vlength)) continue;
                result = false;
                resultFound = true;
                continue;
            }
            if (!filter.processAlways()) continue;
            filter.filterColumn(rowKey, roffset, rlength, columnName, coffset, clength, columnValue, voffset, vlength);
        }
        return result;
    }

    @Override
    public boolean filterRow(SortedMap<byte[], Cell> columns) {
        boolean resultFound = false;
        boolean result = this.operator == Operator.MUST_PASS_ONE;
        for (RowFilterInterface filter : this.filters) {
            if (!resultFound) {
                if (this.operator == Operator.MUST_PASS_ALL) {
                    if (!filter.filterAllRemaining() && !filter.filterRow(columns)) continue;
                    result = true;
                    resultFound = true;
                    continue;
                }
                if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRow(columns)) continue;
                result = false;
                resultFound = true;
                continue;
            }
            if (!filter.processAlways()) continue;
            filter.filterRow(columns);
        }
        return result;
    }

    @Override
    public boolean filterRow(List<KeyValue> results) {
        boolean resultFound = false;
        boolean result = this.operator == Operator.MUST_PASS_ONE;
        for (RowFilterInterface filter : this.filters) {
            if (!resultFound) {
                if (this.operator == Operator.MUST_PASS_ALL) {
                    if (!filter.filterAllRemaining() && !filter.filterRow(results)) continue;
                    result = true;
                    resultFound = true;
                    continue;
                }
                if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRow(results)) continue;
                result = false;
                resultFound = true;
                continue;
            }
            if (!filter.processAlways()) continue;
            filter.filterRow(results);
        }
        return result;
    }

    public void readFields(DataInput in) throws IOException {
        HBaseConfiguration conf = new HBaseConfiguration();
        byte opByte = in.readByte();
        this.operator = Operator.values()[opByte];
        int size = in.readInt();
        if (size > 0) {
            this.filters = new HashSet<RowFilterInterface>();
            for (int i = 0; i < size; ++i) {
                RowFilterInterface filter = (RowFilterInterface)ObjectWritable.readObject((DataInput)in, (Configuration)conf);
                this.filters.add(filter);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        HBaseConfiguration conf = new HBaseConfiguration();
        out.writeByte(this.operator.ordinal());
        out.writeInt(this.filters.size());
        for (RowFilterInterface filter : this.filters) {
            ObjectWritable.writeObject((DataOutput)out, (Object)filter, RowFilterInterface.class, (Configuration)conf);
        }
    }

    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

