/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class TestFilterAcrossRegions
extends HBaseTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStop() throws IOException {
        byte[] name = Bytes.toBytes(this.getName());
        HTableDescriptor htd = new HTableDescriptor(name);
        htd.addFamily(new HColumnDescriptor(name));
        byte[] tenBoundary = Bytes.toBytes(10);
        byte[] twentyBoundary = Bytes.toBytes(20);
        HRegion r0 = this.createRegion(htd, HConstants.EMPTY_BYTE_ARRAY, tenBoundary);
        HRegion r1 = this.createRegion(htd, tenBoundary, twentyBoundary);
        HRegion r2 = this.createRegion(htd, twentyBoundary, HConstants.EMPTY_BYTE_ARRAY);
        HRegion[] regions = new HRegion[]{r0, r1, r2};
        int max = 30;
        try {
            for (HRegion r : regions) {
                this.populate(Bytes.toInt(r.getStartKey()), Bytes.toInt(r.getEndKey()), r, 30);
            }
            this.assertAllRows(regions, 30);
            this.assertFilterStops(regions, 30);
        }
        finally {
            for (HRegion r : regions) {
                r.close();
            }
        }
    }

    private void assertFilterStops(HRegion[] regions, int max) throws IOException {
        int count = 0;
        int maximumRow = max / regions.length;
        int regionCount = 0;
        for (HRegion r : regions) {
            Scan s = this.createFilterStopsScanner(maximumRow);
            InternalScanner scanner = r.getScanner(s);
            ArrayList<KeyValue> results = new ArrayList<KeyValue>();
            boolean hasMore = false;
            do {
                if (hasMore = scanner.next(results)) {
                    ++count;
                }
                if (regionCount == 0) {
                    TestFilterAcrossRegions.assertFalse((boolean)s.getFilter().filterAllRemaining());
                }
                results.clear();
            } while (hasMore);
            if (regionCount > 0) {
                TestFilterAcrossRegions.assertTrue((boolean)s.getFilter().filterAllRemaining());
            }
            ++regionCount;
        }
        TestFilterAcrossRegions.assertEquals((int)(maximumRow - 1), (int)count);
    }

    private Scan createFilterStopsScanner(int max) {
        Scan s = new Scan();
        Filter f = new RowFilter(CompareFilter.CompareOp.LESS, new BinaryComparator(Bytes.toBytes(max)));
        f = new WhileMatchFilter(f);
        s.setFilter(f);
        return s;
    }

    private void assertAllRows(HRegion[] regions, int max) throws IOException {
        int count = 0;
        for (HRegion r : regions) {
            count += this.scan(r, new Scan());
        }
        TestFilterAcrossRegions.assertEquals((int)max, (int)count);
    }

    private int scan(HRegion r, Scan scan) throws IOException {
        InternalScanner scanner = r.getScanner(new Scan(scan));
        int count = 0;
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        do {
            ++count;
        } while (scanner.next(results));
        return count;
    }

    private HRegion createRegion(HTableDescriptor htd, byte[] start, byte[] end) throws IOException {
        HRegionInfo info = new HRegionInfo(htd, start, end, false);
        Path path = new Path(this.testDir, this.getName());
        return HRegion.createHRegion(info, path, this.conf);
    }

    private void populate(int start, int end, HRegion r, int max) throws IOException {
        byte[] name = r.getTableDesc().getFamiliesKeys().iterator().next();
        int s = start < 0 ? 0 : start;
        int e = end < 0 ? max : end;
        for (int i = s; i < e; ++i) {
            Put p = new Put(Bytes.toBytes(i));
            p.add(name, name, name);
            r.put(p);
        }
    }
}

