/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class BatchOperation
implements Writable,
HeapSize {
    public final int ESTIMATED_HEAP_TAX = 36;
    private byte[] column = null;
    private byte[] value = null;

    public BatchOperation() {
        this((byte[])null);
    }

    public BatchOperation(byte[] column) {
        this(column, null);
    }

    public BatchOperation(String column) {
        this(Bytes.toBytes(column), null);
    }

    public BatchOperation(String column, String value) {
        this(Bytes.toBytes(column), Bytes.toBytes(value));
    }

    public BatchOperation(byte[] column, byte[] value) {
        this.column = column;
        this.value = value;
    }

    public byte[] getColumn() {
        return this.column;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean isPut() {
        return this.value != null;
    }

    public String toString() {
        return "column => " + Bytes.toString(this.column) + ", value => '...'";
    }

    public void readFields(DataInput in) throws IOException {
        this.column = Bytes.readByteArray(in);
        if (in.readBoolean()) {
            this.value = new byte[in.readInt()];
            in.readFully(this.value);
        }
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.column);
        boolean p = this.isPut();
        out.writeBoolean(p);
        if (p) {
            out.writeInt(this.value.length);
            out.write(this.value);
        }
    }

    @Override
    public long heapSize() {
        return 32 + this.column.length + this.value.length + 36;
    }
}

