/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.BatchOperation;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;

public class BatchUpdate
implements WritableComparable<BatchUpdate>,
Iterable<BatchOperation>,
HeapSize {
    private static final Log LOG = LogFactory.getLog(BatchUpdate.class);
    public static final int ESTIMATED_HEAP_TAX = 88;
    private byte[] row = null;
    private long size = 0L;
    private ArrayList<BatchOperation> operations = new ArrayList();
    private long timestamp = Long.MAX_VALUE;
    private long rowLock = -1L;

    public BatchUpdate() {
        this((byte[])null);
    }

    public BatchUpdate(String row) {
        this(Bytes.toBytes(row), Long.MAX_VALUE);
    }

    public BatchUpdate(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public BatchUpdate(String row, long timestamp) {
        this(Bytes.toBytes(row), timestamp);
    }

    public BatchUpdate(BatchUpdate buToCopy) {
        this(buToCopy.getRow(), buToCopy.getTimestamp());
        for (BatchOperation bo : buToCopy) {
            byte[] val = bo.getValue();
            if (val == null) {
                this.delete(bo.getColumn());
                continue;
            }
            this.put(bo.getColumn(), val);
        }
    }

    public BatchUpdate(byte[] row, long timestamp) {
        this.row = row;
        this.timestamp = timestamp;
        this.operations = new ArrayList();
        this.size = row == null ? 0L : (long)row.length;
    }

    public BatchUpdate(RowResult rr) {
        this(rr.getRow());
        for (Map.Entry<byte[], Cell> entry : rr.entrySet()) {
            this.put(entry.getKey(), entry.getValue().getValue());
        }
    }

    public long getRowLock() {
        return this.rowLock;
    }

    public void setRowLock(long rowLock) {
        this.rowLock = rowLock;
    }

    public byte[] getRow() {
        return this.row;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public synchronized byte[] get(String column) {
        return this.get(Bytes.toBytes(column));
    }

    public synchronized byte[] get(byte[] column) {
        for (BatchOperation operation : this.operations) {
            if (!Arrays.equals(column, operation.getColumn())) continue;
            return operation.getValue();
        }
        return null;
    }

    public synchronized byte[][] getColumns() {
        byte[][] columns = new byte[this.operations.size()][];
        for (int i = 0; i < this.operations.size(); ++i) {
            columns[i] = this.operations.get(i).getColumn();
        }
        return columns;
    }

    public synchronized boolean hasColumn(String column) {
        return this.hasColumn(Bytes.toBytes(column));
    }

    public synchronized boolean hasColumn(byte[] column) {
        byte[] getColumn = this.get(column);
        return getColumn != null;
    }

    public synchronized void put(String column, byte[] val) {
        this.put(Bytes.toBytes(column), val);
    }

    public synchronized void put(byte[] column, byte[] val) {
        if (val == null) {
            throw new IllegalArgumentException("Passed value cannot be null");
        }
        BatchOperation bo = new BatchOperation(column, val);
        this.size += bo.heapSize();
        this.operations.add(bo);
    }

    public void delete(String column) {
        this.delete(Bytes.toBytes(column));
    }

    public synchronized void delete(byte[] column) {
        this.operations.add(new BatchOperation(column));
    }

    @Override
    public Iterator<BatchOperation> iterator() {
        return this.operations.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("row => ");
        sb.append(this.row == null ? "" : Bytes.toString(this.row));
        sb.append(", {");
        boolean morethanone = false;
        for (BatchOperation bo : this.operations) {
            if (morethanone) {
                sb.append(", ");
            }
            morethanone = true;
            sb.append(bo.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public void readFields(DataInput in) throws IOException {
        if (this.operations.size() != 0) {
            this.operations.clear();
        }
        this.row = Bytes.readByteArray(in);
        this.timestamp = in.readLong();
        this.size = in.readLong();
        int nOps = in.readInt();
        for (int i = 0; i < nOps; ++i) {
            BatchOperation op = new BatchOperation();
            op.readFields(in);
            this.operations.add(op);
        }
        this.rowLock = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.row);
        out.writeLong(this.timestamp);
        out.writeLong(this.size);
        out.writeInt(this.operations.size());
        for (BatchOperation op : this.operations) {
            op.write(out);
        }
        out.writeLong(this.rowLock);
    }

    public int compareTo(BatchUpdate o) {
        return Bytes.compareTo(this.row, o.getRow());
    }

    @Override
    public long heapSize() {
        return (long)(this.row.length + 16) + this.size + 88L;
    }

    public static void main(String[] args) throws InterruptedException {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        int count = 10000;
        BatchUpdate[] batch1 = new BatchUpdate[10000];
        long size = 0L;
        for (int i = 0; i < 10000; ++i) {
            BatchUpdate bu = new BatchUpdate(HConstants.EMPTY_BYTE_ARRAY);
            bu.put(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
            batch1[i] = bu;
            size += bu.heapSize();
        }
        LOG.info((Object)("batch1 estimated size=" + size));
        size = 0L;
        BatchUpdate[] batch2 = new BatchUpdate[10000];
        for (int i = 0; i < 10000; ++i) {
            BatchUpdate bu = new BatchUpdate(Bytes.toBytes(i));
            bu.put(Bytes.toBytes(i), new byte[i]);
            batch2[i] = bu;
            size += bu.heapSize();
        }
        LOG.info((Object)("batch2 estimated size=" + size));
        int seconds = 30;
        LOG.info((Object)"Waiting 30 seconds while heap dump is taken");
        for (int i = 0; i < 30; ++i) {
            Thread.sleep(1000L);
        }
        LOG.info((Object)"Exiting.");
    }
}

