/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.filter.StopRowFilter;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;

public class TestHbaseObjectWritable
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReadObjectDataInputConfiguration() throws IOException {
        HBaseConfiguration conf = new HBaseConfiguration();
        int COUNT = 101;
        TestHbaseObjectWritable.assertTrue((boolean)this.doType(conf, 101, Integer.TYPE).equals(101));
        byte[] testing = "testing".getBytes();
        byte[] result = (byte[])this.doType(conf, testing, testing.getClass());
        TestHbaseObjectWritable.assertTrue((WritableComparator.compareBytes((byte[])testing, (int)0, (int)testing.length, (byte[])result, (int)0, (int)result.length) == 0 ? 1 : 0) != 0);
        boolean exception = false;
        try {
            this.doType(conf, new File("a"), File.class);
        }
        catch (UnsupportedOperationException uoe) {
            exception = true;
        }
        TestHbaseObjectWritable.assertTrue((boolean)exception);
        int A = 65;
        byte[] bytes = new byte[]{65};
        Object obj = this.doType(conf, bytes, byte[].class);
        TestHbaseObjectWritable.assertTrue((((byte[])obj)[0] == 65 ? 1 : 0) != 0);
        obj = this.doType(conf, new Text(""), Text.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof Text));
        obj = this.doType(conf, new StopRowFilter(HConstants.EMPTY_BYTE_ARRAY), RowFilterInterface.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof StopRowFilter));
        obj = this.doType(conf, new PrefixFilter(HConstants.EMPTY_BYTE_ARRAY), PrefixFilter.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof PrefixFilter));
    }

    private Object doType(HBaseConfiguration conf, Object value, Class<?> clazz) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        HbaseObjectWritable.writeObject(out, value, clazz, conf);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(byteStream.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        Object product = HbaseObjectWritable.readObject(dis, conf);
        dis.close();
        return product;
    }
}

