/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.RawComparator;

public class TestHFile
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestHFile.class);
    private static String ROOT_DIR = System.getProperty("test.build.data", "/tmp/TestHFile");
    private final int minBlockSize = 512;
    private static String localFormatter = "%010d";

    public void testEmptyHFile() throws IOException {
        Path f = new Path(ROOT_DIR, this.getName());
        HFile.Writer w = new HFile.Writer(this.fs, f);
        w.close();
        HFile.Reader r = new HFile.Reader(this.fs, f, null, false);
        r.loadFileInfo();
        TestHFile.assertNull((Object)r.getFirstKey());
        TestHFile.assertNull((Object)r.getLastKey());
    }

    private int writeSomeRecords(HFile.Writer writer, int start, int n) throws IOException {
        String value = "value";
        for (int i = start; i < start + n; ++i) {
            String key = String.format(localFormatter, i);
            writer.append(Bytes.toBytes(key), Bytes.toBytes(value + key));
        }
        return start + n;
    }

    private void readAllRecords(HFileScanner scanner) throws IOException {
        this.readAndCheckbytes(scanner, 0, 100);
    }

    private int readAndCheckbytes(HFileScanner scanner, int start, int n) throws IOException {
        int i;
        String value = "value";
        for (i = start; i < start + n; ++i) {
            ByteBuffer key = scanner.getKey();
            ByteBuffer val = scanner.getValue();
            String keyStr = String.format(localFormatter, i);
            String valStr = value + keyStr;
            byte[] keyBytes = Bytes.toBytes(key);
            TestHFile.assertTrue((String)("bytes for keys do not match " + keyStr + " " + Bytes.toString(Bytes.toBytes(key))), (boolean)Arrays.equals(Bytes.toBytes(keyStr), keyBytes));
            byte[] valBytes = Bytes.toBytes(val);
            TestHFile.assertTrue((String)("bytes for vals do not match " + valStr + " " + Bytes.toString(valBytes)), (boolean)Arrays.equals(Bytes.toBytes(valStr), valBytes));
            if (!scanner.next()) break;
        }
        TestHFile.assertEquals((int)i, (int)(start + n - 1));
        return start + n;
    }

    private byte[] getSomeKey(int rowId) {
        return String.format(localFormatter, rowId).getBytes();
    }

    private void writeRecords(HFile.Writer writer) throws IOException {
        this.writeSomeRecords(writer, 0, 100);
        writer.close();
    }

    private FSDataOutputStream createFSOutput(Path name) throws IOException {
        if (this.fs.exists(name)) {
            this.fs.delete(name, true);
        }
        FSDataOutputStream fout = this.fs.create(name);
        return fout;
    }

    void basicWithSomeCodec(String codec) throws IOException {
        Path ncTFile = new Path(ROOT_DIR, "basic.hfile");
        FSDataOutputStream fout = this.createFSOutput(ncTFile);
        HFile.Writer writer = new HFile.Writer(fout, 512, Compression.getCompressionAlgorithmByName(codec), null);
        LOG.info((Object)writer);
        this.writeRecords(writer);
        fout.close();
        FSDataInputStream fin = this.fs.open(ncTFile);
        HFile.Reader reader = new HFile.Reader(this.fs.open(ncTFile), this.fs.getFileStatus(ncTFile).getLen(), null, false);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner();
        scanner.seekTo();
        this.readAllRecords(scanner);
        scanner.seekTo(this.getSomeKey(50));
        TestHFile.assertTrue((String)"location lookup failed", (scanner.seekTo(this.getSomeKey(50)) == 0 ? 1 : 0) != 0);
        ByteBuffer readKey = scanner.getKey();
        TestHFile.assertTrue((String)"seeked key does not match", (boolean)Arrays.equals(this.getSomeKey(50), Bytes.toBytes(readKey)));
        scanner.seekTo(new byte[0]);
        ByteBuffer val1 = scanner.getValue();
        scanner.seekTo(new byte[0]);
        ByteBuffer val2 = scanner.getValue();
        TestHFile.assertTrue((boolean)Arrays.equals(Bytes.toBytes(val1), Bytes.toBytes(val2)));
        reader.close();
        fin.close();
        this.fs.delete(ncTFile, true);
    }

    public void testTFileFeatures() throws IOException {
        this.basicWithSomeCodec("none");
        this.basicWithSomeCodec("gz");
    }

    private void writeNumMetablocks(HFile.Writer writer, int n) {
        for (int i = 0; i < n; ++i) {
            writer.appendMetaBlock("HFileMeta" + i, ("something to test" + i).getBytes());
        }
    }

    private void someTestingWithMetaBlock(HFile.Writer writer) {
        this.writeNumMetablocks(writer, 10);
    }

    private void readNumMetablocks(HFile.Reader reader, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            ByteBuffer b = reader.getMetaBlock("HFileMeta" + i);
            byte[] found = Bytes.toBytes(b);
            TestHFile.assertTrue((String)"failed to match metadata", (boolean)Arrays.equals(("something to test" + i).getBytes(), found));
        }
    }

    private void someReadingWithMetaBlock(HFile.Reader reader) throws IOException {
        this.readNumMetablocks(reader, 10);
    }

    private void metablocks(String compress) throws Exception {
        Path mFile = new Path(ROOT_DIR, "meta.hfile");
        FSDataOutputStream fout = this.createFSOutput(mFile);
        HFile.Writer writer = new HFile.Writer(fout, 512, Compression.getCompressionAlgorithmByName(compress), null);
        this.someTestingWithMetaBlock(writer);
        writer.close();
        fout.close();
        FSDataInputStream fin = this.fs.open(mFile);
        HFile.Reader reader = new HFile.Reader(this.fs.open(mFile), this.fs.getFileStatus(mFile).getLen(), null, false);
        reader.loadFileInfo();
        TestHFile.assertFalse((boolean)reader.getScanner().seekTo());
        this.someReadingWithMetaBlock(reader);
        this.fs.delete(mFile, true);
        reader.close();
        fin.close();
    }

    public void testMetaBlocks() throws Exception {
        this.metablocks("none");
        this.metablocks("gz");
    }

    public void testNullMetaBlocks() throws Exception {
        Path mFile = new Path(ROOT_DIR, "nometa.hfile");
        FSDataOutputStream fout = this.createFSOutput(mFile);
        HFile.Writer writer = new HFile.Writer(fout, 512, Compression.Algorithm.NONE, null);
        writer.append("foo".getBytes(), "value".getBytes());
        writer.close();
        fout.close();
        HFile.Reader reader = new HFile.Reader(this.fs, mFile, null, false);
        reader.loadFileInfo();
        TestHFile.assertNull((Object)reader.getMetaBlock("non-existant"));
    }

    public void testCompressionOrdinance() {
        TestHFile.assertTrue((Compression.Algorithm.GZ.ordinal() == 1 ? 1 : 0) != 0);
        TestHFile.assertTrue((Compression.Algorithm.NONE.ordinal() == 2 ? 1 : 0) != 0);
    }

    public void testComparator() throws IOException {
        Path mFile = new Path(ROOT_DIR, "meta.tfile");
        FSDataOutputStream fout = this.createFSOutput(mFile);
        HFile.Writer writer = new HFile.Writer(fout, 512, (Compression.Algorithm)null, new RawComparator<byte[]>(){

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                return -Bytes.compareTo(b1, s1, l1, b2, s2, l2);
            }

            public int compare(byte[] o1, byte[] o2) {
                return this.compare(o1, 0, o1.length, o2, 0, o2.length);
            }
        });
        writer.append("3".getBytes(), "0".getBytes());
        writer.append("2".getBytes(), "0".getBytes());
        writer.append("1".getBytes(), "0".getBytes());
        writer.close();
    }

    public void testHeapSizeForBlockIndex() throws IOException {
        Class<HFile.BlockIndex> cl = null;
        long expected = 0L;
        long actual = 0L;
        cl = HFile.BlockIndex.class;
        expected = ClassSize.estimateBase(cl, false);
        HFile.BlockIndex bi = new HFile.BlockIndex(Bytes.BYTES_RAWCOMPARATOR);
        actual = bi.heapSize();
        if ((expected -= (long)ClassSize.align(3 * ClassSize.ARRAY)) != actual) {
            ClassSize.estimateBase(cl, true);
            TestHFile.assertEquals((long)expected, (long)actual);
        }
    }
}

