/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class TestSeekTo
extends HBaseTestCase {
    Path makeNewFile() throws IOException {
        Path ncTFile = new Path(this.testDir, "basic.hfile");
        FSDataOutputStream fout = this.fs.create(ncTFile);
        HFile.Writer writer = new HFile.Writer(fout, 40, "none", null);
        writer.append(Bytes.toBytes("c"), Bytes.toBytes("value"));
        writer.append(Bytes.toBytes("e"), Bytes.toBytes("value"));
        writer.append(Bytes.toBytes("g"), Bytes.toBytes("value"));
        writer.append(Bytes.toBytes("i"), Bytes.toBytes("value"));
        writer.append(Bytes.toBytes("k"), Bytes.toBytes("value"));
        writer.close();
        fout.close();
        return ncTFile;
    }

    public void testSeekBefore() throws Exception {
        Path p = this.makeNewFile();
        HFile.Reader reader = new HFile.Reader(this.fs, p, null, false);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner();
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore(Bytes.toBytes("a")));
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore(Bytes.toBytes("c")));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes("d")));
        TestSeekTo.assertEquals((String)"c", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes("e")));
        TestSeekTo.assertEquals((String)"c", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes("f")));
        TestSeekTo.assertEquals((String)"e", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes("g")));
        TestSeekTo.assertEquals((String)"e", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes("h")));
        TestSeekTo.assertEquals((String)"g", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes("i")));
        TestSeekTo.assertEquals((String)"g", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes("j")));
        TestSeekTo.assertEquals((String)"i", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes("k")));
        TestSeekTo.assertEquals((String)"i", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes("l")));
        TestSeekTo.assertEquals((String)"k", (String)scanner.getKeyString());
    }

    public void testSeekTo() throws Exception {
        Path p = this.makeNewFile();
        HFile.Reader reader = new HFile.Reader(this.fs, p, null, false);
        reader.loadFileInfo();
        TestSeekTo.assertEquals((int)2, (int)reader.blockIndex.count);
        HFileScanner scanner = reader.getScanner();
        TestSeekTo.assertEquals((int)-1, (int)scanner.seekTo(Bytes.toBytes("a")));
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo(Bytes.toBytes("d")));
        TestSeekTo.assertEquals((String)"c", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo(Bytes.toBytes("h")));
        TestSeekTo.assertEquals((String)"g", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo(Bytes.toBytes("l")));
        TestSeekTo.assertEquals((String)"k", (String)scanner.getKeyString());
    }

    public void testBlockContainingKey() throws Exception {
        Path p = this.makeNewFile();
        HFile.Reader reader = new HFile.Reader(this.fs, p, null, false);
        reader.loadFileInfo();
        System.out.println(reader.blockIndex.toString());
        TestSeekTo.assertEquals((int)-1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("a"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("c"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("d"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("e"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("g"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("h"), 0, 1));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("i"), 0, 1));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("j"), 0, 1));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("k"), 0, 1));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes("l"), 0, 1));
    }
}

