/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.IndexConfiguration;
import org.apache.hadoop.hbase.mapreduce.IndexRecordWriter;
import org.apache.hadoop.hbase.mapreduce.LuceneDocumentWrapper;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Similarity;

public class IndexOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, LuceneDocumentWrapper> {
    static final Log LOG = LogFactory.getLog(IndexOutputFormat.class);
    private Random random = new Random();

    public RecordWriter<ImmutableBytesWritable, LuceneDocumentWrapper> getRecordWriter(TaskAttemptContext context) throws IOException {
        Analyzer analyzer;
        Path perm = new Path(FileOutputFormat.getOutputPath((JobContext)context), FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)"part", (String)""));
        Path temp = context.getConfiguration().getLocalPath("mapred.local.dir", "index/_" + Integer.toString(this.random.nextInt()));
        LOG.info((Object)("To index into " + perm));
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        fs.delete(perm, true);
        IndexConfiguration indexConf = new IndexConfiguration();
        String content = context.getConfiguration().get("hbase.index.conf");
        if (content != null) {
            indexConf.addFromXML(content);
        }
        String analyzerName = indexConf.getAnalyzerName();
        try {
            Class<?> analyzerClass = Class.forName(analyzerName);
            analyzer = (Analyzer)analyzerClass.newInstance();
        }
        catch (Exception e) {
            throw new IOException("Error in creating an analyzer object " + analyzerName);
        }
        IndexWriter writer = new IndexWriter(fs.startLocalOutput(perm, temp).toString(), analyzer, true);
        writer.setMaxBufferedDocs(indexConf.getMaxBufferedDocs());
        writer.setMaxFieldLength(indexConf.getMaxFieldLength());
        writer.setMaxMergeDocs(indexConf.getMaxMergeDocs());
        writer.setMergeFactor(indexConf.getMergeFactor());
        String similarityName = indexConf.getSimilarityName();
        if (similarityName != null) {
            try {
                Class<?> similarityClass = Class.forName(similarityName);
                Similarity similarity = (Similarity)similarityClass.newInstance();
                writer.setSimilarity(similarity);
            }
            catch (Exception e) {
                throw new IOException("Error in creating a similarty object " + similarityName);
            }
        }
        writer.setUseCompoundFile(indexConf.isUseCompoundFile());
        return new IndexRecordWriter(context, fs, writer, indexConf, perm, temp);
    }
}

