/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.util.StringUtils;

public class TableInputFormat
extends TableInputFormatBase
implements Configurable {
    private final Log LOG = LogFactory.getLog(TableInputFormat.class);
    public static final String INPUT_TABLE = "hbase.mapreduce.inputtable";
    public static final String SCAN = "hbase.mapreduce.scan";
    public static final String SCAN_COLUMNS = "hbase.mapreduce.scan.columns";
    public static final String SCAN_TIMESTAMP = "hbase.mapreduce.scan.timestamp";
    public static final String SCAN_TIMERANGE_START = "hbase.mapreduce.scan.timerange.start";
    public static final String SCAN_TIMERANGE_END = "hbase.mapreduce.scan.timerange.end";
    public static final String SCAN_MAXVERSIONS = "hbase.mapreduce.scan.maxversions";
    public static final String SCAN_CACHEBLOCKS = "hbase.mapreduce.scan.cacheblocks";
    public static final String SCAN_CACHEDROWS = "hbase.mapreduce.scan.cachedrows";
    private Configuration conf = null;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        String tableName = this.conf.get(INPUT_TABLE);
        try {
            this.setHTable(new HTable(new HBaseConfiguration(this.conf), tableName));
        }
        catch (Exception e) {
            this.LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
        Scan scan = null;
        if (this.conf.get(SCAN) != null) {
            try {
                scan = TableMapReduceUtil.convertStringToScan(this.conf.get(SCAN));
            }
            catch (IOException e) {
                this.LOG.error((Object)"An error occurred.", (Throwable)e);
            }
        } else {
            try {
                scan = new Scan();
                if (this.conf.get(SCAN_COLUMNS) != null) {
                    scan.addColumns(this.conf.get(SCAN_COLUMNS));
                }
                if (this.conf.get(SCAN_TIMESTAMP) != null) {
                    scan.setTimeStamp(Long.parseLong(this.conf.get(SCAN_TIMESTAMP)));
                }
                if (this.conf.get(SCAN_TIMERANGE_START) != null && this.conf.get(SCAN_TIMERANGE_END) != null) {
                    scan.setTimeRange(Long.parseLong(this.conf.get(SCAN_TIMERANGE_START)), Long.parseLong(this.conf.get(SCAN_TIMERANGE_END)));
                }
                if (this.conf.get(SCAN_MAXVERSIONS) != null) {
                    scan.setMaxVersions(Integer.parseInt(this.conf.get(SCAN_MAXVERSIONS)));
                }
                if (this.conf.get(SCAN_CACHEBLOCKS) != null) {
                    scan.setCacheBlocks(Boolean.parseBoolean(this.conf.get(SCAN_CACHEBLOCKS)));
                }
                if (this.conf.get(SCAN_CACHEDROWS) != null) {
                    scan.setCaching(Integer.parseInt(this.conf.get(SCAN_CACHEDROWS)));
                }
            }
            catch (Exception e) {
                this.LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            }
        }
        this.setScan(scan);
    }
}

