/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MultiRegionTable;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.IdentityTableReducer;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class TestTableMapReduce
extends MultiRegionTable {
    private static final Log LOG = LogFactory.getLog(TestTableMapReduce.class);
    static final String MULTI_REGION_TABLE_NAME = "mrtest";
    static final byte[] INPUT_COLUMN = Bytes.toBytes("contents:");
    static final byte[] INPUT_FAMILY = Bytes.toBytes("contents");
    static final byte[] OUTPUT_COLUMN = Bytes.toBytes("text:");
    static final byte[] OUTPUT_FAMILY = Bytes.toBytes("text");
    private static final byte[][] columns = new byte[][]{INPUT_COLUMN, OUTPUT_COLUMN};

    public TestTableMapReduce() {
        super(Bytes.toString(INPUT_COLUMN));
        this.desc = new HTableDescriptor(MULTI_REGION_TABLE_NAME);
        this.desc.addFamily(new HColumnDescriptor(INPUT_COLUMN));
        this.desc.addFamily(new HColumnDescriptor(OUTPUT_COLUMN));
    }

    public void testMultiRegionTable() throws IOException, InterruptedException, ClassNotFoundException {
        this.runTestOnTable(new HTable(this.conf, MULTI_REGION_TABLE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestOnTable(HTable table) throws IOException, InterruptedException, ClassNotFoundException {
        MiniMRCluster mrCluster = new MiniMRCluster(2, this.fs.getUri().toString(), 1);
        Job job = null;
        try {
            LOG.info((Object)"Before map/reduce startup");
            job = new Job((Configuration)this.conf, "process column contents");
            job.setNumReduceTasks(1);
            Scan scan = new Scan();
            scan.addFamily(INPUT_FAMILY);
            TableMapReduceUtil.initTableMapperJob(Bytes.toString(table.getTableName()), scan, ProcessContentsMapper.class, ImmutableBytesWritable.class, Put.class, job);
            TableMapReduceUtil.initTableReducerJob(Bytes.toString(table.getTableName()), IdentityTableReducer.class, job);
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path("test"));
            LOG.info((Object)("Started " + Bytes.toString(table.getTableName())));
            job.waitForCompletion(true);
            LOG.info((Object)"After map/reduce completion");
            this.verify(Bytes.toString(table.getTableName()));
        }
        finally {
            mrCluster.shutdown();
            if (job != null) {
                FileUtil.fullyDelete((File)new File(job.getConfiguration().get("hadoop.tmp.dir")));
            }
        }
    }

    private void verify(String tableName) throws IOException {
        HTable table = new HTable(this.conf, tableName);
        boolean verified = false;
        long pause = this.conf.getLong("hbase.client.pause", 5000L);
        int numRetries = this.conf.getInt("hbase.client.retries.number", 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                LOG.info((Object)("Verification attempt #" + i));
                this.verifyAttempt(table);
                verified = true;
                break;
            }
            catch (NullPointerException e) {
                LOG.debug((Object)("Verification attempt failed: " + e.getMessage()));
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        TestTableMapReduce.assertTrue((boolean)verified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAttempt(HTable table) throws IOException, NullPointerException {
        Scan scan = new Scan();
        scan.addColumns(columns);
        ResultScanner scanner = table.getScanner(scan);
        try {
            for (Result r : scanner) {
                if (LOG.isDebugEnabled() && r.size() > 2) {
                    throw new IOException("Too many results, expected 2 got " + r.size());
                }
                byte[] firstValue = null;
                byte[] secondValue = null;
                int count = 0;
                for (KeyValue kv : r.list()) {
                    if (count == 0) {
                        firstValue = kv.getValue();
                    }
                    if (count == 1) {
                        secondValue = kv.getValue();
                    }
                    if (++count != 2) continue;
                    break;
                }
                String first = "";
                if (firstValue == null) {
                    throw new NullPointerException(Bytes.toString(r.getRow()) + ": first value is null");
                }
                first = new String(firstValue, "UTF-8");
                String second = "";
                if (secondValue == null) {
                    throw new NullPointerException(Bytes.toString(r.getRow()) + ": second value is null");
                }
                byte[] secondReversed = new byte[secondValue.length];
                int i = 0;
                int j = secondValue.length - 1;
                while (j >= 0) {
                    secondReversed[i] = secondValue[j];
                    --j;
                    ++i;
                }
                second = new String(secondReversed, "UTF-8");
                if (first.compareTo(second) == 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("second key is not the reverse of first. row=" + Bytes.toStringBinary(r.getRow()) + ", first value=" + first + ", second value=" + second));
                }
                TestTableMapReduce.fail();
            }
        }
        finally {
            scanner.close();
        }
    }

    public static class ProcessContentsMapper
    extends TableMapper<ImmutableBytesWritable, Put> {
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.size() != 1) {
                throw new IOException("There should only be one input column");
            }
            NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> cf = value.getMap();
            if (!cf.containsKey(INPUT_FAMILY)) {
                throw new IOException("Wrong input columns. Missing: '" + Bytes.toString(INPUT_FAMILY) + "'.");
            }
            String originalValue = new String(value.getValue(INPUT_FAMILY, null), "UTF-8");
            StringBuilder newValue = new StringBuilder(originalValue);
            newValue.reverse();
            Put outval = new Put(key.get());
            outval.add(OUTPUT_FAMILY, null, Bytes.toBytes(newValue.toString()));
            context.write((Object)key, (Object)outval);
        }
    }
}

