/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerConnection;
import org.apache.hadoop.hbase.client.ServerConnectionManager;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.AddColumn;
import org.apache.hadoop.hbase.master.ChangeTableState;
import org.apache.hadoop.hbase.master.DeleteColumn;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.ModifyColumn;
import org.apache.hadoop.hbase.master.ModifyTableMeta;
import org.apache.hadoop.hbase.master.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.master.RegionManager;
import org.apache.hadoop.hbase.master.RegionServerOperation;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableDelete;
import org.apache.hadoop.hbase.master.ZKMasterAddressWatcher;
import org.apache.hadoop.hbase.master.metrics.MasterMetrics;
import org.apache.hadoop.hbase.regionserver.HLog;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWrapper;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class HMaster
extends Thread
implements HConstants,
HMasterInterface,
HMasterRegionInterface,
Watcher {
    static final Log LOG = LogFactory.getLog((String)HMaster.class.getName());
    volatile AtomicBoolean closed = new AtomicBoolean(true);
    volatile AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    volatile boolean fsOk = true;
    final Path rootdir;
    private final HBaseConfiguration conf;
    final FileSystem fs;
    final Random rand;
    final int threadWakeFrequency;
    final int numRetries;
    final long maxRegionOpenTime;
    final int leaseTimeout;
    private ZooKeeperWrapper zooKeeperWrapper;
    private final ZKMasterAddressWatcher zkMasterAddressWatcher;
    volatile DelayQueue<RegionServerOperation> delayedToDoQueue = new DelayQueue();
    volatile BlockingQueue<RegionServerOperation> toDoQueue = new PriorityBlockingQueue<RegionServerOperation>();
    private final HBaseServer server;
    private final HServerAddress address;
    final ServerConnection connection;
    final int metaRescanInterval;
    private final Sleeper sleeper;
    InfoServer infoServer;
    public static final String MASTER = "master";
    ServerManager serverManager;
    RegionManager regionManager;
    private MasterMetrics metrics;
    private long lastFragmentationQuery = -1L;
    private Map<String, Integer> fragmentation = null;

    public long getProtocolVersion(String protocol, long clientVersion) {
        return 21L;
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    public HMaster(HBaseConfiguration conf) throws IOException {
        String addressStr = DNS.getDefaultHost((String)conf.get("hbase.master.dns.interface", "default"), (String)conf.get("hbase.master.dns.nameserver", "default"));
        addressStr = addressStr + ":" + conf.get("hbase.master.port", Integer.toString(60000));
        HServerAddress address = new HServerAddress(addressStr);
        LOG.info((Object)("My address is " + address));
        this.conf = conf;
        this.rootdir = new Path(conf.get("hbase.rootdir"));
        try {
            FSUtils.validateRootPath(this.rootdir);
        }
        catch (IOException e) {
            LOG.fatal((Object)("Not starting HMaster because the root directory path '" + this.rootdir + "' is not valid. Check the setting of the" + " configuration parameter '" + "hbase.rootdir" + "'"), (Throwable)e);
            throw e;
        }
        this.threadWakeFrequency = conf.getInt("hbase.server.thread.wakefrequency", 10000);
        this.conf.set("fs.default.name", this.rootdir.toString());
        this.fs = FileSystem.get((Configuration)conf);
        this.conf.set("hbase.rootdir", this.rootdir.toString());
        this.rand = new Random();
        FSUtils.waitOnSafeMode(this.conf, this.threadWakeFrequency);
        try {
            if (!this.fs.exists(this.rootdir)) {
                this.fs.mkdirs(this.rootdir);
                FSUtils.setVersion(this.fs, this.rootdir);
            } else {
                FSUtils.checkVersion(this.fs, this.rootdir, true);
            }
            if (!FSUtils.rootRegionExists(this.fs, this.rootdir)) {
                this.bootstrap();
            }
        }
        catch (IOException e) {
            LOG.fatal((Object)"Not starting HMaster because:", (Throwable)e);
            throw e;
        }
        this.numRetries = conf.getInt("hbase.client.retries.number", 2);
        this.maxRegionOpenTime = conf.getLong("hbase.hbasemaster.maxregionopen", 120000L);
        this.leaseTimeout = conf.getInt("hbase.master.lease.period", 120000);
        this.server = HBaseRPC.getServer(this, address.getBindAddress(), address.getPort(), conf.getInt("hbase.regionserver.handler.count", 10), false, conf);
        this.address = new HServerAddress(this.server.getListenerAddress());
        conf.setInt("hbase.client.retries.number", 3);
        this.connection = ServerConnectionManager.getConnection(conf);
        this.metaRescanInterval = conf.getInt("hbase.master.meta.thread.rescanfrequency", 60000);
        this.sleeper = new Sleeper(this.threadWakeFrequency, this.closed);
        this.zooKeeperWrapper = new ZooKeeperWrapper(conf, this);
        this.zkMasterAddressWatcher = new ZKMasterAddressWatcher(this);
        this.serverManager = new ServerManager(this);
        this.regionManager = new RegionManager(this);
        this.writeAddressToZooKeeper(true);
        this.closed.set(false);
        LOG.info((Object)("HMaster initialized on " + this.address.toString()));
    }

    private boolean writeAddressToZooKeeper(boolean retry) {
        do {
            this.zkMasterAddressWatcher.waitForMasterAddressAvailability();
            if (this.shutdownRequested.get()) {
                LOG.debug((Object)"Won't start Master because cluster is shuting down");
                return false;
            }
            if (!this.zooKeeperWrapper.writeMasterAddress(this.address)) continue;
            this.zooKeeperWrapper.setClusterState(true);
            this.zooKeeperWrapper.setClusterStateWatch(this.zkMasterAddressWatcher);
            this.zooKeeperWrapper.readMasterAddress(this);
            return true;
        } while (retry);
        return false;
    }

    private void bootstrap() throws IOException {
        LOG.info((Object)"BOOTSTRAP: creating ROOT and first META regions");
        try {
            this.setBlockCaching(HRegionInfo.ROOT_REGIONINFO, false);
            this.setBlockCaching(HRegionInfo.FIRST_META_REGIONINFO, false);
            HRegion root = HRegion.createHRegion(HRegionInfo.ROOT_REGIONINFO, this.rootdir, this.conf);
            HRegion meta = HRegion.createHRegion(HRegionInfo.FIRST_META_REGIONINFO, this.rootdir, this.conf);
            HRegion.addRegionToMETA(root, meta);
            root.close();
            root.getLog().closeAndDelete();
            meta.close();
            meta.getLog().closeAndDelete();
            this.setBlockCaching(HRegionInfo.ROOT_REGIONINFO, true);
            this.setBlockCaching(HRegionInfo.FIRST_META_REGIONINFO, true);
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException(e);
            LOG.error((Object)"bootstrap", (Throwable)e);
            throw e;
        }
    }

    private void setBlockCaching(HRegionInfo hri, boolean b) {
        for (HColumnDescriptor hcd : hri.getTableDesc().families.values()) {
            hcd.setBlockCacheEnabled(b);
        }
    }

    protected boolean checkFileSystem() {
        if (this.fsOk) {
            try {
                FSUtils.checkFileSystemAvailable(this.fs);
            }
            catch (IOException e) {
                LOG.fatal((Object)"Shutting down HBase cluster: file system not available", (Throwable)e);
                this.closed.set(true);
                this.fsOk = false;
            }
        }
        return this.fsOk;
    }

    public HServerAddress getMasterAddress() {
        return this.address;
    }

    public Path getRootDir() {
        return this.rootdir;
    }

    public Map<String, HServerInfo> getServersToServerInfo() {
        return this.serverManager.getServersToServerInfo();
    }

    public Map<HServerAddress, HServerInfo> getServerAddressToServerInfo() {
        return this.serverManager.getServerAddressToServerInfo();
    }

    public Map<String, HServerLoad> getServersToLoad() {
        return this.serverManager.getServersToLoad();
    }

    public double getAverageLoad() {
        return this.serverManager.getAverageLoad();
    }

    public int countRegionsOnFS() {
        try {
            return this.regionManager.countRegionsOnFS();
        }
        catch (IOException e) {
            LOG.warn((Object)("Get count of Regions on FileSystem error : " + StringUtils.stringifyException((Throwable)e)));
            return -1;
        }
    }

    public HServerAddress getRootRegionLocation() {
        HServerAddress rootServer = null;
        if (!this.shutdownRequested.get() && !this.closed.get()) {
            rootServer = this.regionManager.getRootRegionLocation();
        }
        return rootServer;
    }

    public void waitForRootRegionLocation() {
        this.regionManager.waitForRootRegionLocation();
    }

    public Map<byte[], MetaRegion> getOnlineMetaRegions() {
        return this.regionManager.getOnlineMetaRegions();
    }

    public ServerManager getServerManager() {
        return this.serverManager;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        threadName = "HMaster";
        Thread.currentThread().setName("HMaster");
        this.verifyClusterState();
        this.startServiceThreads();
        try {
            while (!this.closed.get()) {
                if (!this.shutdownRequested.get()) ** GOTO lbl-1000
                this.regionManager.stopScanners();
                if (this.serverManager.numServers() == 0) {
                    this.startShutdown();
                } else if (this.processToDoQueue()) continue;
                break;
            }
        }
        catch (Throwable t) {
            HMaster.LOG.fatal((Object)"Unhandled exception. Starting shutdown.", t);
            this.closed.set(true);
        }
        this.serverManager.letRegionServersShutdown();
        if (this.infoServer != null) {
            HMaster.LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.server.stop();
        this.regionManager.stop();
        this.zooKeeperWrapper.close();
        HMaster.LOG.info((Object)"HMaster main thread exiting");
    }

    private boolean processToDoQueue() {
        block16: {
            RegionServerOperation op = null;
            if (this.regionManager.getRootRegionLocation() != null) {
                op = (RegionServerOperation)this.delayedToDoQueue.poll();
            }
            if (op == null) {
                try {
                    op = this.toDoQueue.poll(this.threadWakeFrequency, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (op == null || this.closed.get()) {
                return true;
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Processing todo: " + op.toString()));
                }
                if (op.process()) break block16;
                if (this.toDoQueue.size() == 0) {
                    this.sleeper.sleep();
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Put " + op.toString() + " back on queue"));
                    }
                    this.toDoQueue.put(op);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Putting into toDoQueue was interrupted.", e);
                }
            }
            catch (Exception ex2) {
                IOException ex2;
                if (ex2 instanceof RemoteException) {
                    try {
                        ex2 = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)ex2));
                    }
                    catch (IOException e) {
                        ex2 = e;
                        LOG.warn((Object)("main processing loop: " + op.toString()), (Throwable)e);
                    }
                }
                if (!this.checkFileSystem()) {
                    return false;
                }
                LOG.warn((Object)("Processing pending operations: " + op.toString()), (Throwable)ex2);
                this.delayedToDoQueue.put(op);
            }
        }
        return true;
    }

    private void verifyClusterState() {
        try {
            LOG.debug((Object)"Checking cluster state...");
            HServerAddress rootLocation = this.zooKeeperWrapper.readRootRegionLocation();
            List<HServerAddress> addresses = this.zooKeeperWrapper.scanRSDirectory();
            if (addresses.size() == 0) {
                LOG.debug((Object)"This is a fresh start, proceeding with normal startup");
                this.splitLogAfterStartup();
                return;
            }
            LOG.info((Object)"This is a failover, ZK inspection begins...");
            boolean isRootRegionAssigned = false;
            HashMap<byte[], HRegionInfo> assignedRegions = new HashMap<byte[], HRegionInfo>();
            for (HServerAddress address : addresses) {
                HRegionInfo[] regions;
                HRegionInterface hri = this.connection.getHRegionConnection(address, false);
                HServerInfo info = hri.getHServerInfo();
                LOG.debug((Object)("Inspection found server " + info.getName()));
                this.serverManager.recordNewServer(info, true);
                for (HRegionInfo region : regions = hri.getRegionsAssignment()) {
                    if (region.isRootRegion()) {
                        this.connection.setRootRegionLocation(new HRegionLocation(region, rootLocation));
                        this.regionManager.setRootRegionLocation(rootLocation);
                        this.regionManager.removeRegion(region);
                        isRootRegionAssigned = true;
                    } else if (region.isMetaRegion()) {
                        MetaRegion m = new MetaRegion(new HServerAddress(address), region);
                        this.regionManager.addMetaRegionToScan(m);
                    }
                    assignedRegions.put(region.getRegionName(), region);
                }
            }
            LOG.info((Object)("Inspection found " + assignedRegions.size() + " regions, " + (isRootRegionAssigned ? "with -ROOT-" : "but -ROOT- was MIA")));
            this.splitLogAfterStartup();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitLogAfterStartup() throws IOException {
        Path logsDirPath = new Path(this.rootdir, ".logs");
        FileStatus[] logFolders = this.fs.listStatus(logsDirPath);
        if (logFolders == null || logFolders.length == 0) {
            LOG.debug((Object)"No log files to split, proceeding...");
            return;
        }
        for (FileStatus status : logFolders) {
            String serverName = status.getPath().getName();
            LOG.info((Object)("Found log folder : " + serverName));
            if (this.serverManager.getServerInfo(serverName) == null) {
                LOG.info((Object)"Log folder doesn't belong to a known region server, splitting");
                this.regionManager.splitLogLock.lock();
                Path logDir = new Path(this.rootdir, HLog.getHLogDirectoryName(serverName));
                try {
                    HLog.splitLog(this.rootdir, logDir, this.fs, this.getConfiguration());
                    continue;
                }
                finally {
                    this.regionManager.splitLogLock.unlock();
                }
            }
            LOG.info((Object)"Log folder belongs to an existing region server");
        }
    }

    private void startServiceThreads() {
        this.metrics = new MasterMetrics();
        try {
            this.regionManager.start();
            int port = this.conf.getInt("hbase.master.info.port", 60010);
            if (port >= 0) {
                String a = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
                this.infoServer = new InfoServer(MASTER, a, port, false);
                this.infoServer.setAttribute(MASTER, this);
                this.infoServer.start();
            }
            this.server.start();
        }
        catch (IOException e) {
            if (e instanceof RemoteException) {
                try {
                    e = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                }
                catch (IOException ex) {
                    LOG.warn((Object)"thread start", (Throwable)ex);
                }
            }
            this.closed.set(true);
            LOG.error((Object)"Failed startup", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Started service threads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startShutdown() {
        this.closed.set(true);
        this.regionManager.stopScanners();
        BlockingQueue<RegionServerOperation> blockingQueue = this.toDoQueue;
        synchronized (blockingQueue) {
            this.toDoQueue.clear();
            this.delayedToDoQueue.clear();
            this.toDoQueue.notifyAll();
        }
        this.serverManager.notifyServers();
    }

    @Override
    public MapWritable regionServerStartup(HServerInfo serverInfo) throws IOException {
        if (serverInfo.getServerAddress().getBindAddress().equals("0.0.0.0")) {
            String rsAddress = HBaseServer.getRemoteAddress();
            serverInfo.setServerAddress(new HServerAddress(rsAddress, serverInfo.getServerAddress().getPort()));
        }
        this.serverManager.regionServerStartup(serverInfo);
        return this.createConfigurationSubset();
    }

    protected MapWritable createConfigurationSubset() {
        MapWritable mw = this.addConfig(new MapWritable(), "hbase.rootdir");
        String rsAddress = HBaseServer.getRemoteAddress();
        if (rsAddress != null) {
            mw.put((Writable)new Text("hbase.regionserver.address"), (Writable)new Text(rsAddress));
        }
        return this.addConfig(mw, "fs.default.name");
    }

    private MapWritable addConfig(MapWritable mw, String key) {
        mw.put((Writable)new Text(key), (Writable)new Text(this.conf.get(key)));
        return mw;
    }

    @Override
    public HMsg[] regionServerReport(HServerInfo serverInfo, HMsg[] msgs, HRegionInfo[] mostLoadedRegions) throws IOException {
        return this.serverManager.regionServerReport(serverInfo, msgs, mostLoadedRegions);
    }

    @Override
    public boolean isMasterRunning() {
        return !this.closed.get();
    }

    @Override
    public void shutdown() {
        LOG.info((Object)"Cluster shutdown requested. Starting to quiesce servers");
        this.shutdownRequested.set(true);
        this.zooKeeperWrapper.setClusterState(false);
    }

    @Override
    public void createTable(HTableDescriptor desc) throws IOException {
        if (!this.isMasterRunning()) {
            throw new MasterNotRunningException();
        }
        HRegionInfo newRegion = new HRegionInfo(desc, null, null);
        for (int tries = 0; tries < this.numRetries; ++tries) {
            try {
                if (!this.regionManager.areAllMetaRegionsOnline()) {
                    throw new NotAllMetaRegionsOnlineException();
                }
                if (!this.serverManager.canAssignUserRegions()) {
                    throw new IOException("not enough servers to create table yet");
                }
                this.createTable(newRegion);
                LOG.info((Object)("created table " + desc.getNameAsString()));
                break;
            }
            catch (TableExistsException e) {
                throw e;
            }
            catch (IOException e) {
                if (tries == this.numRetries - 1) {
                    throw RemoteExceptionHandler.checkIOException(e);
                }
                this.sleeper.sleep();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createTable(HRegionInfo newRegion) throws IOException {
        String tableName = newRegion.getTableDesc().getNameAsString();
        MetaRegion m = this.regionManager.getFirstMetaRegionForRegion(newRegion);
        byte[] metaRegionName = m.getRegionName();
        HRegionInterface srvr = this.connection.getHRegionConnection(m.getServer());
        byte[] firstRowInTable = Bytes.toBytes(tableName + ",,");
        Scan scan = new Scan(firstRowInTable);
        scan.addColumn(CATALOG_FAMILY, REGIONINFO_QUALIFIER);
        long scannerid = srvr.openScanner(metaRegionName, scan);
        try {
            HRegionInfo info;
            Result data = srvr.next(scannerid);
            if (data != null && data.size() > 0 && (info = Writables.getHRegionInfo(data.getValue(CATALOG_FAMILY, REGIONINFO_QUALIFIER))).getTableDesc().getNameAsString().equals(tableName)) {
                throw new TableExistsException(tableName);
            }
        }
        finally {
            srvr.close(scannerid);
        }
        this.regionManager.createRegion(newRegion, srvr, metaRegionName);
    }

    @Override
    public void deleteTable(byte[] tableName) throws IOException {
        if (Bytes.equals(tableName, ROOT_TABLE_NAME)) {
            throw new IOException("Can't delete root table");
        }
        new TableDelete(this, tableName).process();
        LOG.info((Object)("deleted table: " + Bytes.toString(tableName)));
    }

    @Override
    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        new AddColumn(this, tableName, column).process();
    }

    @Override
    public void modifyColumn(byte[] tableName, byte[] columnName, HColumnDescriptor descriptor) throws IOException {
        new ModifyColumn(this, tableName, columnName, descriptor).process();
    }

    @Override
    public void deleteColumn(byte[] tableName, byte[] c) throws IOException {
        new DeleteColumn(this, tableName, KeyValue.parseColumn(c)[0]).process();
    }

    @Override
    public void enableTable(byte[] tableName) throws IOException {
        if (Bytes.equals(tableName, ROOT_TABLE_NAME)) {
            throw new IOException("Can't enable root table");
        }
        new ChangeTableState(this, tableName, true).process();
    }

    @Override
    public void disableTable(byte[] tableName) throws IOException {
        if (Bytes.equals(tableName, ROOT_TABLE_NAME)) {
            throw new IOException("Can't disable root table");
        }
        new ChangeTableState(this, tableName, false).process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<HRegionInfo, HServerAddress>> getTableRegions(byte[] tableName) throws IOException {
        ArrayList<Pair<HRegionInfo, HServerAddress>> result = new ArrayList<Pair<HRegionInfo, HServerAddress>>();
        Set<MetaRegion> regions = this.regionManager.getMetaRegionsForTable(tableName);
        byte[] firstRowInTable = Bytes.toBytes(Bytes.toString(tableName) + ",,");
        for (MetaRegion m : regions) {
            byte[] metaRegionName = m.getRegionName();
            HRegionInterface srvr = this.connection.getHRegionConnection(m.getServer());
            Scan scan = new Scan(firstRowInTable);
            scan.addColumn(CATALOG_FAMILY, REGIONINFO_QUALIFIER);
            scan.addColumn(CATALOG_FAMILY, SERVER_QUALIFIER);
            long scannerid = srvr.openScanner(metaRegionName, scan);
            try {
                HRegionInfo info;
                Result data;
                while ((data = srvr.next(scannerid)) != null && data.size() > 0 && Bytes.compareTo((info = Writables.getHRegionInfo(data.getValue(CATALOG_FAMILY, REGIONINFO_QUALIFIER))).getTableDesc().getName(), tableName) == 0) {
                    byte[] value = data.getValue(CATALOG_FAMILY, SERVER_QUALIFIER);
                    if (value == null) continue;
                    HServerAddress server = new HServerAddress(Bytes.toString(value));
                    result.add(new Pair<HRegionInfo, HServerAddress>(info, server));
                }
            }
            finally {
                srvr.close(scannerid);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<HRegionInfo, HServerAddress> getTableRegionClosest(byte[] tableName, byte[] rowKey) throws IOException {
        Set<MetaRegion> regions = this.regionManager.getMetaRegionsForTable(tableName);
        for (MetaRegion m : regions) {
            byte[] firstRowInTable = Bytes.toBytes(Bytes.toString(tableName) + ",,");
            byte[] metaRegionName = m.getRegionName();
            HRegionInterface srvr = this.connection.getHRegionConnection(m.getServer());
            Scan scan = new Scan(firstRowInTable);
            scan.addColumn(CATALOG_FAMILY, REGIONINFO_QUALIFIER);
            scan.addColumn(CATALOG_FAMILY, SERVER_QUALIFIER);
            long scannerid = srvr.openScanner(metaRegionName, scan);
            try {
                HRegionInfo info;
                Result data;
                while ((data = srvr.next(scannerid)) != null && data.size() > 0 && Bytes.compareTo((info = Writables.getHRegionInfo(data.getValue(CATALOG_FAMILY, REGIONINFO_QUALIFIER))).getTableDesc().getName(), tableName) == 0) {
                    byte[] value;
                    if (Bytes.compareTo(info.getStartKey(), rowKey) < 0 || Bytes.compareTo(info.getEndKey(), rowKey) >= 0 || (value = data.getValue(CATALOG_FAMILY, SERVER_QUALIFIER)) == null) continue;
                    HServerAddress server = new HServerAddress(Bytes.toString(value));
                    Pair<HRegionInfo, HServerAddress> pair = new Pair<HRegionInfo, HServerAddress>(info, server);
                    return pair;
                }
            }
            finally {
                srvr.close(scannerid);
            }
        }
        return null;
    }

    private Pair<HRegionInfo, HServerAddress> getTableRegionFromName(byte[] regionName) throws IOException {
        byte[] tableName = HRegionInfo.parseRegionName(regionName)[0];
        Set<MetaRegion> regions = this.regionManager.getMetaRegionsForTable(tableName);
        for (MetaRegion m : regions) {
            byte[] metaRegionName = m.getRegionName();
            HRegionInterface srvr = this.connection.getHRegionConnection(m.getServer());
            Get get2 = new Get(regionName);
            get2.addColumn(CATALOG_FAMILY, REGIONINFO_QUALIFIER);
            get2.addColumn(CATALOG_FAMILY, SERVER_QUALIFIER);
            Result data = srvr.get(metaRegionName, get2);
            if (data == null || data.size() <= 0) continue;
            HRegionInfo info = Writables.getHRegionInfo(data.getValue(CATALOG_FAMILY, REGIONINFO_QUALIFIER));
            byte[] value = data.getValue(CATALOG_FAMILY, SERVER_QUALIFIER);
            if (value == null) continue;
            HServerAddress server = new HServerAddress(Bytes.toString(value));
            return new Pair<HRegionInfo, HServerAddress>(info, server);
        }
        return null;
    }

    protected Result getFromMETA(byte[] row, byte[] family) throws IOException {
        MetaRegion meta = this.regionManager.getMetaRegionForRow(row);
        HRegionInterface srvr = this.getMETAServer(meta);
        Get get2 = new Get(row);
        get2.addFamily(family);
        return srvr.get(meta.getRegionName(), get2);
    }

    private HRegionInterface getMETAServer(MetaRegion meta) throws IOException {
        return this.connection.getHRegionConnection(meta.getServer());
    }

    @Override
    public void modifyTable(byte[] tableName, HConstants.Modify op, Writable[] args) throws IOException {
        switch (op) {
            case TABLE_SET_HTD: {
                if (args == null || args.length < 1 || !(args[0] instanceof HTableDescriptor)) {
                    throw new IOException("SET_HTD request requires an HTableDescriptor");
                }
                HTableDescriptor htd = (HTableDescriptor)args[0];
                LOG.info((Object)("modifyTable(SET_HTD): " + htd));
                new ModifyTableMeta(this, tableName, htd).process();
                break;
            }
            case TABLE_SPLIT: 
            case TABLE_COMPACT: 
            case TABLE_MAJOR_COMPACT: 
            case TABLE_FLUSH: {
                if (args != null && args.length > 0) {
                    if (!(args[0] instanceof ImmutableBytesWritable)) {
                        throw new IOException("request argument must be ImmutableBytesWritable");
                    }
                    Pair<HRegionInfo, HServerAddress> pair = null;
                    if (tableName == null) {
                        byte[] regionName = ((ImmutableBytesWritable)args[0]).get();
                        pair = this.getTableRegionFromName(regionName);
                    } else {
                        byte[] rowKey = ((ImmutableBytesWritable)args[0]).get();
                        pair = this.getTableRegionClosest(tableName, rowKey);
                    }
                    if (pair == null) break;
                    this.regionManager.startAction(pair.getFirst().getRegionName(), pair.getFirst(), pair.getSecond(), op);
                    break;
                }
                for (Pair<HRegionInfo, HServerAddress> pair : this.getTableRegions(tableName)) {
                    this.regionManager.startAction(pair.getFirst().getRegionName(), pair.getFirst(), pair.getSecond(), op);
                }
                break;
            }
            case CLOSE_REGION: {
                if (args == null || args.length < 1 || args.length > 2) {
                    throw new IOException("Requires at least a region name; or cannot have more than region name and servername");
                }
                byte[] regionname = ((ImmutableBytesWritable)args[0]).get();
                LOG.debug((Object)("Attempting to close region: " + Bytes.toStringBinary(regionname)));
                String servername = null;
                if (args.length == 2) {
                    servername = Bytes.toString(((ImmutableBytesWritable)args[1]).get());
                }
                Result rr = this.getFromMETA(regionname, HConstants.CATALOG_FAMILY);
                HRegionInfo hri = this.getHRegionInfo(rr.getRow(), rr);
                if (servername == null) {
                    servername = Bytes.toString(rr.getValue(CATALOG_FAMILY, SERVER_QUALIFIER));
                }
                this.regionManager.clearFromInTransition(regionname);
                if (servername == null) break;
                HServerAddress addr = new HServerAddress(servername);
                long startCode = Bytes.toLong(rr.getValue(CATALOG_FAMILY, STARTCODE_QUALIFIER));
                String name = HServerInfo.getServerName(addr, startCode);
                LOG.info((Object)("Marking " + hri.getRegionNameAsString() + " as closing on " + name + "; cleaning SERVER + STARTCODE; " + "master will tell regionserver to close region on next heartbeat"));
                this.regionManager.setClosing(name, hri, hri.isOffline());
                MetaRegion meta = this.regionManager.getMetaRegionForRow(regionname);
                HRegionInterface srvr = this.getMETAServer(meta);
                HRegion.cleanRegionInMETA(srvr, meta.getRegionName(), hri);
                break;
            }
            default: {
                throw new IOException("unsupported modifyTable op " + (Object)((Object)op));
            }
        }
    }

    @Override
    public ClusterStatus getClusterStatus() {
        ClusterStatus status = new ClusterStatus();
        status.setHBaseVersion(VersionInfo.getVersion());
        status.setServerInfo(this.serverManager.serversToServerInfo.values());
        status.setDeadServers(this.serverManager.deadServers);
        status.setRegionsInTransition(this.regionManager.getRegionsInTransition());
        return status;
    }

    public MasterMetrics getMetrics() {
        return this.metrics;
    }

    public HBaseConfiguration getConfiguration() {
        return this.conf;
    }

    HRegionInfo getHRegionInfo(byte[] row, Result res) throws IOException {
        byte[] regioninfo = res.getValue(CATALOG_FAMILY, REGIONINFO_QUALIFIER);
        if (regioninfo == null) {
            StringBuilder sb = new StringBuilder();
            NavigableMap<byte[], byte[]> infoMap = res.getFamilyMap(CATALOG_FAMILY);
            for (byte[] e : infoMap.keySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(Bytes.toString(CATALOG_FAMILY) + ":" + Bytes.toString(e));
            }
            LOG.warn((Object)(Bytes.toString(CATALOG_FAMILY) + ":" + Bytes.toString(REGIONINFO_QUALIFIER) + " is empty for row: " + Bytes.toString(row) + "; has keys: " + sb.toString()));
            return null;
        }
        return Writables.getHRegionInfo(regioninfo);
    }

    protected void deleteEmptyMetaRows(HRegionInterface s, byte[] metaRegionName, List<byte[]> emptyRows) {
        for (byte[] regionName : emptyRows) {
            try {
                HRegion.removeRegionFromMETA(s, metaRegionName, regionName);
                LOG.warn((Object)("Removed region: " + Bytes.toString(regionName) + " from meta region: " + Bytes.toString(metaRegionName) + " because HRegionInfo was empty"));
            }
            catch (IOException e) {
                LOG.error((Object)("deleting region: " + Bytes.toString(regionName) + " from meta region: " + Bytes.toString(metaRegionName)), (Throwable)e);
            }
        }
    }

    public ZooKeeperWrapper getZooKeeperWrapper() {
        return this.zooKeeperWrapper;
    }

    public void process(WatchedEvent event) {
        LOG.debug((Object)("Got event " + event.getType() + " with path " + event.getPath()));
        if (event.getState() == Watcher.Event.KeeperState.Expired || event.getType().equals((Object)Watcher.Event.EventType.NodeDeleted) && event.getPath().equals(this.zooKeeperWrapper.getMasterElectionZNode()) && !this.shutdownRequested.get()) {
            LOG.info((Object)"Master lost its znode, trying to get a new one");
            this.zooKeeperWrapper.close();
            try {
                this.zooKeeperWrapper = new ZooKeeperWrapper(this.conf, this);
                if (!this.writeAddressToZooKeeper(false)) {
                    throw new Exception("Another Master is currently active");
                }
                this.verifyClusterState();
            }
            catch (Exception e) {
                LOG.error((Object)"Killing master because of", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public Map<String, Integer> getTableFragmentation() throws IOException {
        long now = System.currentTimeMillis();
        int check = this.conf.getInt("hbase.master.fragmentation.check.frequency", 120000);
        if (this.lastFragmentationQuery == -1L || now - this.lastFragmentationQuery > (long)check) {
            this.fragmentation = FSUtils.getTableFragmentation(this);
            this.lastFragmentationQuery = now;
        }
        return this.fragmentation;
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: Master [opts] start|stop");
        System.err.println(" start  Start Master. If local mode, start Master and RegionServer in same JVM");
        System.err.println(" stop   Start cluster shutdown; Master signals RegionServer shutdown");
        System.err.println(" where [opts] are:");
        System.err.println("   --minServers=<servers>    Minimum RegionServers needed to host user tables.");
        System.exit(0);
    }

    protected static void doMain(String[] args, Class<? extends HMaster> masterClass) {
        if (args.length < 1) {
            HMaster.printUsageAndExit();
        }
        HBaseConfiguration conf = new HBaseConfiguration();
        for (String cmd : args) {
            if (cmd.startsWith("--minServers=")) {
                conf.setInt("hbase.regions.server.count.min", Integer.valueOf(cmd.substring(13)));
                continue;
            }
            if (cmd.equals("start")) {
                try {
                    RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                    if (runtime != null) {
                        LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
                        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
                    }
                    if (LocalHBaseCluster.isLocal(conf)) {
                        new LocalHBaseCluster(conf).startup();
                        break;
                    }
                    Constructor<? extends HMaster> c = masterClass.getConstructor(HBaseConfiguration.class);
                    HMaster master = c.newInstance(new Object[]{conf});
                    if (master.shutdownRequested.get()) {
                        LOG.info((Object)"Won't bring the Master up as a shutdown is requested");
                        return;
                    }
                    master.start();
                }
                catch (Throwable t) {
                    LOG.error((Object)"Can not start master", t);
                    System.exit(-1);
                }
                break;
            }
            if (cmd.equals("stop")) {
                HBaseAdmin adm = null;
                try {
                    adm = new HBaseAdmin(conf);
                }
                catch (MasterNotRunningException e) {
                    LOG.error((Object)"master is not running");
                    System.exit(0);
                }
                try {
                    adm.shutdown();
                }
                catch (Throwable t) {
                    LOG.error((Object)"Can not stop master", t);
                    System.exit(-1);
                }
                break;
            }
            HMaster.printUsageAndExit();
        }
    }

    public static void main(String[] args) {
        HMaster.doMain(args, HMaster.class);
    }
}

