/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.master.BaseScanner;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.RegionManager;

class MetaScanner
extends BaseScanner {
    private volatile BlockingQueue<MetaRegion> metaRegionsToScan = new LinkedBlockingQueue<MetaRegion>();
    private final List<MetaRegion> metaRegionsToRescan = new ArrayList<MetaRegion>();

    public MetaScanner(HMaster master) {
        super(master, false, master.metaRescanInterval, master.shutdownRequested);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanOneMetaRegion(MetaRegion region) {
        while (!this.master.closed.get() && !this.master.regionManager.isInitialRootScanComplete() && this.master.regionManager.getRootRegionLocation() == null) {
            this.sleep();
        }
        if (this.master.closed.get()) {
            return false;
        }
        try {
            Object object = this.scannerLock;
            synchronized (object) {
                this.scanRegion(region);
                this.master.regionManager.putMetaRegionOnline(region);
            }
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException(e);
            LOG.warn((Object)("Scan one META region: " + region.toString()), (Throwable)e);
            if (!this.master.regionManager.isMetaRegionOnline(region.getStartKey())) {
                LOG.debug((Object)"Scanned region is no longer in map of online regions or its value has changed");
                return false;
            }
            this.master.checkFileSystem();
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected exception", (Throwable)e);
        }
        return true;
    }

    @Override
    protected boolean initialScan() {
        MetaRegion region = null;
        while (!this.master.closed.get() && region == null && this.metaRegionsToScan.size() > 0 && !this.metaRegionsScanned()) {
            try {
                region = this.metaRegionsToScan.poll(this.master.threadWakeFrequency, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (region == null && this.metaRegionsToRescan.size() != 0) {
                region = this.metaRegionsToRescan.remove(0);
            }
            if (region == null || this.scanOneMetaRegion(region)) continue;
            this.metaRegionsToRescan.add(region);
        }
        this.initialScanComplete = true;
        return true;
    }

    @Override
    protected void maintenanceScan() {
        List<MetaRegion> regions = this.master.regionManager.getListOfOnlineMetaRegions();
        int regionCount = 0;
        for (MetaRegion r : regions) {
            this.scanOneMetaRegion(r);
            ++regionCount;
        }
        LOG.info((Object)("All " + regionCount + " .META. region(s) scanned"));
        this.metaRegionsScanned();
    }

    private synchronized boolean metaRegionsScanned() {
        if (!this.master.regionManager.isInitialRootScanComplete() || this.master.regionManager.numMetaRegions() != this.master.regionManager.numOnlineMetaRegions()) {
            return false;
        }
        this.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean waitForMetaRegionsOrClose() {
        while (!this.master.closed.get()) {
            RegionManager regionManager = this.master.regionManager;
            synchronized (regionManager) {
                if (this.master.regionManager.isInitialRootScanComplete() && this.master.regionManager.numMetaRegions() == this.master.regionManager.numOnlineMetaRegions()) {
                    break;
                }
            }
            try {
                this.wait(this.master.threadWakeFrequency);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.master.closed.get();
    }

    void addMetaRegionToScan(MetaRegion m) {
        this.metaRegionsToScan.add(m);
    }
}

