/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.InvalidColumnNameException;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.ipc.RemoteException;

abstract class RetryableMetaOperation<T>
implements Callable<T> {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected final Sleeper sleeper;
    protected final MetaRegion m;
    protected final HMaster master;
    protected HRegionInterface server;

    protected RetryableMetaOperation(MetaRegion m, HMaster master) {
        this.m = m;
        this.master = master;
        this.sleeper = new Sleeper(master.threadWakeFrequency, master.closed);
    }

    protected T doWithRetries() throws IOException, RuntimeException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (int tries = 0; tries < this.master.numRetries; ++tries) {
            if (this.master.closed.get()) {
                return null;
            }
            try {
                this.server = this.master.connection.getHRegionConnection(this.m.getServer());
                return (T)this.call();
            }
            catch (IOException e) {
                if (e instanceof TableNotFoundException || e instanceof TableNotDisabledException || e instanceof InvalidColumnNameException) {
                    throw e;
                }
                if (e instanceof RemoteException) {
                    e = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                }
                if (tries == this.master.numRetries - 1) {
                    if (this.LOG.isDebugEnabled()) {
                        StringBuilder message = new StringBuilder("Trying to contact region server for regionName '" + Bytes.toString(this.m.getRegionName()) + "', but failed after " + (tries + 1) + " attempts.\n");
                        int i = 1;
                        for (IOException e2 : exceptions) {
                            message.append("Exception " + i + ":\n" + e2);
                        }
                        this.LOG.debug((Object)message);
                    }
                    this.master.checkFileSystem();
                    throw e;
                }
                if (this.LOG.isDebugEnabled()) {
                    exceptions.add(e);
                }
            }
            catch (Exception e) {
                this.LOG.debug((Object)"Exception in RetryableMetaOperation: ", (Throwable)e);
                throw new RuntimeException(e);
            }
            this.sleeper.sleep();
        }
        return null;
    }
}

