/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.TableOperation;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;

class TableDelete
extends TableOperation {
    private final Log LOG = LogFactory.getLog(this.getClass());

    TableDelete(HMaster master, byte[] tableName) throws IOException {
        super(master, tableName);
    }

    @Override
    protected void processScanItem(String serverName, HRegionInfo info) throws IOException {
        if (this.isEnabled(info)) {
            this.LOG.debug((Object)("Region still enabled: " + info.toString()));
            throw new TableNotDisabledException(this.tableName);
        }
    }

    @Override
    protected void postProcessMeta(MetaRegion m, HRegionInterface server) throws IOException {
        for (HRegionInfo i : this.unservedRegions) {
            if (!Bytes.equals(this.tableName, i.getTableDesc().getName())) continue;
            try {
                HRegion.removeRegionFromMETA(server, m.getRegionName(), i.getRegionName());
                HRegion.deleteRegion(this.master.fs, this.master.rootdir, i);
            }
            catch (IOException e) {
                this.LOG.error((Object)("failed to delete region " + Bytes.toString(i.getRegionName())), (Throwable)RemoteExceptionHandler.checkIOException(e));
            }
        }
        this.master.fs.delete(new Path(this.master.rootdir, Bytes.toString(this.tableName)), true);
    }
}

