/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import java.util.HashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.metrics.MetricsMBeanBase;
import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class TestMetricsMBeanBase
extends TestCase {
    private MetricsRegistry registry;
    private MetricsRecord metricsRecord;
    private TestStatistics stats;
    private MetricsRate metricsRate;
    private MetricsIntValue intValue;
    private MetricsTimeVaryingRate varyRate;

    public void setUp() {
        this.registry = new MetricsRegistry();
        this.metricsRate = new MetricsRate("metricsRate", this.registry, "test");
        this.intValue = new MetricsIntValue("intValue", this.registry, "test");
        this.varyRate = new MetricsTimeVaryingRate("varyRate", this.registry, "test");
        this.stats = new TestStatistics(this.registry);
        MetricsContext context = MetricsUtil.getContext((String)"hbase");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"test");
        this.metricsRecord.setTag("TestStatistics", "test");
    }

    public void tearDown() {
    }

    public void testGetAttribute() throws Exception {
        this.metricsRate.inc(2);
        this.metricsRate.pushMetric(this.metricsRecord);
        this.intValue.set(5);
        this.intValue.pushMetric(this.metricsRecord);
        this.varyRate.inc(10L);
        this.varyRate.inc(50L);
        this.varyRate.pushMetric(this.metricsRecord);
        TestMetricsMBeanBase.assertEquals((double)2.0, (double)((Float)this.stats.getAttribute("metricsRate")).floatValue(), (double)0.001);
        TestMetricsMBeanBase.assertEquals((Object)5, (Object)this.stats.getAttribute("intValue"));
        TestMetricsMBeanBase.assertEquals((Object)10L, (Object)this.stats.getAttribute("varyRateMinTime"));
        TestMetricsMBeanBase.assertEquals((Object)50L, (Object)this.stats.getAttribute("varyRateMaxTime"));
        TestMetricsMBeanBase.assertEquals((Object)30L, (Object)this.stats.getAttribute("varyRateAvgTime"));
        TestMetricsMBeanBase.assertEquals((Object)2, (Object)this.stats.getAttribute("varyRateNumOps"));
    }

    public void testGetMBeanInfo() {
        MBeanInfo info = this.stats.getMBeanInfo();
        MBeanAttributeInfo[] attributes = info.getAttributes();
        TestMetricsMBeanBase.assertEquals((int)6, (int)attributes.length);
        HashMap<String, MBeanAttributeInfo> attributeByName = new HashMap<String, MBeanAttributeInfo>(attributes.length);
        for (MBeanAttributeInfo attr : attributes) {
            attributeByName.put(attr.getName(), attr);
        }
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("metricsRate"), "metricsRate", "java.lang.Float", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("intValue"), "intValue", "java.lang.Integer", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("varyRateMinTime"), "varyRateMinTime", "java.lang.Long", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("varyRateMaxTime"), "varyRateMaxTime", "java.lang.Long", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("varyRateAvgTime"), "varyRateAvgTime", "java.lang.Long", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("varyRateNumOps"), "varyRateNumOps", "java.lang.Integer", "test");
    }

    protected void assertAttribute(MBeanAttributeInfo attr, String name, String type, String description) {
        TestMetricsMBeanBase.assertEquals((String)attr.getName(), (String)name);
        TestMetricsMBeanBase.assertEquals((String)attr.getType(), (String)type);
        TestMetricsMBeanBase.assertEquals((String)attr.getDescription(), (String)description);
    }

    private class TestStatistics
    extends MetricsMBeanBase {
        public TestStatistics(MetricsRegistry registry) {
            super(registry, "TestStatistics");
        }
    }
}

