/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration.nineteen.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.migration.nineteen.HStoreKey;
import org.apache.hadoop.hbase.migration.nineteen.io.HBaseMapFile;
import org.apache.hadoop.hbase.migration.nineteen.onelab.filter.BloomFilter;
import org.apache.hadoop.hbase.migration.nineteen.onelab.filter.Key;
import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class BloomFilterMapFile
extends HBaseMapFile {
    static final Log LOG = LogFactory.getLog(BloomFilterMapFile.class);
    protected static final String BLOOMFILTER_FILE_NAME = "filter";

    protected static Key getBloomFilterKey(WritableComparable key) {
        return new Key(((HStoreKey)key).getRow());
    }

    public static class Writer
    extends HBaseMapFile.HBaseWriter {
        private static final double DEFAULT_NUMBER_OF_HASH_FUNCTIONS = 4.0;
        private final BloomFilter bloomFilter;
        private final String dirName;
        private final FileSystem fs;

        public Writer(Configuration conf, FileSystem fs, String dirName, SequenceFile.CompressionType compression, boolean filter, int nrows, HRegionInfo hri) throws IOException {
            super(conf, fs, dirName, compression, hri);
            this.dirName = dirName;
            this.fs = fs;
            if (filter) {
                BloomFilter f = null;
                try {
                    f = new BloomFilter((int)Math.ceil(4.0 * (1.0 * (double)nrows) / Math.log(2.0)), 4, Hash.getHashType(conf));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)"Failed creating bloomfilter; proceeding without", (Throwable)e);
                }
                this.bloomFilter = f;
            } else {
                this.bloomFilter = null;
            }
        }

        public void append(WritableComparable key, Writable val) throws IOException {
            if (this.bloomFilter != null) {
                this.bloomFilter.add(BloomFilterMapFile.getBloomFilterKey(key));
            }
            super.append(key, val);
        }

        public synchronized void close() throws IOException {
            super.close();
            if (this.bloomFilter != null) {
                this.flushBloomFilter();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushBloomFilter() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("flushing bloom filter for " + this.dirName));
            }
            FSDataOutputStream out = this.fs.create(new Path(this.dirName, BloomFilterMapFile.BLOOMFILTER_FILE_NAME));
            try {
                this.bloomFilter.write((DataOutput)out);
            }
            finally {
                out.close();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("flushed bloom filter for " + this.dirName));
            }
        }
    }

    public static class Reader
    extends HBaseMapFile.HBaseReader {
        private final BloomFilter bloomFilter;

        public Reader(FileSystem fs, String dirName, Configuration conf, boolean filter, boolean blockCacheEnabled, HRegionInfo hri) throws IOException {
            super(fs, dirName, conf, blockCacheEnabled, hri);
            this.bloomFilter = filter ? this.loadBloomFilter(fs, dirName) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BloomFilter loadBloomFilter(FileSystem fs, String dirName) throws IOException {
            Path filterFile = new Path(dirName, BloomFilterMapFile.BLOOMFILTER_FILE_NAME);
            if (!fs.exists(filterFile)) {
                LOG.warn((Object)("FileNotFound: " + filterFile + "; proceeding without"));
                return null;
            }
            BloomFilter filter = new BloomFilter();
            FSDataInputStream in = fs.open(filterFile);
            try {
                filter.readFields((DataInput)in);
            }
            finally {
                in.close();
            }
            return filter;
        }

        public Writable get(WritableComparable key, Writable val) throws IOException {
            if (this.bloomFilter == null) {
                return super.get(key, val);
            }
            if (this.bloomFilter.membershipTest(BloomFilterMapFile.getBloomFilterKey(key))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"bloom filter reported that key exists");
                }
                return super.get(key, val);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"bloom filter reported that key does not exist");
            }
            return null;
        }

        public WritableComparable getClosest(WritableComparable key, Writable val) throws IOException {
            if (this.bloomFilter == null) {
                return super.getClosest(key, val);
            }
            if (this.bloomFilter.membershipTest(BloomFilterMapFile.getBloomFilterKey(key))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"bloom filter reported that key exists");
                }
                return super.getClosest(key, val);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"bloom filter reported that key does not exist");
            }
            return null;
        }

        public int getBloomFilterSize() {
            return this.bloomFilter == null ? 0 : this.bloomFilter.getVectorSize();
        }
    }
}

