/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration.nineteen.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.migration.nineteen.HStoreKey;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;

public class HBaseMapFile
extends MapFile {
    public static final Class<? extends Writable> VALUE_CLASS = ImmutableBytesWritable.class;

    public static class HBaseWriter
    extends MapFile.Writer {
        public HBaseWriter(Configuration conf, FileSystem fs, String dirName, SequenceFile.CompressionType compression, HRegionInfo hri) throws IOException {
            super(conf, fs, dirName, (WritableComparator)new HStoreKey.HStoreKeyWritableComparator(hri), VALUE_CLASS, compression);
            this.setIndexInterval(conf.getInt("hbase.io.index.interval", 128));
        }
    }

    public static class HBaseReader
    extends MapFile.Reader {
        private final boolean blockCacheEnabled;

        public HBaseReader(FileSystem fs, String dirName, Configuration conf, HRegionInfo hri) throws IOException {
            this(fs, dirName, conf, false, hri);
        }

        public HBaseReader(FileSystem fs, String dirName, Configuration conf, boolean blockCacheEnabled, HRegionInfo hri) throws IOException {
            super(fs, dirName, (WritableComparator)new HStoreKey.HStoreKeyWritableComparator(hri), conf, false);
            this.blockCacheEnabled = blockCacheEnabled;
            this.open(fs, dirName, new HStoreKey.HStoreKeyWritableComparator(hri), conf);
        }
    }
}

