/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;

public class DisabledTestRegionServerExit
extends HBaseClusterTestCase {
    final Log LOG = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    HTable table;

    public DisabledTestRegionServerExit() {
        super(2);
        this.conf.setInt("ipc.client.connect.max.retries", 5);
        this.conf.setInt("ipc.client.timeout", 10000);
        this.conf.setInt("hbase.client.pause", 10000);
        this.conf.setInt("hbase.client.retries.number", 10);
    }

    public void testAbort() throws IOException {
        new HTable(this.conf, HConstants.META_TABLE_NAME);
        String tableName = this.getName();
        byte[] row = this.createTableAndAddRow(tableName);
        this.cluster.startRegionServer();
        this.stopOrAbortMetaRegionServer(true);
        this.LOG.info((Object)("Starting up the verification thread for " + this.getName()));
        Thread t = this.startVerificationThread(tableName, row);
        t.start();
        this.threadDumpingJoin(t);
    }

    public void testCleanExit() throws IOException {
        new HTable(this.conf, HConstants.META_TABLE_NAME);
        String tableName = this.getName();
        byte[] row = this.createTableAndAddRow(tableName);
        this.cluster.startRegionServer();
        this.stopOrAbortMetaRegionServer(false);
        this.LOG.info((Object)("Starting up the verification thread for " + this.getName()));
        Thread t = this.startVerificationThread(tableName, row);
        t.start();
        this.threadDumpingJoin(t);
    }

    private byte[] createTableAndAddRow(String tableName) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(desc);
        this.table = new HTable(this.conf, tableName);
        byte[] row = Bytes.toBytes("row1");
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, null, Bytes.toBytes(tableName));
        this.table.put(put);
        return row;
    }

    private void stopOrAbortMetaRegionServer(boolean abort) {
        List<LocalHBaseCluster.RegionServerThread> regionThreads = this.cluster.getRegionThreads();
        int server = -1;
        for (int i = 0; i < regionThreads.size() && server == -1; ++i) {
            HRegionServer s = regionThreads.get(i).getRegionServer();
            Collection<HRegion> regions = s.getOnlineRegions();
            for (HRegion r : regions) {
                if (!Bytes.equals(r.getTableDesc().getName(), HConstants.META_TABLE_NAME)) continue;
                server = i;
            }
        }
        if (server == -1) {
            this.LOG.fatal((Object)"could not find region server serving meta region");
            DisabledTestRegionServerExit.fail();
        }
        if (abort) {
            this.cluster.abortRegionServer(server);
        } else {
            this.cluster.stopRegionServer(server);
        }
        this.LOG.info((Object)(this.cluster.waitOnRegionServer(server) + " has been " + (abort ? "aborted" : "shut down")));
    }

    private Thread startVerificationThread(final String tableName, final byte[] row) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Scan scan;
                try {
                    HTable t = new HTable(DisabledTestRegionServerExit.this.conf, HConstants.META_TABLE_NAME);
                    scan = new Scan();
                    scan.addFamily(HConstants.CATALOG_FAMILY);
                    ResultScanner s = t.getScanner(scan);
                    s.close();
                }
                catch (IOException e) {
                    DisabledTestRegionServerExit.this.LOG.fatal((Object)"could not re-open meta table because", (Throwable)e);
                    Assert.fail();
                }
                ResultScanner scanner = null;
                try {
                    scan = new Scan();
                    scan.addFamily(HConstants.CATALOG_FAMILY);
                    scanner = DisabledTestRegionServerExit.this.table.getScanner(scan);
                    DisabledTestRegionServerExit.this.LOG.info((Object)("Obtained scanner " + scanner));
                    for (Result r : scanner) {
                        Assert.assertTrue((boolean)Bytes.equals(r.getRow(), row));
                        Assert.assertEquals((int)1, (int)r.size());
                        byte[] bytes = r.getRowResult().get(HConstants.CATALOG_FAMILY).getValue();
                        Assert.assertNotNull((Object)bytes);
                        Assert.assertTrue((boolean)tableName.equals(Bytes.toString(bytes)));
                    }
                    DisabledTestRegionServerExit.this.LOG.info((Object)"Success!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
                finally {
                    if (scanner != null) {
                        DisabledTestRegionServerExit.this.LOG.info((Object)("Closing scanner " + scanner));
                        scanner.close();
                    }
                }
            }
        };
        return new Thread(runnable);
    }
}

