/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.regionserver.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.HLogKey;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.LogRollListener;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;

public class HLog
implements HConstants,
Syncable {
    static final Log LOG;
    private static final String HLOG_DATFILE = "hlog.dat.";
    static final byte[] METAFAMILY;
    static final byte[] METAROW;
    private final FileSystem fs;
    private final Path dir;
    private final Configuration conf;
    private final LogRollListener listener;
    private final long optionalFlushInterval;
    private final long blocksize;
    private final int flushlogentries;
    private final AtomicInteger unflushedEntries = new AtomicInteger(0);
    private volatile long lastLogFlushTime;
    private final boolean append;
    private final Method syncfs;
    private static final Object[] NO_ARGS;
    SequenceFile.Writer writer;
    final SortedMap<Long, Path> outputfiles = Collections.synchronizedSortedMap(new TreeMap());
    private final ConcurrentSkipListMap<byte[], Long> lastSeqWritten = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private volatile boolean closed = false;
    private final AtomicLong logSeqNum = new AtomicLong(0L);
    private volatile long filenum = -1L;
    private final AtomicInteger numEntries = new AtomicInteger(0);
    private final AtomicLong editsSize = new AtomicLong(0L);
    private final long logrollsize;
    private final Lock cacheFlushLock = new ReentrantLock();
    private final Object updateLock = new Object();
    private final boolean enabled;
    private final int maxLogs;
    static byte[] COMPLETE_CACHE_FLUSH;
    private static volatile long writeOps;
    private static volatile long writeTime;
    private static volatile long syncOps;
    private static volatile long syncTime;
    public static final long FIXED_OVERHEAD;

    public static long getWriteOps() {
        long ret = writeOps;
        writeOps = 0L;
        return ret;
    }

    public static long getWriteTime() {
        long ret = writeTime;
        writeTime = 0L;
        return ret;
    }

    public static long getSyncOps() {
        long ret = syncOps;
        syncOps = 0L;
        return ret;
    }

    public static long getSyncTime() {
        long ret = syncTime;
        syncTime = 0L;
        return ret;
    }

    public HLog(FileSystem fs, Path dir, HBaseConfiguration conf, LogRollListener listener) throws IOException {
        this.fs = fs;
        this.dir = dir;
        this.conf = conf;
        this.listener = listener;
        this.flushlogentries = conf.getInt("hbase.regionserver.flushlogentries", 100);
        this.blocksize = conf.getLong("hbase.regionserver.hlog.blocksize", this.fs.getDefaultBlockSize());
        float multi = conf.getFloat("hbase.regionserver.logroll.multiplier", 0.95f);
        this.logrollsize = (long)((float)this.blocksize * multi);
        this.optionalFlushInterval = conf.getLong("hbase.regionserver.optionallogflushinterval", 10000L);
        this.lastLogFlushTime = System.currentTimeMillis();
        if (fs.exists(dir)) {
            throw new IOException("Target HLog directory already exists: " + dir);
        }
        fs.mkdirs(dir);
        this.maxLogs = conf.getInt("hbase.regionserver.maxlogs", 32);
        this.enabled = conf.getBoolean("hbase.regionserver.hlog.enabled", true);
        LOG.info((Object)("HLog configuration: blocksize=" + this.blocksize + ", rollsize=" + this.logrollsize + ", enabled=" + this.enabled + ", flushlogentries=" + this.flushlogentries + ", optionallogflushinternal=" + this.optionalFlushInterval + "ms"));
        this.rollWriter();
        this.append = HLog.isAppend(conf);
        Method m = null;
        if (this.append) {
            try {
                m = this.writer.getClass().getMethod("syncFs", new Class[0]);
                LOG.debug((Object)"Using syncFs--hadoop-4379");
            }
            catch (SecurityException e) {
                throw new IOException("Failed test for syncfs", e);
            }
            catch (NoSuchMethodException e) {
                LOG.info((Object)"syncFs--hadoop-4379 not available");
            }
        }
        this.syncfs = m;
    }

    public long getFilenum() {
        return this.filenum;
    }

    static SequenceFile.CompressionType getCompressionType(Configuration c) {
        return SequenceFile.CompressionType.NONE;
    }

    void setSequenceNumber(long newvalue) {
        long id = this.logSeqNum.get();
        while (id < newvalue && !this.logSeqNum.compareAndSet(id, newvalue)) {
            LOG.debug((Object)("Change sequence number from " + this.logSeqNum + " to " + newvalue));
            id = this.logSeqNum.get();
        }
    }

    public long getSequenceNumber() {
        return this.logSeqNum.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] rollWriter() throws FailedLogCloseException, IOException {
        if (this.writer != null && this.numEntries.get() <= 0) {
            return null;
        }
        byte[][] regionsToFlush = null;
        this.cacheFlushLock.lock();
        try {
            if (this.closed) {
                byte[][] byArray = regionsToFlush;
                return byArray;
            }
            Object object = this.updateLock;
            synchronized (object) {
                Path oldFile = this.cleanupCurrentWriter(this.filenum);
                this.filenum = System.currentTimeMillis();
                Path newPath = this.computeFilename(this.filenum);
                this.writer = this.createWriter(newPath);
                LOG.info((Object)((oldFile != null ? "Roll " + FSUtils.getPath(oldFile) + ", entries=" + this.numEntries.get() + ", calcsize=" + this.editsSize.get() + ", filesize=" + this.fs.getFileStatus(oldFile).getLen() + ". " : "") + "New hlog " + FSUtils.getPath(newPath)));
                if (this.outputfiles.size() > 0) {
                    if (this.lastSeqWritten.size() <= 0) {
                        LOG.debug((Object)"Last sequence written is empty. Deleting all old hlogs");
                        for (Map.Entry<Long, Path> e : this.outputfiles.entrySet()) {
                            this.deleteLogFile(e.getValue(), e.getKey());
                        }
                        this.outputfiles.clear();
                    } else {
                        regionsToFlush = this.cleanOldLogs();
                    }
                }
                this.numEntries.set(0);
                this.editsSize.set(0L);
                this.updateLock.notifyAll();
            }
        }
        finally {
            this.cacheFlushLock.unlock();
        }
        return regionsToFlush;
    }

    protected SequenceFile.Writer createWriter(Path path) throws IOException {
        return this.createWriter(path, HLogKey.class, KeyValue.class);
    }

    protected SequenceFile.Writer createWriter(Path path, Class<? extends HLogKey> keyClass, Class<? extends KeyValue> valueClass) throws IOException {
        return SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.conf, (Path)path, keyClass, valueClass, (int)this.fs.getConf().getInt("io.file.buffer.size", 4096), (short)this.fs.getDefaultReplication(), (long)this.blocksize, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, (CompressionCodec)new DefaultCodec(), null, (SequenceFile.Metadata)new SequenceFile.Metadata());
    }

    private byte[][] cleanOldLogs() throws IOException {
        Long oldestOutstandingSeqNum = this.getOldestOutstandingSeqNum();
        TreeSet<Long> sequenceNumbers = new TreeSet<Long>(this.outputfiles.headMap(oldestOutstandingSeqNum + 1L).keySet());
        int logsToRemove = sequenceNumbers.size();
        if (logsToRemove > 0) {
            if (LOG.isDebugEnabled()) {
                byte[] oldestRegion = this.getOldestRegion(oldestOutstandingSeqNum);
                LOG.debug((Object)("Found " + logsToRemove + " hlogs to remove " + " out of total " + this.outputfiles.size() + "; " + "oldest outstanding seqnum is " + oldestOutstandingSeqNum + " from region " + Bytes.toString(oldestRegion)));
            }
            for (Long seq : sequenceNumbers) {
                this.deleteLogFile((Path)this.outputfiles.remove(seq), seq);
            }
        }
        byte[][] regions = null;
        int logCount = this.outputfiles.size() - logsToRemove;
        if (logCount > this.maxLogs && this.outputfiles != null && this.outputfiles.size() > 0) {
            regions = HLog.findMemstoresWithEditsOlderThan(this.outputfiles.firstKey(), this.lastSeqWritten);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < regions.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Bytes.toStringBinary(regions[i]));
            }
            LOG.info((Object)("Too many hlogs: logs=" + logCount + ", maxlogs=" + this.maxLogs + "; forcing flush of " + regions.length + " regions(s): " + sb.toString()));
        }
        return regions;
    }

    static byte[][] findMemstoresWithEditsOlderThan(long oldestWALseqid, Map<byte[], Long> regionsToSeqids) {
        ArrayList<byte[]> regions = null;
        for (Map.Entry<byte[], Long> e : regionsToSeqids.entrySet()) {
            if (e.getValue() >= oldestWALseqid) continue;
            if (regions == null) {
                regions = new ArrayList<byte[]>();
            }
            regions.add(e.getKey());
        }
        return regions == null ? (byte[][])null : (byte[][])regions.toArray((T[])new byte[][]{HConstants.EMPTY_BYTE_ARRAY});
    }

    private Long getOldestOutstandingSeqNum() {
        return Collections.min(this.lastSeqWritten.values());
    }

    private byte[] getOldestRegion(Long oldestOutstandingSeqNum) {
        byte[] oldestRegion = null;
        for (Map.Entry<byte[], Long> e : this.lastSeqWritten.entrySet()) {
            if (e.getValue().longValue() != oldestOutstandingSeqNum.longValue()) continue;
            oldestRegion = e.getKey();
            break;
        }
        return oldestRegion;
    }

    private Path cleanupCurrentWriter(long currentfilenum) throws IOException {
        Path oldFile = null;
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                FailedLogCloseException flce = new FailedLogCloseException("#" + currentfilenum);
                flce.initCause(e);
                throw e;
            }
            if (currentfilenum >= 0L) {
                oldFile = this.computeFilename(currentfilenum);
                this.outputfiles.put(this.logSeqNum.get() - 1L, oldFile);
            }
        }
        return oldFile;
    }

    private void deleteLogFile(Path p, Long seqno) throws IOException {
        LOG.info((Object)("removing old hlog file " + FSUtils.getPath(p) + " whose highest sequence/edit id is " + seqno));
        this.fs.delete(p, true);
    }

    public Path computeFilename(long fn) {
        if (fn < 0L) {
            return null;
        }
        return new Path(this.dir, HLOG_DATFILE + fn);
    }

    public void closeAndDelete() throws IOException {
        this.close();
        this.fs.delete(this.dir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.cacheFlushLock.lock();
        try {
            Object object = this.updateLock;
            synchronized (object) {
                this.closed = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing hlog writer in " + this.dir.toString()));
                }
                this.writer.close();
                this.updateLock.notifyAll();
            }
        }
        finally {
            this.cacheFlushLock.unlock();
        }
    }

    public void append(HRegionInfo regionInfo, KeyValue logEdit, long now) throws IOException {
        byte[] regionName = regionInfo.getRegionName();
        byte[] tableName = regionInfo.getTableDesc().getName();
        this.append(regionInfo, this.makeKey(regionName, tableName, -1L, now), logEdit);
    }

    protected HLogKey makeKey(byte[] regionName, byte[] tableName, long seqnum, long now) {
        return new HLogKey(regionName, tableName, seqnum, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(HRegionInfo regionInfo, HLogKey logKey, KeyValue logEdit) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot append; log is closed");
        }
        byte[] regionName = regionInfo.getRegionName();
        Object object = this.updateLock;
        synchronized (object) {
            long seqNum = this.obtainSeqNum();
            logKey.setLogSeqNum(seqNum);
            this.lastSeqWritten.putIfAbsent(regionName, seqNum);
            boolean sync = regionInfo.isMetaRegion() || regionInfo.isRootRegion();
            this.doWrite(logKey, logEdit, sync, logKey.getWriteTime());
            this.numEntries.incrementAndGet();
            this.updateLock.notifyAll();
        }
        if (this.editsSize.get() > this.logrollsize && this.listener != null) {
            this.listener.logRollRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(byte[] regionName, byte[] tableName, List<KeyValue> edits, boolean sync, long now) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot append; log is closed");
        }
        long[] seqNum = this.obtainSeqNum(edits.size());
        Object object = this.updateLock;
        synchronized (object) {
            this.lastSeqWritten.putIfAbsent(regionName, seqNum[0]);
            int counter = 0;
            for (KeyValue kv : edits) {
                HLogKey logKey = this.makeKey(regionName, tableName, seqNum[counter++], now);
                this.doWrite(logKey, kv, sync, now);
                this.numEntries.incrementAndGet();
            }
            this.updateLock.notifyAll();
        }
        if (this.editsSize.get() > this.logrollsize) {
            this.requestLogRoll();
        }
    }

    public void sync() throws IOException {
        this.lastLogFlushTime = System.currentTimeMillis();
        if (this.append && this.syncfs != null) {
            try {
                this.syncfs.invoke((Object)this.writer, NO_ARGS);
            }
            catch (Exception e) {
                throw new IOException("Reflection", e);
            }
        } else {
            this.writer.sync();
        }
        this.unflushedEntries.set(0);
        syncTime += System.currentTimeMillis() - this.lastLogFlushTime;
        ++syncOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void optionalSync() {
        if (!this.closed) {
            long now = System.currentTimeMillis();
            Object object = this.updateLock;
            synchronized (object) {
                if (now - this.optionalFlushInterval > this.lastLogFlushTime && this.unflushedEntries.get() > 0) {
                    try {
                        this.sync();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error flushing hlog", (Throwable)e);
                    }
                }
            }
            long took = System.currentTimeMillis() - now;
            if (took > 1000L) {
                LOG.warn((Object)(Thread.currentThread().getName() + " took " + took + "ms optional sync'ing hlog; editcount=" + this.numEntries.get()));
            }
        }
    }

    private void requestLogRoll() {
        if (this.listener != null) {
            this.listener.logRollRequested();
        }
    }

    private void doWrite(HLogKey logKey, KeyValue logEdit, boolean sync, long now) throws IOException {
        if (!this.enabled) {
            return;
        }
        try {
            this.editsSize.addAndGet(logKey.heapSize() + logEdit.heapSize());
            this.writer.append((Writable)logKey, (Writable)logEdit);
            long took = System.currentTimeMillis() - now;
            writeTime += took;
            ++writeOps;
            if (took > 1000L) {
                LOG.warn((Object)(Thread.currentThread().getName() + " took " + took + "ms appending an edit to hlog; editcount=" + this.numEntries.get()));
            }
            if (sync || this.unflushedEntries.incrementAndGet() >= this.flushlogentries) {
                this.sync();
            }
        }
        catch (IOException e) {
            LOG.fatal((Object)"Could not append. Requesting close of hlog", (Throwable)e);
            this.requestLogRoll();
            throw e;
        }
    }

    int getNumEntries() {
        return this.numEntries.get();
    }

    private long obtainSeqNum() {
        return this.logSeqNum.incrementAndGet();
    }

    int getNumLogFiles() {
        return this.outputfiles.size();
    }

    private long[] obtainSeqNum(int num) {
        long[] results = new long[num];
        for (int i = 0; i < num; ++i) {
            results[i] = this.logSeqNum.incrementAndGet();
        }
        return results;
    }

    long startCacheFlush() {
        this.cacheFlushLock.lock();
        return this.obtainSeqNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeCacheFlush(byte[] regionName, byte[] tableName, long logSeqId) throws IOException {
        try {
            if (this.closed) {
                return;
            }
            Object object = this.updateLock;
            synchronized (object) {
                long now = System.currentTimeMillis();
                this.writer.append((Writable)this.makeKey(regionName, tableName, logSeqId, System.currentTimeMillis()), (Writable)this.completeCacheFlushLogEdit());
                writeTime += System.currentTimeMillis() - now;
                ++writeOps;
                this.numEntries.incrementAndGet();
                Long seq = this.lastSeqWritten.get(regionName);
                if (seq != null && logSeqId >= seq) {
                    this.lastSeqWritten.remove(regionName);
                }
                this.updateLock.notifyAll();
            }
        }
        finally {
            this.cacheFlushLock.unlock();
        }
    }

    private KeyValue completeCacheFlushLogEdit() {
        return new KeyValue(METAROW, METAFAMILY, null, System.currentTimeMillis(), COMPLETE_CACHE_FLUSH);
    }

    void abortCacheFlush() {
        this.cacheFlushLock.unlock();
    }

    public static boolean isMetaFamily(byte[] family) {
        return Bytes.equals(METAFAMILY, family);
    }

    public static List<Path> splitLog(Path rootDir, Path srcDir, FileSystem fs, HBaseConfiguration conf) throws IOException {
        long millis = System.currentTimeMillis();
        List<Path> splits = null;
        if (!fs.exists(srcDir)) {
            return splits;
        }
        FileStatus[] logfiles = fs.listStatus(srcDir);
        if (logfiles == null || logfiles.length == 0) {
            return splits;
        }
        LOG.info((Object)("Splitting " + logfiles.length + " hlog(s) in " + srcDir.toString()));
        splits = HLog.splitLog(rootDir, logfiles, fs, conf);
        try {
            fs.delete(srcDir, true);
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException(e);
            IOException io = new IOException("Cannot delete: " + srcDir);
            io.initCause(e);
            throw io;
        }
        long endMillis = System.currentTimeMillis();
        LOG.info((Object)("hlog file splitting completed in " + (endMillis - millis) + " millis for " + srcDir.toString()));
        return splits;
    }

    static Class<? extends HLogKey> getKeyClass(HBaseConfiguration conf) {
        return conf.getClass("hbase.regionserver.hlog.keyclass", HLogKey.class);
    }

    static HLogKey newKey(HBaseConfiguration conf) throws IOException {
        Class<? extends HLogKey> keyClass = HLog.getKeyClass(conf);
        try {
            return keyClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("cannot create hlog key");
        }
        catch (IllegalAccessException e) {
            throw new IOException("cannot create hlog key");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Path> splitLog(final Path rootDir, FileStatus[] logfiles, final FileSystem fs, final HBaseConfiguration conf) throws IOException {
        final TreeMap logWriters = new TreeMap(Bytes.BYTES_COMPARATOR);
        ArrayList<Path> splits = null;
        int logWriterThreads = conf.getInt("hbase.regionserver.hlog.splitlog.writer.threads", 3);
        int concurrentLogReads = conf.getInt("hbase.regionserver.hlog.splitlog.reader.threads", 3);
        boolean append = HLog.isAppend(conf);
        try {
            int maxSteps = Double.valueOf(Math.ceil((double)logfiles.length * 1.0 / (double)concurrentLogReads)).intValue();
            for (int step = 0; step < maxSteps; ++step) {
                final TreeMap logEntries = new TreeMap(Bytes.BYTES_COMPARATOR);
                int endIndex = step == maxSteps - 1 ? logfiles.length : step * concurrentLogReads + concurrentLogReads;
                for (int i = step * concurrentLogReads; i < endIndex; ++i) {
                    long length = logfiles[i].getLen();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Splitting hlog " + (i + 1) + " of " + logfiles.length + ": " + logfiles[i].getPath() + ", length=" + logfiles[i].getLen()));
                    }
                    HLog.recoverLog(fs, logfiles[i].getPath(), append);
                    SequenceFile.Reader in = null;
                    int count = 0;
                    try {
                        in = new SequenceFile.Reader(fs, logfiles[i].getPath(), (Configuration)conf);
                        try {
                            HLogKey key = HLog.newKey(conf);
                            KeyValue val = new KeyValue();
                            while (in.next((Writable)key, (Writable)val)) {
                                byte[] regionName = key.getRegionName();
                                LinkedList<HLogEntry> queue = (LinkedList<HLogEntry>)logEntries.get(regionName);
                                if (queue == null) {
                                    queue = new LinkedList<HLogEntry>();
                                    LOG.debug((Object)("Adding queue for " + Bytes.toStringBinary(regionName)));
                                    logEntries.put(regionName, queue);
                                }
                                HLogEntry hle = new HLogEntry(val, key);
                                queue.push(hle);
                                ++count;
                                key = HLog.newKey(conf);
                                val = new KeyValue();
                            }
                            LOG.debug((Object)("Pushed=" + count + " entries from " + logfiles[i].getPath()));
                        }
                        catch (IOException e) {
                            LOG.debug((Object)("IOE Pushed=" + count + " entries from " + logfiles[i].getPath()));
                            e = RemoteExceptionHandler.checkIOException(e);
                            if (e instanceof EOFException) continue;
                            LOG.warn((Object)("Exception processing " + logfiles[i].getPath() + " -- continuing. Possible DATA LOSS!"), (Throwable)e);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        if (length <= 0L) {
                            LOG.warn((Object)("Empty hlog, continuing: " + logfiles[i] + " count=" + count), (Throwable)e);
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            LOG.warn((Object)"Close in finally threw exception -- continuing", (Throwable)e);
                        }
                        fs.delete(logfiles[i].getPath(), true);
                    }
                }
                ExecutorService threadPool = Executors.newFixedThreadPool(logWriterThreads);
                for (final byte[] key : logEntries.keySet()) {
                    Thread thread = new Thread(Bytes.toStringBinary(key)){

                        @Override
                        public void run() {
                            LinkedList entries = (LinkedList)logEntries.get(key);
                            LOG.debug((Object)("Thread got " + entries.size() + " to process"));
                            long threadTime = System.currentTimeMillis();
                            try {
                                int count = 0;
                                ListIterator i = entries.listIterator(entries.size());
                                while (i.hasPrevious()) {
                                    HLogEntry logEntry = (HLogEntry)i.previous();
                                    WriterAndPath wap = (WriterAndPath)logWriters.get(key);
                                    if (wap == null) {
                                        Path logfile = new Path(HRegion.getRegionDir(HTableDescriptor.getTableDir(rootDir, logEntry.getKey().getTablename()), HRegionInfo.encodeRegionName(key)), "oldlogfile.log");
                                        Path oldlogfile = null;
                                        SequenceFile.Reader old = null;
                                        if (fs.exists(logfile)) {
                                            FileStatus stat = fs.getFileStatus(logfile);
                                            if (stat.getLen() <= 0L) {
                                                LOG.warn((Object)("Old hlog file " + logfile + " is zero " + "length. Deleting existing file"));
                                                fs.delete(logfile, false);
                                            } else {
                                                LOG.warn((Object)("Old hlog file " + logfile + " already " + "exists. Copying existing file to new file"));
                                                oldlogfile = new Path(logfile.toString() + ".old");
                                                fs.rename(logfile, oldlogfile);
                                                old = new SequenceFile.Reader(fs, oldlogfile, (Configuration)conf);
                                            }
                                        }
                                        SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)logfile, HLog.getKeyClass(conf), KeyValue.class, (SequenceFile.CompressionType)HLog.getCompressionType(conf));
                                        wap = new WriterAndPath(logfile, w);
                                        logWriters.put(key, wap);
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("Creating new hlog file writer for path " + logfile + " and region " + Bytes.toStringBinary(key)));
                                        }
                                        if (old != null) {
                                            HLogKey oldkey = HLog.newKey(conf);
                                            KeyValue oldval = new KeyValue();
                                            while (old.next((Writable)oldkey, (Writable)oldval)) {
                                                if (LOG.isDebugEnabled() && count > 0 && count % 10000 == 0) {
                                                    LOG.debug((Object)("Copied " + count + " edits"));
                                                }
                                                w.append((Writable)oldkey, (Writable)oldval);
                                                ++count;
                                            }
                                            old.close();
                                            fs.delete(oldlogfile, true);
                                        }
                                    }
                                    wap.w.append((Writable)logEntry.getKey(), (Writable)logEntry.getEdit());
                                    ++count;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Applied " + count + " total edits to " + Bytes.toStringBinary(key) + " in " + (System.currentTimeMillis() - threadTime) + "ms"));
                                }
                            }
                            catch (IOException e) {
                                e = RemoteExceptionHandler.checkIOException(e);
                                LOG.warn((Object)("Got while writing region " + Bytes.toStringBinary(key) + " log " + e));
                                e.printStackTrace();
                            }
                        }
                    };
                    threadPool.execute(thread);
                }
                threadPool.shutdown();
                try {
                    int i = 0;
                    while (!threadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                        LOG.debug((Object)("Waiting for hlog writers to terminate, iteration #" + i));
                        ++i;
                    }
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)"Hlog writers were interrupted, possible data loss!");
                }
            }
            splits = new ArrayList(logWriters.size());
        }
        catch (Throwable throwable) {
            splits = new ArrayList<Path>(logWriters.size());
            for (WriterAndPath wap : logWriters.values()) {
                wap.w.close();
                LOG.debug((Object)("Closed " + wap.p));
                splits.add(wap.p);
            }
            throw throwable;
        }
        for (WriterAndPath wap : logWriters.values()) {
            wap.w.close();
            LOG.debug((Object)("Closed " + wap.p));
            splits.add(wap.p);
        }
        return splits;
    }

    private static boolean isAppend(HBaseConfiguration conf) {
        boolean append = conf.getBoolean("dfs.support.append", false);
        if (append) {
            try {
                SequenceFile.Writer.class.getMethod("syncFs", new Class[0]);
                append = true;
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                append = false;
            }
        }
        return append;
    }

    public static String getHLogDirectoryName(HServerInfo info) {
        return HLog.getHLogDirectoryName(HServerInfo.getServerName(info));
    }

    private static void recoverLog(FileSystem fs, Path p, boolean append) {
        if (!append) {
            return;
        }
        boolean recovered = false;
        while (!recovered) {
            try {
                FSDataOutputStream out = fs.append(p);
                out.close();
                recovered = true;
            }
            catch (IOException e) {
                LOG.info((Object)("Failed open for append, waiting on lease recovery: " + p), (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
        }
        LOG.info((Object)"Past out lease recovery");
    }

    public static String getHLogDirectoryName(String serverAddress, long startCode) {
        if (serverAddress == null || serverAddress.length() == 0) {
            return null;
        }
        return HLog.getHLogDirectoryName(HServerInfo.getServerName(serverAddress, startCode));
    }

    public static String getHLogDirectoryName(String serverName) {
        StringBuilder dirName = new StringBuilder(".logs");
        dirName.append("/");
        dirName.append(serverName);
        return dirName.toString();
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.hbase.HLog {--dump <logfile>... | --split <logdir>...}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            HLog.usage();
            System.exit(-1);
        }
        boolean dump = true;
        if (args[0].compareTo("--dump") != 0) {
            if (args[0].compareTo("--split") == 0) {
                dump = false;
            } else {
                HLog.usage();
                System.exit(-1);
            }
        }
        HBaseConfiguration conf = new HBaseConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path baseDir = new Path(conf.get("hbase.rootdir"));
        for (int i = 1; i < args.length; ++i) {
            Path logPath = new Path(args[i]);
            if (!fs.exists(logPath)) {
                throw new FileNotFoundException(args[i] + " does not exist");
            }
            if (dump) {
                if (!fs.isFile(logPath)) {
                    throw new IOException(args[i] + " is not a file");
                }
                SequenceFile.Reader log = new SequenceFile.Reader(fs, logPath, (Configuration)conf);
                try {
                    HLogKey key = new HLogKey();
                    KeyValue val = new KeyValue();
                    while (log.next((Writable)key, (Writable)val)) {
                        System.out.println(key.toString() + " " + val.toString());
                    }
                    continue;
                }
                finally {
                    log.close();
                }
            }
            if (!fs.getFileStatus(logPath).isDir()) {
                throw new IOException(args[i] + " is not a directory");
            }
            HLog.splitLog(baseDir, logPath, fs, conf);
        }
    }

    static {
        block2: {
            LOG = LogFactory.getLog(HLog.class);
            METAFAMILY = Bytes.toBytes("METAFAMILY");
            METAROW = Bytes.toBytes("METAROW");
            NO_ARGS = new Object[0];
            try {
                COMPLETE_CACHE_FLUSH = "HBASE::CACHEFLUSH".getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + ClassSize.ATOMIC_INTEGER + 4 + 24);
    }

    public static class HLogEntry {
        private KeyValue edit;
        private HLogKey key;

        public HLogEntry(KeyValue edit, HLogKey key) {
            this.edit = edit;
            this.key = key;
        }

        public KeyValue getEdit() {
            return this.edit;
        }

        public HLogKey getKey() {
            return this.key;
        }

        public String toString() {
            return this.key + "=" + this.edit;
        }
    }

    private static final class WriterAndPath {
        final Path p;
        final SequenceFile.Writer w;

        WriterAndPath(Path p, SequenceFile.Writer w) {
            this.p = p;
            this.w = w;
        }
    }
}

