/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;

class MemStoreScanner
implements KeyValueScanner {
    private static final Log LOG = LogFactory.getLog(MemStoreScanner.class);
    private static final SortedSet<KeyValue> EMPTY_SET = new TreeSet<KeyValue>();
    private static final Iterator<KeyValue> EMPTY_ITERATOR = new Iterator<KeyValue>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public KeyValue next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private SortedSet<KeyValue> kvsetRef;
    private SortedSet<KeyValue> snapshotRef;
    private KeyValue.KVComparator comparatorRef;
    private Iterator<KeyValue> kvsetIterator;
    private Iterator<KeyValue> snapshotIterator;
    private KeyValue currentKvsetKV;
    private KeyValue currentSnapshotKV;
    private KeyValue nextKV;

    MemStoreScanner(KeyValueSkipListSet kvset, KeyValueSkipListSet snapshot, KeyValue.KVComparator comparator) {
        this.kvsetRef = kvset;
        this.snapshotRef = snapshot != null ? snapshot : EMPTY_SET;
        this.comparatorRef = comparator;
        this.kvsetIterator = this.kvsetRef.iterator();
        this.snapshotIterator = this.snapshotRef.iterator();
        this.currentSnapshotKV = null;
        this.currentKvsetKV = null;
        this.nextKV = null;
    }

    private void fill() {
        if (this.nextKV == null) {
            if (this.currentSnapshotKV == null && this.snapshotIterator.hasNext()) {
                this.currentSnapshotKV = this.snapshotIterator.next();
            }
            if (this.currentKvsetKV == null && this.kvsetIterator.hasNext()) {
                this.currentKvsetKV = this.kvsetIterator.next();
            }
            if (this.currentSnapshotKV != null && this.currentKvsetKV != null) {
                int cmp = this.comparatorRef.compare(this.currentSnapshotKV, this.currentKvsetKV);
                if (cmp <= 0) {
                    this.nextKV = this.currentSnapshotKV;
                    this.currentSnapshotKV = null;
                } else {
                    this.nextKV = this.currentKvsetKV;
                    this.currentKvsetKV = null;
                }
            } else if (this.currentSnapshotKV != null) {
                this.nextKV = this.currentSnapshotKV;
                this.currentSnapshotKV = null;
            } else {
                this.nextKV = this.currentKvsetKV;
                this.currentKvsetKV = null;
            }
        }
    }

    @Override
    public synchronized boolean seek(KeyValue key) {
        if (key == null) {
            this.close();
            return false;
        }
        SortedSet<KeyValue> kvsetTail = this.kvsetRef.tailSet(key);
        SortedSet<KeyValue> snapshotTail = this.snapshotRef != null ? this.snapshotRef.tailSet(key) : EMPTY_SET;
        this.kvsetIterator = kvsetTail.iterator();
        this.snapshotIterator = snapshotTail.iterator();
        this.currentKvsetKV = null;
        this.currentSnapshotKV = null;
        this.nextKV = null;
        return this.kvsetIterator.hasNext() || this.snapshotIterator.hasNext();
    }

    @Override
    public synchronized KeyValue peek() {
        this.fill();
        return this.nextKV;
    }

    @Override
    public synchronized KeyValue next() {
        this.fill();
        KeyValue next = this.nextKV;
        this.nextKV = null;
        return next;
    }

    @Override
    public synchronized void close() {
        this.kvsetRef = EMPTY_SET;
        this.snapshotRef = EMPTY_SET;
        this.kvsetIterator = EMPTY_ITERATOR;
        this.snapshotIterator = EMPTY_ITERATOR;
        this.currentKvsetKV = null;
        this.currentSnapshotKV = null;
        this.nextKV = null;
    }
}

