/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class StoreFileGetScan {
    private List<HFileScanner> scanners;
    private QueryMatcher matcher;
    private KeyValue startKey;

    public StoreFileGetScan(List<HFileScanner> scanners, QueryMatcher matcher) {
        this.scanners = scanners;
        this.matcher = matcher;
        this.startKey = matcher.getStartKey();
    }

    public void get(List<KeyValue> result) throws IOException {
        for (HFileScanner scanner : this.scanners) {
            this.matcher.update();
            if (!this.getStoreFile(scanner, result) && !this.matcher.isDone()) continue;
            return;
        }
    }

    public boolean getStoreFile(HFileScanner scanner, List<KeyValue> result) throws IOException {
        if (scanner.seekTo(this.startKey.getBuffer(), this.startKey.getKeyOffset(), this.startKey.getKeyLength()) == -1) {
            byte[] firstKey = scanner.getReader().getFirstKey();
            if (firstKey == null) {
                return false;
            }
            int rowOffset = 2;
            short rowLen = Bytes.toShort(firstKey, 0, 2);
            if (this.matcher.rowComparator.compareRows(firstKey, rowOffset, rowLen, this.startKey.getBuffer(), this.startKey.getRowOffset(), this.startKey.getRowLength()) != 0) {
                return false;
            }
            scanner.seekTo();
        }
        do {
            KeyValue kv = scanner.getKeyValue();
            switch (this.matcher.match(kv)) {
                case INCLUDE: {
                    result.add(kv);
                    break;
                }
                case SKIP: {
                    break;
                }
                case NEXT: {
                    return false;
                }
                case DONE: {
                    return true;
                }
            }
        } while (scanner.next());
        return false;
    }
}

