/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.regionserver.DeleteCompare;

public class TestDeleteCompare
extends TestCase {
    public void testDeleteCompare_DeleteFamily() {
        TreeSet<KeyValue> memstore = new TreeSet<KeyValue>(KeyValue.COMPARATOR);
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 3L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 2L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 1L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col2", 1L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col3", 3L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col3", 2L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col3", 1L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row21", "fam", "col1", 1L, "d-c"));
        ArrayList<DeleteCompare.DeleteCode> expected = new ArrayList<DeleteCompare.DeleteCode>();
        expected.add(DeleteCompare.DeleteCode.SKIP);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.SKIP);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DONE);
        KeyValue delete = KeyValueTestUtil.create("row11", "fam", "", 2L, KeyValue.Type.DeleteFamily, "dont-care");
        byte[] deleteBuffer = delete.getBuffer();
        int deleteRowOffset = delete.getRowOffset();
        short deleteRowLen = delete.getRowLength();
        int deleteQualifierOffset = delete.getQualifierOffset();
        int deleteQualifierLen = delete.getQualifierLength();
        int deleteTimestampOffset = deleteQualifierOffset + deleteQualifierLen;
        byte deleteType = deleteBuffer[deleteTimestampOffset + 8];
        ArrayList<DeleteCompare.DeleteCode> actual = new ArrayList<DeleteCompare.DeleteCode>();
        for (KeyValue mem : memstore) {
            actual.add(DeleteCompare.deleteCompare(mem, deleteBuffer, deleteRowOffset, deleteRowLen, deleteQualifierOffset, deleteQualifierLen, deleteTimestampOffset, deleteType, KeyValue.KEY_COMPARATOR));
        }
        TestDeleteCompare.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestDeleteCompare.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testDeleteCompare_DeleteColumn() {
        TreeSet<KeyValue> memstore = new TreeSet<KeyValue>(KeyValue.COMPARATOR);
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 3L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 2L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 1L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row21", "fam", "col1", 1L, "d-c"));
        ArrayList<DeleteCompare.DeleteCode> expected = new ArrayList<DeleteCompare.DeleteCode>();
        expected.add(DeleteCompare.DeleteCode.SKIP);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DONE);
        KeyValue delete = KeyValueTestUtil.create("row11", "fam", "col1", 2L, KeyValue.Type.DeleteColumn, "dont-care");
        byte[] deleteBuffer = delete.getBuffer();
        int deleteRowOffset = delete.getRowOffset();
        short deleteRowLen = delete.getRowLength();
        int deleteQualifierOffset = delete.getQualifierOffset();
        int deleteQualifierLen = delete.getQualifierLength();
        int deleteTimestampOffset = deleteQualifierOffset + deleteQualifierLen;
        byte deleteType = deleteBuffer[deleteTimestampOffset + 8];
        ArrayList<DeleteCompare.DeleteCode> actual = new ArrayList<DeleteCompare.DeleteCode>();
        for (KeyValue mem : memstore) {
            actual.add(DeleteCompare.deleteCompare(mem, deleteBuffer, deleteRowOffset, deleteRowLen, deleteQualifierOffset, deleteQualifierLen, deleteTimestampOffset, deleteType, KeyValue.KEY_COMPARATOR));
        }
        TestDeleteCompare.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestDeleteCompare.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testDeleteCompare_Delete() {
        TreeSet<KeyValue> memstore = new TreeSet<KeyValue>(KeyValue.COMPARATOR);
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 3L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 2L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 1L, "d-c"));
        ArrayList<DeleteCompare.DeleteCode> expected = new ArrayList<DeleteCompare.DeleteCode>();
        expected.add(DeleteCompare.DeleteCode.SKIP);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DONE);
        KeyValue delete = KeyValueTestUtil.create("row11", "fam", "col1", 2L, KeyValue.Type.Delete, "dont-care");
        byte[] deleteBuffer = delete.getBuffer();
        int deleteRowOffset = delete.getRowOffset();
        short deleteRowLen = delete.getRowLength();
        int deleteQualifierOffset = delete.getQualifierOffset();
        int deleteQualifierLen = delete.getQualifierLength();
        int deleteTimestampOffset = deleteQualifierOffset + deleteQualifierLen;
        byte deleteType = deleteBuffer[deleteTimestampOffset + 8];
        ArrayList<DeleteCompare.DeleteCode> actual = new ArrayList<DeleteCompare.DeleteCode>();
        for (KeyValue mem : memstore) {
            actual.add(DeleteCompare.deleteCompare(mem, deleteBuffer, deleteRowOffset, deleteRowLen, deleteQualifierOffset, deleteQualifierLen, deleteTimestampOffset, deleteType, KeyValue.KEY_COMPARATOR));
        }
        TestDeleteCompare.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestDeleteCompare.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testDeleteCompare_Multiple() {
        TreeSet<KeyValue> memstore = new TreeSet<KeyValue>(KeyValue.COMPARATOR);
        memstore.add(KeyValueTestUtil.create("row11", "fam", "col1", 1L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row21", "fam", "col1", 4L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row21", "fam", "col1", 3L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row21", "fam", "col1", 2L, "d-c"));
        memstore.add(KeyValueTestUtil.create("row21", "fam", "col1", 1L, KeyValue.Type.Delete, "dont-care"));
        memstore.add(KeyValueTestUtil.create("row31", "fam", "col1", 1L, "dont-care"));
        ArrayList<DeleteCompare.DeleteCode> expected = new ArrayList<DeleteCompare.DeleteCode>();
        expected.add(DeleteCompare.DeleteCode.SKIP);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DELETE);
        expected.add(DeleteCompare.DeleteCode.DONE);
        KeyValue delete = KeyValueTestUtil.create("row21", "fam", "col1", 5L, KeyValue.Type.DeleteColumn, "dont-care");
        byte[] deleteBuffer = delete.getBuffer();
        int deleteRowOffset = delete.getRowOffset();
        short deleteRowLen = delete.getRowLength();
        int deleteQualifierOffset = delete.getQualifierOffset();
        int deleteQualifierLen = delete.getQualifierLength();
        int deleteTimestampOffset = deleteQualifierOffset + deleteQualifierLen;
        byte deleteType = deleteBuffer[deleteTimestampOffset + 8];
        ArrayList<DeleteCompare.DeleteCode> actual = new ArrayList<DeleteCompare.DeleteCode>();
        for (KeyValue mem : memstore) {
            actual.add(DeleteCompare.deleteCompare(mem, deleteBuffer, deleteRowOffset, deleteRowLen, deleteQualifierOffset, deleteQualifierLen, deleteTimestampOffset, deleteType, KeyValue.KEY_COMPARATOR));
        }
        TestDeleteCompare.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestDeleteCompare.assertEquals(expected.get(i), actual.get(i));
        }
    }
}

