/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.GetDeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class TestGetDeleteTracker
extends HBaseTestCase
implements HConstants {
    private final boolean PRINT = true;
    private byte[] col1 = null;
    private byte[] col2 = null;
    private int col1Len = 0;
    private int col2Len = 0;
    private byte[] empty = null;
    private long ts1 = 0L;
    private long ts2 = 0L;
    private long ts3 = 0L;
    private GetDeleteTracker.Delete del10 = null;
    private GetDeleteTracker.Delete del11 = null;
    private GetDeleteTracker.Delete delQf10 = null;
    private GetDeleteTracker.Delete delQf11 = null;
    private GetDeleteTracker.Delete delFam10 = null;
    private GetDeleteTracker.Delete del20 = null;
    private GetDeleteTracker.Delete del21 = null;
    private GetDeleteTracker.Delete delQf20 = null;
    private GetDeleteTracker.Delete delQf21 = null;
    private GetDeleteTracker.Delete delFam20 = null;
    private GetDeleteTracker.Delete del30 = null;
    GetDeleteTracker dt = null;
    private byte del = KeyValue.Type.Delete.getCode();
    private byte delCol = KeyValue.Type.DeleteColumn.getCode();
    private byte delFam = KeyValue.Type.DeleteFamily.getCode();

    @Override
    protected void setUp() throws Exception {
        this.dt = new GetDeleteTracker();
        this.col1 = "col".getBytes();
        this.col2 = "col2".getBytes();
        this.col1Len = this.col1.length;
        this.col2Len = this.col2.length;
        this.empty = new byte[0];
        this.ts1 = System.nanoTime();
        this.del10 = new GetDeleteTracker.Delete(this.col1, 0, this.col1Len, this.del, this.ts1);
        this.del11 = new GetDeleteTracker.Delete(this.col2, 0, this.col2Len, this.del, this.ts1);
        this.delQf10 = new GetDeleteTracker.Delete(this.col1, 0, this.col1Len, this.delCol, this.ts1);
        this.delQf11 = new GetDeleteTracker.Delete(this.col2, 0, this.col2Len, this.delCol, this.ts1);
        this.delFam10 = new GetDeleteTracker.Delete(this.empty, 0, 0, this.delFam, this.ts1);
        this.ts2 = System.nanoTime();
        this.del20 = new GetDeleteTracker.Delete(this.col1, 0, this.col1Len, this.del, this.ts2);
        this.del21 = new GetDeleteTracker.Delete(this.col2, 0, this.col2Len, this.del, this.ts2);
        this.delQf20 = new GetDeleteTracker.Delete(this.col1, 0, this.col1Len, this.delCol, this.ts2);
        this.delQf21 = new GetDeleteTracker.Delete(this.col2, 0, this.col2Len, this.delCol, this.ts2);
        this.delFam20 = new GetDeleteTracker.Delete(this.empty, 0, 0, this.delFam, this.ts1);
        this.ts3 = System.nanoTime();
        this.del30 = new GetDeleteTracker.Delete(this.col1, 0, this.col1Len, this.del, this.ts3);
    }

    public void testUpdate_CompareDeletes() {
        DeleteTracker.DeleteCompare res = null;
        res = this.dt.compareDeletes(this.del10, this.del10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_BOTH), (Object)((Object)res));
        res = this.dt.compareDeletes(this.del10, this.del11);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_OLD), (Object)((Object)res));
        res = this.dt.compareDeletes(this.del11, this.del10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_NEW), (Object)((Object)res));
        res = this.dt.compareDeletes(this.del10, this.del20);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_NEW), (Object)((Object)res));
        res = this.dt.compareDeletes(this.del20, this.del10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_OLD), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf10, this.delQf10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_BOTH), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf10, this.delQf11);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_OLD), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf11, this.delQf10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_NEW), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf10, this.delQf20);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_BOTH), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf20, this.delQf10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_BOTH), (Object)((Object)res));
        res = this.dt.compareDeletes(this.del10, this.delQf10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.NEXT_OLD), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf10, this.del10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.NEXT_NEW), (Object)((Object)res));
        res = this.dt.compareDeletes(this.del10, this.delQf11);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_OLD), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf11, this.del10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_NEW), (Object)((Object)res));
        res = this.dt.compareDeletes(this.del11, this.delQf10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_NEW), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf10, this.del11);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_OLD), (Object)((Object)res));
        res = this.dt.compareDeletes(this.del20, this.delQf10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_OLD), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf10, this.del20);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_NEW), (Object)((Object)res));
        res = this.dt.compareDeletes(this.del10, this.delQf20);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.NEXT_OLD), (Object)((Object)res));
        res = this.dt.compareDeletes(this.delQf20, this.del10);
        TestGetDeleteTracker.assertEquals((Object)((Object)DeleteTracker.DeleteCompare.NEXT_NEW), (Object)((Object)res));
    }

    public void testUpdate() {
        ArrayList<GetDeleteTracker.Delete> dels1 = new ArrayList<GetDeleteTracker.Delete>();
        dels1.add(this.delQf10);
        dels1.add(this.del21);
        ArrayList<GetDeleteTracker.Delete> dels2 = new ArrayList<GetDeleteTracker.Delete>();
        dels2.add(this.delFam10);
        dels2.add(this.del30);
        dels2.add(this.delQf20);
        ArrayList<GetDeleteTracker.Delete> res = new ArrayList<GetDeleteTracker.Delete>();
        res.add(this.del30);
        res.add(this.delQf20);
        res.add(this.del21);
        for (GetDeleteTracker.Delete del : dels1) {
            this.dt.add(del.buffer, del.qualifierOffset, del.qualifierLength, del.timestamp, del.type);
        }
        this.dt.update();
        List<GetDeleteTracker.Delete> delList = this.dt.deletes;
        TestGetDeleteTracker.assertEquals((int)dels1.size(), (int)delList.size());
        for (int i = 0; i < dels1.size(); ++i) {
            TestGetDeleteTracker.assertEquals((int)0, (int)Bytes.compareTo(((GetDeleteTracker.Delete)dels1.get((int)i)).buffer, delList.get((int)i).buffer));
            TestGetDeleteTracker.assertEquals((int)((GetDeleteTracker.Delete)dels1.get((int)i)).qualifierOffset, (int)delList.get((int)i).qualifierOffset);
            TestGetDeleteTracker.assertEquals((int)((GetDeleteTracker.Delete)dels1.get((int)i)).qualifierLength, (int)delList.get((int)i).qualifierLength);
            TestGetDeleteTracker.assertEquals((long)((GetDeleteTracker.Delete)dels1.get((int)i)).timestamp, (long)delList.get((int)i).timestamp);
            TestGetDeleteTracker.assertEquals((byte)((GetDeleteTracker.Delete)dels1.get((int)i)).type, (byte)delList.get((int)i).type);
        }
        for (GetDeleteTracker.Delete del : dels2) {
            this.dt.add(del.buffer, del.qualifierOffset, del.qualifierLength, del.timestamp, del.type);
        }
        this.dt.update();
        delList = this.dt.deletes;
        for (int i = 0; i < res.size(); ++i) {
            TestGetDeleteTracker.assertEquals((int)0, (int)Bytes.compareTo(((GetDeleteTracker.Delete)res.get((int)i)).buffer, delList.get((int)i).buffer));
            TestGetDeleteTracker.assertEquals((int)((GetDeleteTracker.Delete)res.get((int)i)).qualifierOffset, (int)delList.get((int)i).qualifierOffset);
            TestGetDeleteTracker.assertEquals((int)((GetDeleteTracker.Delete)res.get((int)i)).qualifierLength, (int)delList.get((int)i).qualifierLength);
            TestGetDeleteTracker.assertEquals((long)((GetDeleteTracker.Delete)res.get((int)i)).timestamp, (long)delList.get((int)i).timestamp);
            TestGetDeleteTracker.assertEquals((byte)((GetDeleteTracker.Delete)res.get((int)i)).type, (byte)delList.get((int)i).type);
            System.out.println("Qf " + new String(delList.get((int)i).buffer) + ", timestamp, " + delList.get((int)i).timestamp + ", type " + (Object)((Object)KeyValue.Type.codeToType(delList.get((int)i).type)));
        }
    }

    public void testIsDeleted_NotDeleted() {
        ArrayList<GetDeleteTracker.Delete> dels = new ArrayList<GetDeleteTracker.Delete>();
        dels.add(this.delQf10);
        dels.add(this.del21);
        for (GetDeleteTracker.Delete del : dels) {
            this.dt.add(del.buffer, del.qualifierOffset, del.qualifierLength, del.timestamp, del.type);
        }
        this.dt.update();
        TestGetDeleteTracker.assertEquals((boolean)false, (boolean)this.dt.isDeleted(this.col2, 0, this.col2Len, this.ts3));
        TestGetDeleteTracker.assertEquals((boolean)false, (boolean)this.dt.isDeleted(this.col2, 0, this.col2Len, this.ts1));
    }

    public void testIsDeleted_Delete() {
        ArrayList<GetDeleteTracker.Delete> dels = new ArrayList<GetDeleteTracker.Delete>();
        dels.add(this.del21);
        for (GetDeleteTracker.Delete del : dels) {
            this.dt.add(del.buffer, del.qualifierOffset, del.qualifierLength, del.timestamp, del.type);
        }
        this.dt.update();
        TestGetDeleteTracker.assertEquals((boolean)true, (boolean)this.dt.isDeleted(this.col2, 0, this.col2Len, this.ts2));
    }

    public void testIsDeleted_DeleteColumn() {
        ArrayList<GetDeleteTracker.Delete> dels = new ArrayList<GetDeleteTracker.Delete>();
        dels.add(this.delQf21);
        for (GetDeleteTracker.Delete del : dels) {
            this.dt.add(del.buffer, del.qualifierOffset, del.qualifierLength, del.timestamp, del.type);
        }
        this.dt.update();
        TestGetDeleteTracker.assertEquals((boolean)true, (boolean)this.dt.isDeleted(this.col2, 0, this.col2Len, this.ts1));
    }

    public void testIsDeleted_DeleteFamily() {
        ArrayList<GetDeleteTracker.Delete> dels = new ArrayList<GetDeleteTracker.Delete>();
        dels.add(this.delFam20);
        for (GetDeleteTracker.Delete del : dels) {
            this.dt.add(del.buffer, del.qualifierOffset, del.qualifierLength, del.timestamp, del.type);
        }
        this.dt.update();
        TestGetDeleteTracker.assertEquals((boolean)true, (boolean)this.dt.isDeleted(this.col2, 0, this.col2Len, this.ts1));
    }

    public void testStackOverflow() {
        ArrayList dels = new ArrayList();
        GetDeleteTracker.Delete adel = new GetDeleteTracker.Delete(this.col1, 0, this.col1Len, this.del, 0L);
        for (long i = 0L; i < 9000L; ++i) {
            this.dt.add(adel.buffer, adel.qualifierOffset, adel.qualifierLength, i, adel.type);
        }
        this.dt.update();
        TestGetDeleteTracker.assertEquals((boolean)false, (boolean)this.dt.isDeleted(this.col2, 0, this.col2Len, 7000000L));
    }
}

