/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import junit.framework.TestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.regionserver.KeyValueScanFixture;
import org.apache.hadoop.hbase.util.Bytes;

public class TestKeyValueScanFixture
extends TestCase {
    public void testKeyValueScanFixture() {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("RowA", "family", "qf1", 1L, KeyValue.Type.Put, "value-1"), KeyValueTestUtil.create("RowA", "family", "qf2", 1L, KeyValue.Type.Put, "value-2"), KeyValueTestUtil.create("RowB", "family", "qf1", 10L, KeyValue.Type.Put, "value-10")};
        KeyValueScanFixture scan = new KeyValueScanFixture(KeyValue.COMPARATOR, kvs);
        TestKeyValueScanFixture.assertNull((Object)scan.peek());
        KeyValue kv = KeyValue.createFirstOnRow(Bytes.toBytes("RowA"));
        TestKeyValueScanFixture.assertTrue((boolean)scan.seek(kv));
        KeyValue res = scan.peek();
        TestKeyValueScanFixture.assertEquals((Object)kvs[0], (Object)res);
        kv = KeyValue.createFirstOnRow(Bytes.toBytes("RowB"));
        TestKeyValueScanFixture.assertTrue((boolean)scan.seek(kv));
        res = scan.peek();
        TestKeyValueScanFixture.assertEquals((Object)kvs[2], (Object)res);
        kv = KeyValue.createFirstOnRow(Bytes.toBytes("RowA"));
        TestKeyValueScanFixture.assertTrue((boolean)scan.seek(kv));
        TestKeyValueScanFixture.assertEquals((Object)kvs[0], (Object)scan.peek());
        TestKeyValueScanFixture.assertEquals((Object)kvs[0], (Object)scan.next());
        TestKeyValueScanFixture.assertEquals((Object)kvs[1], (Object)scan.peek());
        TestKeyValueScanFixture.assertEquals((Object)kvs[1], (Object)scan.next());
        TestKeyValueScanFixture.assertEquals((Object)kvs[2], (Object)scan.peek());
        TestKeyValueScanFixture.assertEquals((Object)kvs[2], (Object)scan.next());
        TestKeyValueScanFixture.assertEquals(null, (Object)scan.peek());
        TestKeyValueScanFixture.assertEquals(null, (Object)scan.next());
    }
}

