/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HStoreKey;
import org.apache.hadoop.hbase.regionserver.LruHashMap;
import org.apache.hadoop.hbase.util.Bytes;

public class TestLruHashMap
extends TestCase {
    private static LruHashMap<HStoreKey, HStoreKey> lru = null;
    private static HStoreKey[] keys = null;
    private static HStoreKey key = null;
    private static HStoreKey tmpKey = null;
    private static HStoreKey[] vals = null;
    private static HStoreKey val = null;
    private static HStoreKey tmpVal = null;
    private static HStoreKey[] tmpData = null;
    private static Set<LruHashMap.Entry<HStoreKey, HStoreKey>> hashSet = null;
    private static List<LruHashMap.Entry<HStoreKey, HStoreKey>> entryList = null;
    private static LruHashMap.Entry<HStoreKey, HStoreKey> entry = null;
    private static Random rand = null;
    private static int ENTRY_ARRAY_LEN = 2000;
    private static int LOOPS = 10;

    protected void setUp() throws Exception {
        super.setUp();
        long maxMemUsage = 10000000L;
        lru = new LruHashMap(maxMemUsage);
        rand = new Random();
        keys = new HStoreKey[ENTRY_ARRAY_LEN];
        vals = new HStoreKey[ENTRY_ARRAY_LEN];
        tmpData = new HStoreKey[ENTRY_ARRAY_LEN];
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAdd_Pointers() {
        for (int i = 0; i < LOOPS; ++i) {
            TestLruHashMap.sequential(keys);
            tmpKey = keys[0];
            for (HStoreKey key : keys) {
                lru.put(key, key);
                TestLruHashMap.assertTrue((String)"headPtr key not correct", (boolean)lru.getHeadPtr().getKey().equals(tmpKey));
                TestLruHashMap.assertTrue((String)"tailPtr key not correct", (boolean)lru.getTailPtr().getKey().equals(key));
            }
            lru.clear();
        }
        System.out.println("testAdd_Pointers: OK");
    }

    public void testAdd_MemUsage_random() {
        for (int i = 0; i < LOOPS; ++i) {
            TestLruHashMap.random(keys);
            for (HStoreKey key : keys) {
                lru.put(key, key);
                TestLruHashMap.assertTrue((String)"Memory usage exceeded!", (lru.getMemFree() > 0L ? 1 : 0) != 0);
            }
            lru.clear();
        }
        System.out.println("testAdd_MemUsage: OK");
    }

    public void testAdd_MemUsage_sequential() {
        for (int i = 0; i < LOOPS; ++i) {
            TestLruHashMap.sequential(keys);
            for (HStoreKey key : keys) {
                lru.put(key, key);
                TestLruHashMap.assertTrue((String)"Memory usage exceeded!", (lru.getMemFree() > 0L ? 1 : 0) != 0);
            }
            lru.clear();
        }
        System.out.println("testAdd_MemUsage: OK");
    }

    public void testAdd_Order() throws Exception {
        for (int i = 0; i < LOOPS; ++i) {
            TestLruHashMap.put();
            entryList = lru.entryLruList();
            TestLruHashMap.assertTrue((String)"Different lengths", (keys.length == entryList.size() ? 1 : 0) != 0);
            int j = 0;
            for (LruHashMap.Entry<HStoreKey, HStoreKey> entry : entryList) {
                TestLruHashMap.assertTrue((String)"Different order", (boolean)keys[j++].equals(entry.getKey()));
            }
            lru.clear();
        }
        System.out.println("testAdd_Order: OK");
    }

    public void testAdd_Clear() throws Exception {
        long initMemUsage = 0L;
        long putMemUsage = 0L;
        long clearMemUsage = 0L;
        for (int i = 0; i < LOOPS; ++i) {
            initMemUsage = lru.getMemFree();
            TestLruHashMap.put();
            putMemUsage = lru.getMemFree();
            lru.clear();
            clearMemUsage = lru.getMemFree();
            TestLruHashMap.assertTrue((String)"memUsage went down", (clearMemUsage <= initMemUsage ? 1 : 0) != 0);
        }
        System.out.println("testAdd_Clear: OK");
    }

    public void testAdd_Containment() {
        for (int i = 0; i < LOOPS; ++i) {
            TestLruHashMap.put();
            hashSet = lru.entryTableSet();
            entryList = lru.entryLruList();
            TestLruHashMap.assertTrue((String)"Wrong size", (hashSet.size() == entryList.size() ? 1 : 0) != 0);
            for (int j = 0; j < entryList.size(); ++j) {
                TestLruHashMap.assertTrue((String)"Set doesn't contain value from list", (boolean)hashSet.contains(entryList.get(j)));
            }
            lru.clear();
        }
        System.out.println("testAdd_Containment: OK");
    }

    public void testGet() {
        int getter = 0;
        for (int i = 0; i < LOOPS; ++i) {
            TestLruHashMap.put();
            getter = rand.nextInt(ENTRY_ARRAY_LEN);
            key = keys[getter];
            val = (HStoreKey)lru.get(key);
            entryList = lru.entryLruList();
            tmpKey = (HStoreKey)entryList.get(entryList.size() - 1).getKey();
            TestLruHashMap.assertTrue((String)"Get did not put entry first", (boolean)tmpKey.equals(key));
            if (getter != ENTRY_ARRAY_LEN - 1) {
                tmpKey = (HStoreKey)entryList.get(getter).getKey();
                TestLruHashMap.assertFalse((String)"Get did leave entry in same position", (boolean)tmpKey.equals(key));
            }
            lru.clear();
        }
        System.out.println("testGet: OK");
    }

    public void testUpdate() {
        for (int i = 0; i < LOOPS; ++i) {
            TestLruHashMap.put();
            key = keys[rand.nextInt(ENTRY_ARRAY_LEN)];
            val = TestLruHashMap.random(val);
            tmpVal = lru.put(key, val);
            entryList = lru.entryLruList();
            tmpKey = (HStoreKey)entryList.get(entryList.size() - 1).getKey();
            TestLruHashMap.assertTrue((String)"put(update) did not put entry first", (boolean)tmpKey.equals(key));
            if (!val.equals(tmpVal)) {
                TestLruHashMap.assertTrue((String)"Value was not updated", (boolean)((HStoreKey)entryList.get(entryList.size() - 1).getValue()).equals(val));
                TestLruHashMap.assertFalse((String)"Value was not updated", (boolean)((HStoreKey)entryList.get(entryList.size() - 1).getValue()).equals(tmpVal));
            }
            lru.clear();
        }
        System.out.println("testUpdate: OK");
    }

    public void testRemove() {
        for (int i = 0; i < LOOPS; ++i) {
            TestLruHashMap.put();
            entryList = lru.entryLruList();
            key = keys[rand.nextInt(ENTRY_ARRAY_LEN)];
            val = (HStoreKey)lru.remove(key);
            entryList = lru.entryLruList();
            for (int j = 0; j < entryList.size(); ++j) {
                TestLruHashMap.assertFalse((String)"Entry found in list after remove", (boolean)entryList.get(j).equals(key));
            }
            lru.clear();
        }
        System.out.println("testRemove: OK");
    }

    private static void put() {
        TestLruHashMap.random(keys);
        vals = keys;
        for (int i = 0; i < keys.length; ++i) {
            lru.put(keys[i], vals[i]);
        }
    }

    private static HStoreKey random(HStoreKey data) {
        return new HStoreKey(Bytes.toBytes(rand.nextInt(ENTRY_ARRAY_LEN)));
    }

    private static void random(HStoreKey[] keys) {
        int LENGTH = keys.length;
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < LENGTH; ++i) {
            Integer pos = 0;
            while (set.contains(pos = new Integer(rand.nextInt(LENGTH)))) {
            }
            set.add(pos);
            keys[i] = new HStoreKey(Bytes.toBytes(pos));
        }
    }

    private static void sequential(HStoreKey[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = new HStoreKey(Bytes.toBytes(i));
        }
    }

    private HStoreKey[] mapEntriesToArray(List<LruHashMap.Entry<HStoreKey, HStoreKey>> entryList) {
        ArrayList res = new ArrayList();
        for (LruHashMap.Entry<HStoreKey, HStoreKey> entry : entryList) {
            res.add(entry.getKey());
        }
        return res.toArray(new HStoreKey[0]);
    }
}

