/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.HLog;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Progressable;

public class TestStore
extends TestCase {
    Store store;
    byte[] table = Bytes.toBytes("table");
    byte[] family = Bytes.toBytes("family");
    byte[] row = Bytes.toBytes("row");
    byte[] qf1 = Bytes.toBytes("qf1");
    byte[] qf2 = Bytes.toBytes("qf2");
    byte[] qf3 = Bytes.toBytes("qf3");
    byte[] qf4 = Bytes.toBytes("qf4");
    byte[] qf5 = Bytes.toBytes("qf5");
    byte[] qf6 = Bytes.toBytes("qf6");
    NavigableSet<byte[]> qualifiers = new ConcurrentSkipListSet<byte[]>(Bytes.BYTES_COMPARATOR);
    List<KeyValue> expected = new ArrayList<KeyValue>();
    List<KeyValue> result = new ArrayList<KeyValue>();
    long id = System.currentTimeMillis();
    Get get = new Get(this.row);
    private final String DIR = "test/build/data/TestStore/";

    public void setUp() throws IOException {
        this.qualifiers.add(this.qf1);
        this.qualifiers.add(this.qf3);
        this.qualifiers.add(this.qf5);
        for (byte[] next : this.qualifiers) {
            this.expected.add(new KeyValue(this.row, this.family, next, null));
            this.get.addColumn(this.family, next);
        }
    }

    private void init(String methodName) throws IOException {
        Path basedir = new Path("test/build/data/TestStore/" + methodName);
        Path logdir = new Path("test/build/data/TestStore/" + methodName + "/logs");
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        HBaseConfiguration conf = new HBaseConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path reconstructionLog = null;
        Progressable reporter = null;
        fs.delete(logdir, true);
        HTableDescriptor htd = new HTableDescriptor(this.table);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd, null, null, false);
        HLog hlog = new HLog(fs, logdir, conf, null);
        HRegion region = new HRegion(basedir, hlog, fs, conf, info, null);
        this.store = new Store(basedir, region, hcd, fs, reconstructionLog, conf, reporter);
    }

    public void testEmptyStoreFile() throws IOException {
        this.init(this.getName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, null));
        this.flush(1);
        StoreFile f = this.store.getStorefiles().firstEntry().getValue();
        Path storedir = f.getPath().getParent();
        long seqid = f.getMaxSequenceId();
        HBaseConfiguration c = new HBaseConfiguration();
        FileSystem fs = FileSystem.get((Configuration)c);
        HFile.Writer w = StoreFile.getWriter(fs, storedir);
        StoreFile.appendMetadata(w, seqid + 1L);
        w.close();
        this.store.close();
        this.store = new Store(storedir.getParent().getParent(), this.store.getHRegion(), this.store.getFamily(), fs, null, c, null);
        System.out.println(this.store.getHRegionInfo().getEncodedName());
        TestStore.assertEquals((int)2, (int)this.store.getStorefilesCount());
        this.store.get(this.get, this.qualifiers, this.result);
        TestStore.assertEquals((int)1, (int)this.result.size());
    }

    public void testGet_FromMemStoreOnly() throws IOException {
        this.init(this.getName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf3, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf5, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, null));
        this.store.get(this.get, this.qualifiers, this.result);
        this.assertCheck();
    }

    public void testGet_FromFilesOnly() throws IOException {
        this.init(this.getName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, null));
        this.flush(1);
        this.store.add(new KeyValue(this.row, this.family, this.qf3, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, null));
        this.flush(2);
        this.store.add(new KeyValue(this.row, this.family, this.qf5, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, null));
        this.flush(3);
        this.store.get(this.get, this.qualifiers, this.result);
        Collections.sort(this.result, KeyValue.COMPARATOR);
        this.assertCheck();
    }

    public void testGet_FromMemStoreAndFiles() throws IOException {
        this.init(this.getName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, null));
        this.flush(1);
        this.store.add(new KeyValue(this.row, this.family, this.qf3, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, null));
        this.flush(2);
        this.store.add(new KeyValue(this.row, this.family, this.qf5, null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, null));
        this.store.get(this.get, this.qualifiers, this.result);
        Collections.sort(this.result, KeyValue.COMPARATOR);
        this.assertCheck();
    }

    private void flush(int storeFilessize) throws IOException {
        this.store.snapshot();
        TestStore.flushStore(this.store, this.id++);
        TestStore.assertEquals((int)storeFilessize, (int)this.store.getStorefiles().size());
        TestStore.assertEquals((int)0, (int)this.store.memstore.kvset.size());
    }

    private void assertCheck() {
        TestStore.assertEquals((int)this.expected.size(), (int)this.result.size());
        for (int i = 0; i < this.expected.size(); ++i) {
            TestStore.assertEquals((Object)this.expected.get(i), (Object)this.result.get(i));
        }
    }

    public void testIncrementColumnValue_ICVDuringFlush() throws IOException {
        this.init(this.getName());
        long oldValue = 1L;
        long newValue = 3L;
        this.store.add(new KeyValue(this.row, this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes(oldValue)));
        this.store.snapshot();
        this.store.add(new KeyValue(this.row, this.family, this.qf2, System.currentTimeMillis(), Bytes.toBytes(oldValue)));
        long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, newValue);
        TestStore.assertTrue((ret > 0L ? 1 : 0) != 0);
        TestStore.flushStore(this.store, this.id++);
        TestStore.assertEquals((int)1, (int)this.store.getStorefiles().size());
        TestStore.assertEquals((int)2, (int)this.store.memstore.kvset.size());
        Get get2 = new Get(this.row);
        get2.addColumn(this.family, this.qf1);
        get2.setMaxVersions();
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        TreeSet<byte[]> cols = new TreeSet<byte[]>();
        cols.add(this.qf1);
        this.store.get(get2, cols, results);
        TestStore.assertEquals((int)2, (int)results.size());
        long ts1 = ((KeyValue)results.get(0)).getTimestamp();
        long ts2 = ((KeyValue)results.get(1)).getTimestamp();
        TestStore.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        TestStore.assertEquals((long)newValue, (long)Bytes.toLong(((KeyValue)results.get(0)).getValue()));
        TestStore.assertEquals((long)oldValue, (long)Bytes.toLong(((KeyValue)results.get(1)).getValue()));
    }

    private static void flushStore(Store store, long id) throws IOException {
        StoreFlusher storeFlusher = store.getStoreFlusher(id);
        storeFlusher.prepare();
        storeFlusher.flushCache();
        storeFlusher.commit();
    }
}

