/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import agilejson.TOJSON;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.IRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.ISerializable;

public class DatabaseModel
extends AbstractModel {
    private Log LOG = LogFactory.getLog(DatabaseModel.class);

    public DatabaseModel(HBaseConfiguration conf, HBaseAdmin admin) {
        super.initialize(conf, admin);
    }

    public DatabaseMetadata getMetadata() throws HBaseRestException {
        return this.getDatabaseMetadata();
    }

    protected DatabaseMetadata getDatabaseMetadata() throws HBaseRestException {
        DatabaseMetadata databaseMetadata = null;
        try {
            databaseMetadata = new DatabaseMetadata(this.admin);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
        return databaseMetadata;
    }

    public static class DatabaseMetadata
    implements ISerializable {
        protected boolean master_running;
        protected HTableDescriptor[] tables;

        public DatabaseMetadata(HBaseAdmin a) throws IOException {
            this.master_running = a.isMasterRunning();
            this.tables = a.listTables();
        }

        @TOJSON(prefixLength=2)
        public boolean isMasterRunning() {
            return this.master_running;
        }

        @TOJSON
        public HTableDescriptor[] getTables() {
            return this.tables;
        }

        @Override
        public void restSerialize(IRestSerializer serializer) throws HBaseRestException {
            serializer.serializeDatabaseMetadata(this);
        }
    }
}

