/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.rest.DatabaseController;
import org.apache.hadoop.hbase.rest.RowController;
import org.apache.hadoop.hbase.rest.ScannerController;
import org.apache.hadoop.hbase.rest.Status;
import org.apache.hadoop.hbase.rest.TableController;
import org.apache.hadoop.hbase.rest.TimestampController;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.parser.HBaseRestParserFactory;
import org.apache.hadoop.hbase.rest.parser.IHBaseRestParser;
import org.apache.hadoop.hbase.rest.serializer.RestSerializerFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.InfoServer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class Dispatcher
extends HttpServlet {
    private static final long serialVersionUID = -8075335435797071569L;
    private static final Log LOG = LogFactory.getLog(Dispatcher.class);
    protected DatabaseController dbController;
    protected TableController tableController;
    protected RowController rowController;
    protected ScannerController scannercontroller;
    protected TimestampController tsController;
    private HBaseConfiguration conf = null;

    public void init() throws ServletException {
        super.init();
        this.conf = new HBaseConfiguration();
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(this.conf);
            this.createControllers();
            this.dbController.initialize(this.conf, admin);
            this.tableController.initialize(this.conf, admin);
            this.rowController.initialize(this.conf, admin);
            this.tsController.initialize(this.conf, admin);
            this.scannercontroller.initialize(this.conf, admin);
            LOG.debug((Object)"no errors in init.");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            throw new ServletException((Throwable)e);
        }
    }

    protected void createControllers() {
        this.dbController = new DatabaseController();
        this.tableController = new TableController();
        this.rowController = new RowController();
        this.tsController = new TimestampController();
        this.scannercontroller = new ScannerController();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Status s = this.createStatus(request, response);
            byte[][] pathSegments = this.getPathSegments(request);
            Map queryMap = request.getParameterMap();
            if (pathSegments.length == 0 || pathSegments[0].length <= 0) {
                this.dbController.get(s, pathSegments, queryMap);
            } else if (pathSegments.length >= 2 && pathSegments.length <= 3 && pathSegments[0].length > 0 && Bytes.toString(pathSegments[1]).toLowerCase().equals("row")) {
                this.rowController.get(s, pathSegments, queryMap);
            } else if (pathSegments.length == 4 && Bytes.toString(pathSegments[1]).toLowerCase().equals("row")) {
                this.tsController.get(s, pathSegments, queryMap);
            } else {
                this.tableController.get(s, pathSegments, queryMap);
            }
            LOG.debug((Object)"GET - No Error");
        }
        catch (HBaseRestException e) {
            LOG.debug((Object)("GET - Error: " + e.toString()));
            try {
                Status sError = this.createStatus(request, response);
                sError.setInternalError(e);
                sError.respond();
            }
            catch (HBaseRestException f) {
                response.sendError(500);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Status s = this.createStatus(request, response);
            byte[][] pathSegments = this.getPathSegments(request);
            Map queryMap = request.getParameterMap();
            byte[] input = this.readInputBuffer(request);
            IHBaseRestParser parser = this.getParser(request);
            if (pathSegments.length >= 0 && pathSegments.length <= 1 || Bytes.toString(pathSegments[1]).toLowerCase().equals("enable") || Bytes.toString(pathSegments[1]).toLowerCase().equals("disable")) {
                this.tableController.post(s, pathSegments, queryMap, input, parser);
            } else if (pathSegments.length >= 2 && pathSegments[0].length > 0) {
                if (Bytes.toString(pathSegments[1]).toLowerCase().equals("scanner")) {
                    this.scannercontroller.post(s, pathSegments, queryMap, input, parser);
                    return;
                }
                if (Bytes.toString(pathSegments[1]).toLowerCase().equals("row") && pathSegments.length >= 3) {
                    this.rowController.post(s, pathSegments, queryMap, input, parser);
                    return;
                }
            }
        }
        catch (HBaseRestException e) {
            LOG.debug((Object)("POST - Error: " + e.toString()));
            try {
                Status s_error = this.createStatus(request, response);
                s_error.setInternalError(e);
                s_error.respond();
            }
            catch (HBaseRestException f) {
                response.sendError(500);
            }
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            byte[][] pathSegments = this.getPathSegments(request);
            if (pathSegments.length == 0) {
                throw new HBaseRestException("method not supported");
            }
            if (pathSegments.length == 1 && pathSegments[0].length > 0) {
                Status s = this.createStatus(request, response);
                Map queryMap = request.getParameterMap();
                IHBaseRestParser parser = this.getParser(request);
                byte[] input = this.readInputBuffer(request);
                this.tableController.put(s, pathSegments, queryMap, input, parser);
            } else {
                this.doPost(request, response);
            }
        }
        catch (HBaseRestException e) {
            try {
                Status s_error = this.createStatus(request, response);
                s_error.setInternalError(e);
                s_error.respond();
            }
            catch (HBaseRestException f) {
                response.sendError(500);
            }
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Status s = this.createStatus(request, response);
            byte[][] pathSegments = this.getPathSegments(request);
            Map queryMap = request.getParameterMap();
            if (pathSegments.length == 0) {
                throw new HBaseRestException("method not supported");
            }
            if (pathSegments.length == 1 && pathSegments[0].length > 0) {
                this.tableController.delete(s, pathSegments, queryMap);
                return;
            }
            if (pathSegments.length >= 3 && pathSegments[0].length > 0) {
                if (Bytes.toString(pathSegments[1]).toLowerCase().equals("scanner") && pathSegments.length == 3 && pathSegments[2].length > 0) {
                    this.scannercontroller.delete(s, pathSegments, queryMap);
                    return;
                }
                if (Bytes.toString(pathSegments[1]).toLowerCase().equals("row") && pathSegments.length >= 3) {
                    this.rowController.delete(s, pathSegments, queryMap);
                    return;
                }
                if (pathSegments.length == 4) {
                    this.tsController.delete(s, pathSegments, queryMap);
                }
            }
        }
        catch (HBaseRestException e) {
            LOG.debug((Object)("POST - Error: " + e.toString()));
            try {
                Status s_error = this.createStatus(request, response);
                s_error.setInternalError(e);
                s_error.respond();
            }
            catch (HBaseRestException f) {
                response.sendError(500);
            }
        }
    }

    protected byte[][] getPathSegments(HttpServletRequest request) {
        int context_len = request.getContextPath().length() + 1;
        Object pathSegments = Bytes.toByteArrays(request.getRequestURI().substring(context_len).split("/"));
        byte[] apiAsBytes = "api".getBytes();
        if (Arrays.equals(apiAsBytes, pathSegments[0])) {
            byte[][] newPathSegments = new byte[((byte[][])pathSegments).length - 1][];
            for (int i = 0; i < newPathSegments.length; ++i) {
                newPathSegments[i] = pathSegments[i + 1];
            }
            pathSegments = newPathSegments;
        }
        return pathSegments;
    }

    protected byte[] readInputBuffer(HttpServletRequest request) throws HBaseRestException {
        try {
            char[] c;
            int n;
            String resultant = "";
            BufferedReader r = request.getReader();
            int defaultmaxlength = 0xA00000;
            int maxLength = this.conf == null ? defaultmaxlength : this.conf.getInt("hbase.rest.input.limit", defaultmaxlength);
            int bufferLength = 640;
            if (!r.ready()) {
                Thread.sleep(1000L);
                if (!r.ready()) {
                    return new byte[0];
                }
            }
            while ((n = r.read(c = new char[bufferLength], 0, bufferLength)) != -1) {
                if ((resultant = resultant + new String(c, 0, n)).length() <= maxLength) continue;
                resultant = resultant.substring(0, maxLength);
                break;
            }
            return Bytes.toBytes(resultant.trim());
        }
        catch (Exception e) {
            throw new HBaseRestException(e);
        }
    }

    protected IHBaseRestParser getParser(HttpServletRequest request) {
        return HBaseRestParserFactory.getParser(ContentType.getContentType(request.getHeader("content-type")));
    }

    protected Status createStatus(HttpServletRequest request, HttpServletResponse response) throws HBaseRestException {
        return new Status(response, RestSerializerFactory.getSerializer(request, response), this.getPathSegments(request));
    }

    protected static void printUsageAndExit() {
        Dispatcher.printUsageAndExit(null);
    }

    protected static void printUsageAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.out.println("Usage: java org.apache.hadoop.hbase.rest.Dispatcher --help | [--port=PORT] [--bind=ADDR] start");
        System.out.println("Arguments:");
        System.out.println(" start Start REST server");
        System.out.println(" stop  Stop REST server");
        System.out.println("Options:");
        System.out.println(" port  Port to listen on. Default: 60050.");
        System.out.println(" bind  Address to bind on. Default: 0.0.0.0.");
        System.out.println(" max-num-threads  The maximum number of threads for Jetty to run. Defaults to 256.");
        System.out.println(" help  Print this message and exit.");
        System.exit(0);
    }

    protected static void doMain(String[] args) throws Exception {
        if (args.length < 1) {
            Dispatcher.printUsageAndExit();
        }
        int port = 60050;
        String bindAddress = "0.0.0.0";
        int numThreads = 256;
        String addressArgKey = "--bind=";
        String portArgKey = "--port=";
        String numThreadsKey = "--max-num-threads=";
        for (String cmd : args) {
            if (cmd.startsWith("--bind=")) {
                bindAddress = cmd.substring("--bind=".length());
                continue;
            }
            if (cmd.startsWith("--port=")) {
                port = Integer.parseInt(cmd.substring("--port=".length()));
                continue;
            }
            if (cmd.equals("--help") || cmd.equals("-h")) {
                Dispatcher.printUsageAndExit();
            } else {
                if (cmd.equals("start")) continue;
                if (cmd.equals("stop")) {
                    Dispatcher.printUsageAndExit("To shutdown the REST server run bin/hbase-daemon.sh stop rest or send a kill signal to the REST server pid");
                } else if (cmd.startsWith("--max-num-threads=")) {
                    numThreads = Integer.parseInt(cmd.substring("--max-num-threads=".length()));
                    continue;
                }
            }
            Dispatcher.printUsageAndExit();
        }
        Server webServer = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        connector.setHost(bindAddress);
        QueuedThreadPool pool = new QueuedThreadPool();
        pool.setMaxThreads(numThreads);
        webServer.addConnector((Connector)connector);
        webServer.setThreadPool((ThreadPool)pool);
        WebAppContext wac = new WebAppContext();
        wac.setContextPath("/");
        wac.setWar(InfoServer.getWebAppDir("rest"));
        NCSARequestLog ncsa = new NCSARequestLog();
        ncsa.setLogLatency(true);
        RequestLogHandler rlh = new RequestLogHandler();
        rlh.setRequestLog((RequestLog)ncsa);
        rlh.setHandler((Handler)wac);
        webServer.addHandler((Handler)rlh);
        webServer.start();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Starting restServer");
        Dispatcher.doMain(args);
    }

    public static enum ContentType {
        XML("text/xml"),
        JSON("application/json"),
        PLAIN("text/plain"),
        MIME("multipart/related"),
        NOT_ACCEPTABLE("");

        private final String type;

        private ContentType(String t) {
            this.type = t;
        }

        public String toString() {
            return this.type;
        }

        public static ContentType getContentType(String t) {
            if (t == null || t.equals("*/*")) {
                return XML;
            }
            String lowerCased = t.toLowerCase();
            ContentType[] values = ContentType.values();
            ContentType result = null;
            for (int i = 0; i < values.length; ++i) {
                if (!lowerCased.startsWith(values[i].type)) continue;
                result = values[i];
                break;
            }
            return result == null ? NOT_ACCEPTABLE : result;
        }
    }
}

