/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import agilejson.TOJSON;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.rest.descriptors.ScannerIdentifier;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.IRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.ISerializable;
import org.apache.hadoop.hbase.util.Bytes;

public class Status {
    private Log LOG = LogFactory.getLog(Status.class);
    public static final HashMap<Integer, String> statNames = new HashMap();
    protected int statusCode;
    protected HttpServletResponse response;
    protected Object message;
    protected IRestSerializer serializer;
    protected byte[][] pathSegments;

    public int getStatusCode() {
        return this.statusCode;
    }

    @TOJSON
    public Object getMessage() {
        return this.message;
    }

    public Status(HttpServletResponse r, IRestSerializer serializer, byte[][] bs) {
        this.setOK();
        this.response = r;
        this.serializer = serializer;
        this.pathSegments = bs;
    }

    public void setOK() {
        this.statusCode = 200;
        this.message = new StatusMessage(200, false, "success");
    }

    public void setOK(Object message) {
        this.statusCode = 200;
        this.message = message;
    }

    public void setAccepted() {
        this.statusCode = 202;
        this.message = new StatusMessage(202, false, "success");
    }

    public void setExists(boolean error) {
        this.statusCode = 409;
        this.message = new StatusMessage(this.statusCode, error, "table already exists");
    }

    public void setCreated() {
        this.statusCode = 201;
        this.setOK();
    }

    public void setScannerCreated(ScannerIdentifier scannerIdentifier) {
        this.statusCode = 200;
        this.message = scannerIdentifier;
        this.response.addHeader("Location", "/" + Bytes.toString(this.pathSegments[0]) + "/scanner/" + scannerIdentifier.getId());
    }

    public void setInternalError(Exception e) {
        this.statusCode = 500;
        this.message = new StatusMessage(this.statusCode, true, e);
    }

    public void setNoQueryResults() {
        this.statusCode = 404;
        this.message = new StatusMessage(this.statusCode, true, "no query results");
    }

    public void setConflict(Object message) {
        this.statusCode = 409;
        this.message = new StatusMessage(this.statusCode, true, message);
    }

    public void setNotFound(Object message) {
        this.statusCode = 404;
        this.message = new StatusMessage(this.statusCode, true, message);
    }

    public void setBadRequest(Object message) {
        this.statusCode = 400;
        this.message = new StatusMessage(this.statusCode, true, message);
    }

    public void setNotFound() {
        this.setNotFound("Unable to find requested URI");
    }

    public void setMethodNotImplemented() {
        this.statusCode = 405;
        this.message = new StatusMessage(this.statusCode, true, "method not implemented");
    }

    public void setInvalidURI() {
        this.setInvalidURI("Invalid URI");
    }

    public void setInvalidURI(Object message) {
        this.statusCode = 400;
        this.message = new StatusMessage(this.statusCode, true, message);
    }

    public void setUnsupportedMediaType(Object message) {
        this.statusCode = 415;
        this.message = new StatusMessage(this.statusCode, true, message);
    }

    public void setGone() {
        this.statusCode = 410;
        this.message = new StatusMessage(this.statusCode, true, "item no longer available");
    }

    public void respond() throws HBaseRestException {
        this.response.setStatus(this.statusCode);
        this.serializer.writeOutput(this.message);
    }

    static {
        statNames.put(100, "continue");
        statNames.put(101, "switching protocols");
        statNames.put(200, "ok");
        statNames.put(201, "created");
        statNames.put(202, "accepted");
        statNames.put(203, "non-authoritative information");
        statNames.put(204, "no content");
        statNames.put(205, "reset content");
        statNames.put(206, "partial content");
        statNames.put(300, "multiple choices");
        statNames.put(301, "moved permanently");
        statNames.put(302, "moved temporarily");
        statNames.put(302, "found");
        statNames.put(303, "see other");
        statNames.put(304, "not modified");
        statNames.put(305, "use proxy");
        statNames.put(307, "temporary redirect");
        statNames.put(400, "bad request");
        statNames.put(401, "unauthorized");
        statNames.put(403, "forbidden");
        statNames.put(404, "not found");
        statNames.put(405, "method not allowed");
        statNames.put(406, "not acceptable");
        statNames.put(407, "proxy authentication required");
        statNames.put(408, "request timeout");
        statNames.put(409, "conflict");
        statNames.put(410, "gone");
        statNames.put(411, "length required");
        statNames.put(412, "precondition failed");
        statNames.put(413, "request entity too large");
        statNames.put(414, "request uri too long");
        statNames.put(415, "unsupported media type");
        statNames.put(416, "requested range not satisfiable");
        statNames.put(417, "expectation failed");
        statNames.put(500, "internal server error");
        statNames.put(501, "not implemented");
        statNames.put(502, "bad gateway");
        statNames.put(503, "service unavailable");
        statNames.put(504, "gateway timeout");
        statNames.put(505, "http version not supported");
    }

    public static class StatusMessage
    implements ISerializable {
        int statusCode;
        boolean error;
        Object reason;

        public StatusMessage(int statusCode, boolean error, Object o) {
            this.statusCode = statusCode;
            this.error = error;
            this.reason = o;
        }

        @TOJSON
        public int getStatusCode() {
            return this.statusCode;
        }

        @TOJSON
        public boolean getError() {
            return this.error;
        }

        @TOJSON
        public Object getMessage() {
            return this.reason;
        }

        @Override
        public void restSerialize(IRestSerializer serializer) throws HBaseRestException {
            serializer.serializeStatusMessage(this);
        }
    }
}

