/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.rest.AbstractController;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.Status;
import org.apache.hadoop.hbase.rest.TableModel;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.parser.IHBaseRestParser;
import org.apache.hadoop.hbase.util.Bytes;

public class TableController
extends AbstractController {
    private Log LOG = LogFactory.getLog(TableController.class);

    protected TableModel getModel() {
        return (TableModel)this.model;
    }

    @Override
    protected AbstractModel generateModel(HBaseConfiguration conf, HBaseAdmin admin) {
        return new TableModel(conf, admin);
    }

    @Override
    public void get(Status s, byte[][] pathSegments, Map<String, String[]> queryMap) throws HBaseRestException {
        TableModel innerModel = this.getModel();
        byte[] tableName = pathSegments[0];
        if (pathSegments.length < 2) {
            s.setOK(innerModel.getTableMetadata(Bytes.toString(tableName)));
        } else if (Bytes.toString(pathSegments[1]).toLowerCase().equals("regions")) {
            s.setOK(innerModel.getTableRegions(Bytes.toString(tableName)));
        } else {
            s.setBadRequest("unknown query.");
        }
        s.respond();
    }

    @Override
    public void post(Status s, byte[][] pathSegments, Map<String, String[]> queryMap, byte[] input, IHBaseRestParser parser) throws HBaseRestException {
        TableModel innerModel = this.getModel();
        if (pathSegments.length == 0) {
            if (input.length == 0) {
                s.setBadRequest("no data send with post request");
            } else {
                HTableDescriptor htd = parser.getTableDescriptor(input);
                if (!innerModel.post(htd.getName(), htd)) {
                    s.setConflict("table already exists");
                } else {
                    s.setCreated();
                }
            }
        } else if (Bytes.toString(pathSegments[1]).toLowerCase().equals("enable")) {
            byte[] tableName = pathSegments[0];
            innerModel.enableTable(tableName);
            s.setAccepted();
        } else if (Bytes.toString(pathSegments[1]).toLowerCase().equals("disable")) {
            byte[] tableName = pathSegments[0];
            innerModel.disableTable(tableName);
            s.setAccepted();
        } else {
            s.setBadRequest("Unknown Query.");
        }
        s.respond();
    }

    @Override
    public void put(Status s, byte[][] pathSegments, Map<String, String[]> queryMap, byte[] input, IHBaseRestParser parser) throws HBaseRestException {
        if (pathSegments.length != 1) {
            s.setBadRequest("must specifify the name of the table");
            s.respond();
        } else if (queryMap.size() > 0) {
            s.setBadRequest("no query string should be specified when updating a table");
            s.respond();
        } else {
            ArrayList<HColumnDescriptor> newColumns = parser.getColumnDescriptors(input);
            byte[] tableName = pathSegments[0];
            this.getModel().updateTable(Bytes.toString(tableName), newColumns);
            s.setOK();
            s.respond();
        }
    }

    @Override
    public void delete(Status s, byte[][] pathSegments, Map<String, String[]> queryMap) throws HBaseRestException {
        TableModel innerModel = this.getModel();
        byte[] tableName = pathSegments[0];
        if (pathSegments.length == 1) {
            if (!innerModel.delete(tableName)) {
                s.setBadRequest("table does not exist");
            } else {
                s.setAccepted();
            }
            s.respond();
        }
    }
}

