/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;

public class TimestampModel
extends AbstractModel {
    private Log LOG = LogFactory.getLog(TimestampModel.class);

    public TimestampModel(HBaseConfiguration conf, HBaseAdmin admin) {
        super.initialize(conf, admin);
    }

    public void delete(byte[] tableName, Delete delete) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            table.delete(delete);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    @Deprecated
    public void delete(byte[] tableName, byte[] rowName, long timestamp) throws HBaseRestException {
        Delete delete = new Delete(rowName, timestamp, null);
        this.delete(tableName, delete);
    }

    @Deprecated
    public void delete(byte[] tableName, byte[] rowName, byte[][] columns, long timestamp) throws HBaseRestException {
        Delete delete = new Delete(rowName, timestamp, null);
        for (byte[] column : columns) {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            delete.deleteColumn(famAndQf[0], famAndQf[1]);
        }
        this.delete(tableName, delete);
    }

    public Result get(byte[] tableName, Get get2) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            return table.get(get2);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    @Deprecated
    public Cell get(byte[] tableName, byte[] rowName, byte[] columnName, long timestamp) throws HBaseRestException {
        Get get2 = new Get(rowName);
        byte[][] famAndQf = KeyValue.parseColumn(columnName);
        get2.addColumn(famAndQf[0], famAndQf[1]);
        get2.setTimeStamp(timestamp);
        return this.get(tableName, get2).getCellValue(famAndQf[0], famAndQf[1]);
    }

    @Deprecated
    public Cell[] get(byte[] tableName, byte[] rowName, byte[] columnName, long timestamp, int numVersions) throws IOException, HBaseRestException {
        Get get2 = new Get(rowName);
        byte[][] famAndQf = KeyValue.parseColumn(columnName);
        get2.addColumn(famAndQf[0], famAndQf[1]);
        get2.setTimeStamp(timestamp);
        get2.setMaxVersions(numVersions);
        Result result = this.get(tableName, get2);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (KeyValue kv : result.sorted()) {
            cells.add(new Cell(kv.getValue(), kv.getTimestamp()));
        }
        return cells.toArray(new Cell[0]);
    }

    @Deprecated
    public RowResult get(byte[] tableName, byte[] rowName, byte[][] columns, long timestamp) throws HBaseRestException {
        Get get2 = new Get(rowName);
        for (byte[] column : columns) {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            get2.addColumn(famAndQf[0], famAndQf[1]);
        }
        get2.setTimeStamp(timestamp);
        return this.get(tableName, get2).getRowResult();
    }

    public RowResult get(byte[] tableName, byte[] rowName, long timestamp) throws HBaseRestException {
        Get get2 = new Get(rowName);
        get2.setTimeStamp(timestamp);
        return this.get(tableName, get2).getRowResult();
    }

    public void post(byte[] tableName, byte[] rowName, byte[] columnName, long timestamp, byte[] value) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            Put put = new Put(rowName);
            put.setTimeStamp(timestamp);
            byte[][] famAndQf = KeyValue.parseColumn(columnName);
            put.add(famAndQf[0], famAndQf[1], value);
            table.put(put);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }
}

