/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.filter;

import org.apache.hadoop.hbase.filter.ColumnValueFilter;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.filter.FilterFactory;
import org.apache.hadoop.hbase.rest.filter.FilterFactoryConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class ColumnValueFilterFactory
implements FilterFactory {
    @Override
    public RowFilterInterface getFilterFromJSON(String args) throws HBaseRestException {
        JSONObject innerJSON;
        try {
            innerJSON = new JSONObject(args);
        }
        catch (JSONException e) {
            throw new HBaseRestException((Exception)((Object)e));
        }
        String columnName = innerJSON.optString("column_name");
        if (columnName == null) {
            throw new FilterFactoryConstants.MalformedFilterException();
        }
        String compareOp = innerJSON.optString("compare_op");
        if (compareOp == null) {
            throw new FilterFactoryConstants.MalformedFilterException();
        }
        String value = innerJSON.optString("value");
        if (value == null) {
            throw new FilterFactoryConstants.MalformedFilterException();
        }
        return new ColumnValueFilter(columnName.getBytes(), ColumnValueFilter.CompareOp.valueOf(compareOp), value.getBytes());
    }
}

