/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.parser;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.rest.descriptors.RowUpdateDescriptor;
import org.apache.hadoop.hbase.rest.descriptors.ScannerDescriptor;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.parser.IHBaseRestParser;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRestParser
implements IHBaseRestParser {
    @Override
    public HTableDescriptor getTableDescriptor(byte[] input) throws HBaseRestException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = null;
        Document doc = null;
        HTableDescriptor htd = null;
        try {
            builder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(input);
            doc = builder.parse(is);
        }
        catch (Exception e) {
            throw new HBaseRestException(e);
        }
        try {
            Node name_node = doc.getElementsByTagName("name").item(0);
            String table_name = name_node.getFirstChild().getNodeValue();
            htd = new HTableDescriptor(table_name);
            NodeList columnfamily_nodes = doc.getElementsByTagName("columnfamily");
            for (int i = 0; i < columnfamily_nodes.getLength(); ++i) {
                Element columnfamily = (Element)columnfamily_nodes.item(i);
                htd.addFamily(this.getColumnDescriptor(columnfamily));
            }
        }
        catch (Exception e) {
            throw new HBaseRestException(e);
        }
        return htd;
    }

    public HColumnDescriptor getColumnDescriptor(Element columnfamily) {
        return this.getColumnDescriptor(columnfamily, null);
    }

    private HColumnDescriptor getColumnDescriptor(Element columnfamily, HTableDescriptor currentTDesp) {
        NodeList bloomfilter_list;
        NodeList ttl_list;
        NodeList block_cache_list;
        NodeList in_memory_list;
        NodeList compression_list;
        NodeList max_versions_list;
        HColumnDescriptor currentCDesp;
        Node name_node = columnfamily.getElementsByTagName("name").item(0);
        String colname = this.makeColumnName(name_node.getFirstChild().getNodeValue());
        int max_versions = 3;
        String compression = HColumnDescriptor.DEFAULT_COMPRESSION;
        boolean in_memory = false;
        boolean block_cache = true;
        int ttl = Integer.MAX_VALUE;
        boolean bloomfilter = false;
        if (currentTDesp != null && (currentCDesp = currentTDesp.getFamily(Bytes.toBytes(colname))) != null) {
            max_versions = currentCDesp.getMaxVersions();
            in_memory = currentCDesp.isInMemory();
            block_cache = currentCDesp.isBlockCacheEnabled();
            ttl = currentCDesp.getTimeToLive();
            bloomfilter = currentCDesp.isBloomfilter();
        }
        if ((max_versions_list = columnfamily.getElementsByTagName("max-versions")).getLength() > 0) {
            max_versions = Integer.parseInt(max_versions_list.item(0).getFirstChild().getNodeValue());
        }
        if ((compression_list = columnfamily.getElementsByTagName("compression")).getLength() > 0) {
            compression = compression_list.item(0).getFirstChild().getNodeValue().toUpperCase();
        }
        if ((in_memory_list = columnfamily.getElementsByTagName("in-memory")).getLength() > 0) {
            in_memory = Boolean.valueOf(in_memory_list.item(0).getFirstChild().getNodeValue());
        }
        if ((block_cache_list = columnfamily.getElementsByTagName("block-cache")).getLength() > 0) {
            block_cache = Boolean.valueOf(block_cache_list.item(0).getFirstChild().getNodeValue());
        }
        if ((ttl_list = columnfamily.getElementsByTagName("time-to-live")).getLength() > 0) {
            ttl = Integer.valueOf(ttl_list.item(0).getFirstChild().getNodeValue());
        }
        if ((bloomfilter_list = columnfamily.getElementsByTagName("bloomfilter")).getLength() > 0) {
            bloomfilter = Boolean.valueOf(bloomfilter_list.item(0).getFirstChild().getNodeValue());
        }
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes(colname), max_versions, compression, in_memory, block_cache, ttl, bloomfilter);
        NodeList metadataList = columnfamily.getElementsByTagName("metadata");
        for (int i = 0; i < metadataList.getLength(); ++i) {
            Element metadataColumn = (Element)metadataList.item(i);
            Node mname_node = metadataColumn.getElementsByTagName("name").item(0);
            String mname = mname_node.getFirstChild().getNodeValue();
            Node mvalue_node = metadataColumn.getElementsByTagName("value").item(0);
            String mvalue = mvalue_node.getFirstChild().getNodeValue();
            hcd.setValue(mname, mvalue);
        }
        return hcd;
    }

    protected String makeColumnName(String column) {
        String returnColumn = column;
        if (column.indexOf(58) == -1) {
            returnColumn = returnColumn + ':';
        }
        return returnColumn;
    }

    @Override
    public ArrayList<HColumnDescriptor> getColumnDescriptors(byte[] input) throws HBaseRestException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = null;
        Document doc = null;
        ArrayList<HColumnDescriptor> columns = new ArrayList<HColumnDescriptor>();
        try {
            builder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(input);
            doc = builder.parse(is);
        }
        catch (Exception e) {
            throw new HBaseRestException(e);
        }
        NodeList columnfamily_nodes = doc.getElementsByTagName("columnfamily");
        for (int i = 0; i < columnfamily_nodes.getLength(); ++i) {
            Element columnfamily = (Element)columnfamily_nodes.item(i);
            columns.add(this.getColumnDescriptor(columnfamily));
        }
        return columns;
    }

    @Override
    public ScannerDescriptor getScannerDescriptor(byte[] input) throws HBaseRestException {
        return null;
    }

    @Override
    public RowUpdateDescriptor getRowUpdateDescriptor(byte[] input, byte[][] pathSegments) throws HBaseRestException {
        RowUpdateDescriptor rud = new RowUpdateDescriptor();
        rud.setTableName(Bytes.toString(pathSegments[0]));
        rud.setRowName(Bytes.toString(pathSegments[2]));
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(input);
            doc = builder.parse(is);
        }
        catch (Exception e) {
            throw new HBaseRestException(e.getMessage(), e);
        }
        NodeList cell_nodes = doc.getElementsByTagName("column");
        System.out.println("cell_nodes.length: " + cell_nodes.getLength());
        for (int i = 0; i < cell_nodes.getLength(); ++i) {
            NodeList item1;
            String columnName = null;
            byte[] value = null;
            Element cell = (Element)cell_nodes.item(i);
            NodeList item = cell.getElementsByTagName("name");
            if (item.getLength() > 0) {
                columnName = item.item(0).getFirstChild().getNodeValue();
            }
            if ((item1 = cell.getElementsByTagName("value")).getLength() > 0) {
                value = Base64.decode(item1.item(0).getFirstChild().getNodeValue());
            }
            if (columnName == null || value == null) continue;
            rud.getColVals().put(columnName.getBytes(), value);
        }
        return rud;
    }
}

