/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.serializer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.rest.Dispatcher;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.AbstractRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.JSONSerializer;
import org.apache.hadoop.hbase.rest.serializer.SimpleXMLSerializer;

public class RestSerializerFactory {
    public static AbstractRestSerializer getSerializer(HttpServletRequest request, HttpServletResponse response) throws HBaseRestException {
        Dispatcher.ContentType ct = Dispatcher.ContentType.getContentType(request.getHeader("accept"));
        AbstractRestSerializer serializer = null;
        switch (ct) {
            case XML: {
                serializer = new SimpleXMLSerializer(response);
                break;
            }
            case JSON: {
                serializer = new JSONSerializer(response);
                break;
            }
            default: {
                serializer = new SimpleXMLSerializer(response);
            }
        }
        return serializer;
    }
}

