/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.generated.BatchMutation;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.Bytes;

public class TestThriftServer
extends HBaseClusterTestCase {
    private static byte[] tableAname = Bytes.toBytes("tableA");
    private static byte[] tableBname = Bytes.toBytes("tableB");
    private static byte[] columnAname = Bytes.toBytes("columnA:");
    private static byte[] columnBname = Bytes.toBytes("columnB:");
    private static byte[] rowAname = Bytes.toBytes("rowA");
    private static byte[] rowBname = Bytes.toBytes("rowB");
    private static byte[] valueAname = Bytes.toBytes("valueA");
    private static byte[] valueBname = Bytes.toBytes("valueB");
    private static byte[] valueCname = Bytes.toBytes("valueC");
    private static byte[] valueDname = Bytes.toBytes("valueD");

    public void testAll() throws Exception {
        this.doTestTableCreateDrop();
        this.doTestTableMutations();
        this.doTestTableTimestampsAndColumns();
        this.doTestTableScanners();
    }

    public void doTestTableCreateDrop() throws Exception {
        ThriftServer.HBaseHandler handler = new ThriftServer.HBaseHandler();
        TestThriftServer.assertEquals((int)handler.getTableNames().size(), (int)0);
        handler.createTable(tableAname, this.getColumnDescriptors());
        TestThriftServer.assertEquals((int)handler.getTableNames().size(), (int)1);
        TestThriftServer.assertEquals((int)handler.getColumnDescriptors(tableAname).size(), (int)2);
        TestThriftServer.assertTrue((boolean)handler.isTableEnabled(tableAname));
        handler.createTable(tableBname, new ArrayList<ColumnDescriptor>());
        TestThriftServer.assertEquals((int)handler.getTableNames().size(), (int)2);
        handler.disableTable(tableBname);
        TestThriftServer.assertFalse((boolean)handler.isTableEnabled(tableBname));
        handler.deleteTable(tableBname);
        TestThriftServer.assertEquals((int)handler.getTableNames().size(), (int)1);
        handler.disableTable(tableAname);
        TestThriftServer.assertFalse((boolean)handler.isTableEnabled(tableAname));
        handler.enableTable(tableAname);
        TestThriftServer.assertTrue((boolean)handler.isTableEnabled(tableAname));
        handler.disableTable(tableAname);
        handler.deleteTable(tableAname);
    }

    public void doTestTableMutations() throws Exception {
        ThriftServer.HBaseHandler handler = new ThriftServer.HBaseHandler();
        handler.createTable(tableAname, this.getColumnDescriptors());
        handler.mutateRow(tableAname, rowAname, this.getMutations());
        TestThriftServer.assertTrue((boolean)Bytes.equals(valueAname, handler.get((byte[])TestThriftServer.tableAname, (byte[])TestThriftServer.rowAname, (byte[])TestThriftServer.columnAname).get((int)0).value));
        TRowResult rowResult1 = handler.getRow(tableAname, rowAname).get(0);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowAname, rowResult1.row));
        TestThriftServer.assertTrue((boolean)Bytes.equals(valueBname, rowResult1.columns.get((Object)TestThriftServer.columnBname).value));
        handler.mutateRows(tableAname, this.getBatchMutations());
        List<TCell> cells = handler.get(tableAname, rowAname, columnAname);
        TestThriftServer.assertFalse((cells.size() > 0 ? 1 : 0) != 0);
        TestThriftServer.assertTrue((boolean)Bytes.equals(valueCname, handler.get((byte[])TestThriftServer.tableAname, (byte[])TestThriftServer.rowAname, (byte[])TestThriftServer.columnBname).get((int)0).value));
        List<TCell> versions = handler.getVer(tableAname, rowAname, columnBname, 3);
        TestThriftServer.assertTrue((boolean)Bytes.equals(valueCname, versions.get((int)0).value));
        TestThriftServer.assertTrue((boolean)Bytes.equals(valueBname, versions.get((int)1).value));
        TRowResult rowResult2 = handler.getRow(tableAname, rowBname).get(0);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowBname, rowResult2.row));
        TestThriftServer.assertTrue((boolean)Bytes.equals(valueCname, rowResult2.columns.get((Object)TestThriftServer.columnAname).value));
        TestThriftServer.assertTrue((boolean)Bytes.equals(valueDname, rowResult2.columns.get((Object)TestThriftServer.columnBname).value));
        handler.deleteAll(tableAname, rowAname, columnBname);
        handler.deleteAllRow(tableAname, rowBname);
        int size = handler.get(tableAname, rowAname, columnBname).size();
        TestThriftServer.assertEquals((int)0, (int)size);
        size = handler.getRow(tableAname, rowBname).size();
        TestThriftServer.assertEquals((int)0, (int)size);
        handler.disableTable(tableAname);
        handler.deleteTable(tableAname);
    }

    public void doTestTableTimestampsAndColumns() throws Exception {
        ThriftServer.HBaseHandler handler = new ThriftServer.HBaseHandler();
        handler.createTable(tableAname, this.getColumnDescriptors());
        long time1 = System.currentTimeMillis();
        handler.mutateRowTs(tableAname, rowAname, this.getMutations(), time1);
        Thread.sleep(1000L);
        long time2 = System.currentTimeMillis();
        handler.mutateRowsTs(tableAname, this.getBatchMutations(), time2);
        handler.mutateRowTs(tableAname, rowBname, this.getMutations(), time2);
        TestThriftServer.assertEquals((int)2, (int)handler.getVerTs(tableAname, rowAname, columnBname, time2 += 2L, 3).size());
        TestThriftServer.assertEquals((int)1, (int)handler.getVerTs(tableAname, rowAname, columnBname, ++time1, 3).size());
        TRowResult rowResult1 = handler.getRowTs(tableAname, rowAname, time1).get(0);
        TRowResult rowResult2 = handler.getRowTs(tableAname, rowAname, time2).get(0);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult1.columns.get((Object)TestThriftServer.columnBname).value, valueBname));
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult2.columns.get((Object)TestThriftServer.columnBname).value, valueCname));
        TestThriftServer.assertFalse((boolean)rowResult2.columns.containsKey(columnAname));
        ArrayList<byte[]> columns = new ArrayList<byte[]>();
        columns.add(columnBname);
        rowResult1 = handler.getRowWithColumns(tableAname, rowAname, columns).get(0);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult1.columns.get((Object)TestThriftServer.columnBname).value, valueCname));
        TestThriftServer.assertFalse((boolean)rowResult1.columns.containsKey(columnAname));
        rowResult1 = handler.getRowWithColumnsTs(tableAname, rowAname, columns, time1).get(0);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult1.columns.get((Object)TestThriftServer.columnBname).value, valueBname));
        TestThriftServer.assertFalse((boolean)rowResult1.columns.containsKey(columnAname));
        handler.deleteAllTs(tableAname, rowAname, columnBname, time1);
        handler.deleteAllRowTs(tableAname, rowBname, time2);
        int size = handler.getVerTs(tableAname, rowAname, columnBname, time1, 3).size();
        TestThriftServer.assertEquals((int)0, (int)size);
        size = handler.getVerTs(tableAname, rowAname, columnBname, time2, 3).size();
        TestThriftServer.assertEquals((int)1, (int)size);
        TestThriftServer.assertTrue((boolean)Bytes.equals(handler.get((byte[])TestThriftServer.tableAname, (byte[])TestThriftServer.rowAname, (byte[])TestThriftServer.columnBname).get((int)0).value, valueCname));
        TestThriftServer.assertEquals((int)0, (int)handler.getRow(tableAname, rowBname).size());
        handler.disableTable(tableAname);
        handler.deleteTable(tableAname);
    }

    public void doTestTableScanners() throws Exception {
        ThriftServer.HBaseHandler handler = new ThriftServer.HBaseHandler();
        handler.createTable(tableAname, this.getColumnDescriptors());
        long time1 = System.currentTimeMillis();
        handler.mutateRowTs(tableAname, rowAname, this.getMutations(), time1);
        Thread.sleep(1000L);
        long time2 = System.currentTimeMillis();
        handler.mutateRowsTs(tableAname, this.getBatchMutations(), time2);
        ++time1;
        ++time2;
        int scanner1 = handler.scannerOpen(tableAname, rowAname, this.getColumnList(true, true));
        TRowResult rowResult1a = handler.scannerGet(scanner1).get(0);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult1a.row, rowAname));
        TestThriftServer.assertEquals((int)rowResult1a.columns.size(), (int)1);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult1a.columns.get((Object)TestThriftServer.columnBname).value, valueCname));
        TRowResult rowResult1b = handler.scannerGet(scanner1).get(0);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult1b.row, rowBname));
        TestThriftServer.assertEquals((int)rowResult1b.columns.size(), (int)2);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult1b.columns.get((Object)TestThriftServer.columnAname).value, valueCname));
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult1b.columns.get((Object)TestThriftServer.columnBname).value, valueDname));
        this.closeScanner(scanner1, handler);
        int scanner2 = handler.scannerOpenTs(tableAname, rowAname, this.getColumnList(true, true), time1);
        TRowResult rowResult2a = handler.scannerGet(scanner2).get(0);
        TestThriftServer.assertEquals((int)rowResult2a.columns.size(), (int)1);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult2a.columns.get((Object)TestThriftServer.columnBname).value, valueBname));
        this.closeScanner(scanner2, handler);
        int scanner3 = handler.scannerOpenWithStop(tableAname, rowAname, rowBname, this.getColumnList(true, false));
        this.closeScanner(scanner3, handler);
        int scanner4 = handler.scannerOpenWithStopTs(tableAname, rowAname, rowBname, this.getColumnList(false, true), time1);
        TRowResult rowResult4a = handler.scannerGet(scanner4).get(0);
        TestThriftServer.assertEquals((int)rowResult4a.columns.size(), (int)1);
        TestThriftServer.assertTrue((boolean)Bytes.equals(rowResult4a.columns.get((Object)TestThriftServer.columnBname).value, valueBname));
        handler.disableTable(tableAname);
        handler.deleteTable(tableAname);
    }

    private List<ColumnDescriptor> getColumnDescriptors() {
        ArrayList<ColumnDescriptor> cDescriptors = new ArrayList<ColumnDescriptor>();
        ColumnDescriptor cDescA = new ColumnDescriptor();
        cDescA.name = columnAname;
        cDescriptors.add(cDescA);
        ColumnDescriptor cDescB = new ColumnDescriptor(columnBname, 2, "NONE", false, "NONE", 0, 0, false, -1);
        cDescriptors.add(cDescB);
        return cDescriptors;
    }

    private List<byte[]> getColumnList(boolean includeA, boolean includeB) {
        ArrayList<byte[]> columnList = new ArrayList<byte[]>();
        if (includeA) {
            columnList.add(columnAname);
        }
        if (includeB) {
            columnList.add(columnBname);
        }
        return columnList;
    }

    private List<Mutation> getMutations() {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        mutations.add(new Mutation(false, columnAname, valueAname));
        mutations.add(new Mutation(false, columnBname, valueBname));
        return mutations;
    }

    private List<BatchMutation> getBatchMutations() {
        ArrayList<BatchMutation> batchMutations = new ArrayList<BatchMutation>();
        ArrayList<Mutation> rowAmutations = new ArrayList<Mutation>();
        rowAmutations.add(new Mutation(true, columnAname, null));
        batchMutations.add(new BatchMutation(rowAname, rowAmutations));
        rowAmutations = new ArrayList();
        rowAmutations.add(new Mutation(false, columnBname, valueCname));
        batchMutations.add(new BatchMutation(rowAname, rowAmutations));
        ArrayList<Mutation> rowBmutations = new ArrayList<Mutation>();
        rowBmutations.add(new Mutation(false, columnAname, valueCname));
        rowBmutations.add(new Mutation(false, columnBname, valueDname));
        batchMutations.add(new BatchMutation(rowBname, rowBmutations));
        return batchMutations;
    }

    private void closeScanner(int scannerId, ThriftServer.HBaseHandler handler) throws Exception {
        handler.scannerGet(scannerId);
        handler.scannerClose(scannerId);
    }
}

