/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.Bytes;

public class ThriftUtilities {
    public static HColumnDescriptor colDescFromThrift(ColumnDescriptor in) throws IllegalArgument {
        Compression.Algorithm comp = Compression.getCompressionAlgorithmByName(in.compression.toLowerCase());
        boolean bloom = false;
        if (in.bloomFilterType.compareTo("NONE") != 0) {
            bloom = true;
        }
        if (in.name == null || in.name.length <= 0) {
            throw new IllegalArgument("column name is empty");
        }
        HColumnDescriptor col = new HColumnDescriptor(in.name, in.maxVersions, comp.getName(), in.inMemory, in.blockCacheEnabled, in.timeToLive, bloom);
        return col;
    }

    public static ColumnDescriptor colDescFromHbase(HColumnDescriptor in) {
        ColumnDescriptor col = new ColumnDescriptor();
        col.name = in.getName();
        col.maxVersions = in.getMaxVersions();
        col.compression = in.getCompression().toString();
        col.inMemory = in.isInMemory();
        col.blockCacheEnabled = in.isBlockCacheEnabled();
        col.bloomFilterType = Boolean.toString(in.isBloomfilter());
        return col;
    }

    public static List<TCell> cellFromHBase(Cell in) {
        ArrayList<TCell> list = new ArrayList<TCell>(1);
        if (in != null) {
            list.add(new TCell(in.getValue(), in.getTimestamp()));
        }
        return list;
    }

    public static List<TCell> cellFromHBase(Cell[] in) {
        ArrayList<TCell> list = null;
        if (in != null) {
            list = new ArrayList(in.length);
            for (int i = 0; i < in.length; ++i) {
                list.add(new TCell(in[i].getValue(), in[i].getTimestamp()));
            }
        } else {
            list = new ArrayList<TCell>(0);
        }
        return list;
    }

    public static List<TRowResult> rowResultFromHBase(RowResult[] in) {
        ArrayList<TRowResult> results = new ArrayList<TRowResult>();
        for (RowResult result_ : in) {
            if (null == result_) continue;
            TRowResult result = new TRowResult();
            result.row = result_.getRow();
            result.columns = new TreeMap<byte[], TCell>(Bytes.BYTES_COMPARATOR);
            for (Map.Entry<byte[], Cell> entry : result_.entrySet()) {
                Cell cell = entry.getValue();
                result.columns.put(entry.getKey(), new TCell(cell.getValue(), cell.getTimestamp()));
            }
            results.add(result);
        }
        return results;
    }

    public static List<TRowResult> rowResultFromHBase(RowResult in) {
        RowResult[] result = new RowResult[]{in};
        return ThriftUtilities.rowResultFromHBase(result);
    }

    public static List<TRowResult> rowResultFromHBase(Result[] in) {
        ArrayList<TRowResult> results = new ArrayList<TRowResult>();
        for (Result result_ : in) {
            if (null == result_) continue;
            RowResult rowResult_ = result_.getRowResult();
            TRowResult result = new TRowResult();
            result.row = rowResult_.getRow();
            result.columns = new TreeMap<byte[], TCell>(Bytes.BYTES_COMPARATOR);
            for (Map.Entry<byte[], Cell> entry : rowResult_.entrySet()) {
                Cell cell = entry.getValue();
                result.columns.put(entry.getKey(), new TCell(cell.getValue(), cell.getTimestamp()));
            }
            results.add(result);
        }
        return results;
    }

    public static List<TRowResult> rowResultFromHBase(Result in) {
        Result[] result = new Result[]{in};
        return ThriftUtilities.rowResultFromHBase(result);
    }
}

