/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.http.HttpServer;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.webapp.WebAppContext;

public class InfoServer
extends HttpServer {
    public InfoServer(String name, String bindAddress, int port, boolean findPort) throws IOException {
        super(name, bindAddress, port, findPort);
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        if (name.equals("master")) {
            WebAppContext wac = new WebAppContext();
            wac.setContextPath("/api");
            wac.setWar(InfoServer.getWebAppDir("rest"));
            handlers.addHandler((Handler)wac);
        }
        this.webServer.addHandler((Handler)handlers);
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir) throws IOException {
        super.addDefaultApps(parent, appDir);
        String logsContextPath = "/logs";
        Context oldLogsContext = null;
        for (Map.Entry e : this.defaultContexts.entrySet()) {
            if (!((Context)e.getKey()).getContextPath().equals("/logs")) continue;
            oldLogsContext = (Context)e.getKey();
            break;
        }
        this.defaultContexts.put(oldLogsContext, Boolean.FALSE);
        String logDir = System.getProperty("hbase.log.dir");
        if (logDir != null) {
            Context logContext = new Context((HandlerContainer)parent, "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(DefaultServlet.class, "/");
            this.defaultContexts.put(logContext, true);
        }
    }

    protected String getWebAppsPath() throws IOException {
        String master = "master";
        String p = InfoServer.getWebAppDir("master");
        return p.substring(0, p.length() - ("master".length() + 1));
    }

    private static String getWebAppsPath(String path) throws IOException {
        URL url = InfoServer.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new IOException("webapps not found in CLASSPATH: " + path);
        }
        return url.toString();
    }

    public static String getWebAppDir(String webappName) throws IOException {
        String webappDir = null;
        webappDir = InfoServer.getWebAppsPath("webapps/" + webappName);
        return webappDir;
    }
}

