/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Sleeper {
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private final int period;
    private AtomicBoolean stop;

    public Sleeper(int sleep, AtomicBoolean stop) {
        this.period = sleep;
        this.stop = stop;
    }

    public void sleep() {
        this.sleep(System.currentTimeMillis());
    }

    public void sleep(long startTime) {
        if (this.stop.get()) {
            return;
        }
        long now = System.currentTimeMillis();
        long waitTime = (long)this.period - (now - startTime);
        if (waitTime > (long)this.period) {
            this.LOG.warn((Object)("Calculated wait time > " + this.period + "; setting to this.period: " + System.currentTimeMillis() + ", " + startTime));
            waitTime = this.period;
        }
        while (waitTime > 0L) {
            long woke;
            block6: {
                woke = -1L;
                try {
                    Thread.sleep(waitTime);
                    woke = System.currentTimeMillis();
                    long slept = woke - now;
                    if (slept > (long)(10 * this.period)) {
                        this.LOG.warn((Object)("We slept " + slept + "ms, ten times longer than scheduled: " + this.period));
                    }
                }
                catch (InterruptedException iex) {
                    if (!this.stop.get()) break block6;
                    return;
                }
            }
            woke = woke == -1L ? System.currentTimeMillis() : woke;
            waitTime = (long)this.period - (woke - startTime);
        }
    }
}

